@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.GetExposureControlFeatureValuePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property featureName The feature name.
 * @property featureType The feature type.
 * @property locationId The location identifier.
 */
public data class GetExposureControlFeatureValuePlainArgs(
    public val featureName: String? = null,
    public val featureType: String? = null,
    public val locationId: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.GetExposureControlFeatureValuePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.GetExposureControlFeatureValuePlainArgs =
        com.pulumi.azurenative.datafactory.inputs.GetExposureControlFeatureValuePlainArgs.builder()
            .featureName(featureName?.let({ args0 -> args0 }))
            .featureType(featureType?.let({ args0 -> args0 }))
            .locationId(locationId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExposureControlFeatureValuePlainArgs].
 */
@PulumiTagMarker
public class GetExposureControlFeatureValuePlainArgsBuilder internal constructor() {
    private var featureName: String? = null

    private var featureType: String? = null

    private var locationId: String? = null

    /**
     * @param value The feature name.
     */
    @JvmName("acbarjoxhrjuhlxy")
    public suspend fun featureName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.featureName = mapped
    }

    /**
     * @param value The feature type.
     */
    @JvmName("ldgyoyfmrcqmbyiq")
    public suspend fun featureType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.featureType = mapped
    }

    /**
     * @param value The location identifier.
     */
    @JvmName("bihtcjwmaxrrsyxp")
    public suspend fun locationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.locationId = mapped
    }

    internal fun build(): GetExposureControlFeatureValuePlainArgs =
        GetExposureControlFeatureValuePlainArgs(
            featureName = featureName,
            featureType = featureType,
            locationId = locationId ?: throw PulumiNullFieldException("locationId"),
        )
}
