@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.GitHubClientSecretArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Client secret information for factory's bring your own app repository configuration.
 * @property byoaSecretAkvUrl Bring your own app client secret AKV URL.
 * @property byoaSecretName Bring your own app client secret name in AKV.
 */
public data class GitHubClientSecretArgs(
    public val byoaSecretAkvUrl: Output<String>? = null,
    public val byoaSecretName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.GitHubClientSecretArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.GitHubClientSecretArgs =
        com.pulumi.azurenative.datafactory.inputs.GitHubClientSecretArgs.builder()
            .byoaSecretAkvUrl(byoaSecretAkvUrl?.applyValue({ args0 -> args0 }))
            .byoaSecretName(byoaSecretName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GitHubClientSecretArgs].
 */
@PulumiTagMarker
public class GitHubClientSecretArgsBuilder internal constructor() {
    private var byoaSecretAkvUrl: Output<String>? = null

    private var byoaSecretName: Output<String>? = null

    /**
     * @param value Bring your own app client secret AKV URL.
     */
    @JvmName("cgjapdprvwaenbdw")
    public suspend fun byoaSecretAkvUrl(`value`: Output<String>) {
        this.byoaSecretAkvUrl = value
    }

    /**
     * @param value Bring your own app client secret name in AKV.
     */
    @JvmName("pdqugpwolkrseeos")
    public suspend fun byoaSecretName(`value`: Output<String>) {
        this.byoaSecretName = value
    }

    /**
     * @param value Bring your own app client secret AKV URL.
     */
    @JvmName("cdakfauykuipylvi")
    public suspend fun byoaSecretAkvUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.byoaSecretAkvUrl = mapped
    }

    /**
     * @param value Bring your own app client secret name in AKV.
     */
    @JvmName("ywvtffqqboiblyuh")
    public suspend fun byoaSecretName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.byoaSecretName = mapped
    }

    internal fun build(): GitHubClientSecretArgs = GitHubClientSecretArgs(
        byoaSecretAkvUrl = byoaSecretAkvUrl,
        byoaSecretName = byoaSecretName,
    )
}
