@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.GreenplumTableDatasetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Greenplum Database dataset.
 * @property annotations List of tags that can be used for describing the Dataset.
 * @property description Dataset description.
 * @property folder The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
 * @property linkedServiceName Linked service reference.
 * @property parameters Parameters for dataset.
 * @property schema Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
 * @property structure Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
 * @property table The table name of Greenplum. Type: string (or Expression with resultType string).
 * @property tableName This property will be retired. Please consider using schema + table properties instead.
 * @property type Type of dataset.
 * Expected value is 'GreenplumTable'.
 */
public data class GreenplumTableDatasetArgs(
    public val annotations: Output<List<Any>>? = null,
    public val description: Output<String>? = null,
    public val folder: Output<DatasetFolderArgs>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val schema: Output<Any>? = null,
    public val structure: Output<Any>? = null,
    public val table: Output<Any>? = null,
    public val tableName: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.GreenplumTableDatasetArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.GreenplumTableDatasetArgs =
        com.pulumi.azurenative.datafactory.inputs.GreenplumTableDatasetArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .folder(folder?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .linkedServiceName(linkedServiceName.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .schema(schema?.applyValue({ args0 -> args0 }))
            .structure(structure?.applyValue({ args0 -> args0 }))
            .table(table?.applyValue({ args0 -> args0 }))
            .tableName(tableName?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GreenplumTableDatasetArgs].
 */
@PulumiTagMarker
public class GreenplumTableDatasetArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var description: Output<String>? = null

    private var folder: Output<DatasetFolderArgs>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var schema: Output<Any>? = null

    private var structure: Output<Any>? = null

    private var table: Output<Any>? = null

    private var tableName: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the Dataset.
     */
    @JvmName("awnjpuannutnsuql")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("oiudxchvdgqwhhul")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the Dataset.
     */
    @JvmName("wgtprsdjnivqihrv")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value Dataset description.
     */
    @JvmName("pdqfkuogwaoabiyb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("unginehapijqbfrw")
    public suspend fun folder(`value`: Output<DatasetFolderArgs>) {
        this.folder = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("yesyodpsynnrbbak")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value Parameters for dataset.
     */
    @JvmName("dyvfggswxshstuky")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
     */
    @JvmName("bjxyovqoqcnwiuyy")
    public suspend fun schema(`value`: Output<Any>) {
        this.schema = value
    }

    /**
     * @param value Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
     */
    @JvmName("scheremfkrvikqmw")
    public suspend fun structure(`value`: Output<Any>) {
        this.structure = value
    }

    /**
     * @param value The table name of Greenplum. Type: string (or Expression with resultType string).
     */
    @JvmName("dwnhoyskdoqjhcgo")
    public suspend fun table(`value`: Output<Any>) {
        this.table = value
    }

    /**
     * @param value This property will be retired. Please consider using schema + table properties instead.
     */
    @JvmName("upplnjmugcqpgyyf")
    public suspend fun tableName(`value`: Output<Any>) {
        this.tableName = value
    }

    /**
     * @param value Type of dataset.
     * Expected value is 'GreenplumTable'.
     */
    @JvmName("nxsvvwcpabfdhrtk")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the Dataset.
     */
    @JvmName("fkppijrfnwmegxxy")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the Dataset.
     */
    @JvmName("rbogbqlhjgihxqwg")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Dataset description.
     */
    @JvmName("ulacfwekfpcesrwh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("sarrqtpdcuvhnwet")
    public suspend fun folder(`value`: DatasetFolderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folder = mapped
    }

    /**
     * @param argument The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("aupeyagaksuwdaab")
    public suspend fun folder(argument: suspend DatasetFolderArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetFolderArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.folder = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("eabtarfwodwplgkw")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("qwteylqlewbfeejr")
    public suspend
    fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value Parameters for dataset.
     */
    @JvmName("qufmnkqpdwscmfkb")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for dataset.
     */
    @JvmName("qdhrqdfoqgggoquk")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for dataset.
     */
    @JvmName("fgevhtdbgvalamke")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
     */
    @JvmName("adotmlfkifflleie")
    public suspend fun schema(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param value Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
     */
    @JvmName("rlgxxqpogimacwtt")
    public suspend fun structure(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.structure = mapped
    }

    /**
     * @param value The table name of Greenplum. Type: string (or Expression with resultType string).
     */
    @JvmName("bfeqnppdlkeuujsh")
    public suspend fun table(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.table = mapped
    }

    /**
     * @param value This property will be retired. Please consider using schema + table properties instead.
     */
    @JvmName("ccmltpcjcrlojtny")
    public suspend fun tableName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    /**
     * @param value Type of dataset.
     * Expected value is 'GreenplumTable'.
     */
    @JvmName("yprcmjrychjlmdtv")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): GreenplumTableDatasetArgs = GreenplumTableDatasetArgs(
        annotations = annotations,
        description = description,
        folder = folder,
        linkedServiceName = linkedServiceName ?: throw PulumiNullFieldException("linkedServiceName"),
        parameters = parameters,
        schema = schema,
        structure = structure,
        table = table,
        tableName = tableName,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
