@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.HDInsightLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * HDInsight linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property clusterUri HDInsight cluster URI. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property fileSystem Specify the FileSystem if the main storage for the HDInsight is ADLS Gen2. Type: string (or Expression with resultType string).
 * @property hcatalogLinkedServiceName A reference to the Azure SQL linked service that points to the HCatalog database.
 * @property isEspEnabled Specify if the HDInsight is created with ESP (Enterprise Security Package). Type: Boolean.
 * @property linkedServiceName The Azure Storage linked service reference.
 * @property parameters Parameters for linked service.
 * @property password HDInsight cluster password.
 * @property type Type of linked service.
 * Expected value is 'HDInsight'.
 * @property userName HDInsight cluster user name. Type: string (or Expression with resultType string).
 */
public data class HDInsightLinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val clusterUri: Output<Any>,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val fileSystem: Output<Any>? = null,
    public val hcatalogLinkedServiceName: Output<LinkedServiceReferenceArgs>? = null,
    public val isEspEnabled: Output<Any>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val type: Output<String>,
    public val userName: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.HDInsightLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.HDInsightLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.HDInsightLinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .clusterUri(clusterUri.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .fileSystem(fileSystem?.applyValue({ args0 -> args0 }))
            .hcatalogLinkedServiceName(
                hcatalogLinkedServiceName?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .isEspEnabled(isEspEnabled?.applyValue({ args0 -> args0 }))
            .linkedServiceName(linkedServiceName?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(
                password?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HDInsightLinkedServiceArgs].
 */
@PulumiTagMarker
public class HDInsightLinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var clusterUri: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var fileSystem: Output<Any>? = null

    private var hcatalogLinkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var isEspEnabled: Output<Any>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var type: Output<String>? = null

    private var userName: Output<Any>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("lvfkppdqfpbbinxm")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("wqoxmkbtopmkwgst")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("cieemjxlgvlglpnd")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value HDInsight cluster URI. Type: string (or Expression with resultType string).
     */
    @JvmName("leexqsgasiposcta")
    public suspend fun clusterUri(`value`: Output<Any>) {
        this.clusterUri = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("ryjhdcbbowwoqrru")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("ktmxauexrabmlmsd")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("ryylbsnrnuceipfj")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value Specify the FileSystem if the main storage for the HDInsight is ADLS Gen2. Type: string (or Expression with resultType string).
     */
    @JvmName("veyjyirmqwwnqvgs")
    public suspend fun fileSystem(`value`: Output<Any>) {
        this.fileSystem = value
    }

    /**
     * @param value A reference to the Azure SQL linked service that points to the HCatalog database.
     */
    @JvmName("ttjhvbgxcuxtkfqc")
    public suspend fun hcatalogLinkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.hcatalogLinkedServiceName = value
    }

    /**
     * @param value Specify if the HDInsight is created with ESP (Enterprise Security Package). Type: Boolean.
     */
    @JvmName("dsupvnkrbobrqoki")
    public suspend fun isEspEnabled(`value`: Output<Any>) {
        this.isEspEnabled = value
    }

    /**
     * @param value The Azure Storage linked service reference.
     */
    @JvmName("vxbxxpdcjmdfofqy")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("hefkalcaewewixlj")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value HDInsight cluster password.
     */
    @JvmName("jijvpnuvchkomeqf")
    public suspend
    fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'HDInsight'.
     */
    @JvmName("tjugesaususqyrsb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value HDInsight cluster user name. Type: string (or Expression with resultType string).
     */
    @JvmName("rmepcdnwjpoldkib")
    public suspend fun userName(`value`: Output<Any>) {
        this.userName = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("cvvisluapdpnlcyv")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("jvhrbiovashkdact")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value HDInsight cluster URI. Type: string (or Expression with resultType string).
     */
    @JvmName("tiofcemjsejniriw")
    public suspend fun clusterUri(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterUri = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("yghgqttngraiujec")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("yljytgnvrhcmnmur")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("iodbirfrudkjdbie")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("ayybnytfcbyewlhr")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value Specify the FileSystem if the main storage for the HDInsight is ADLS Gen2. Type: string (or Expression with resultType string).
     */
    @JvmName("egbglimwaqpelmxs")
    public suspend fun fileSystem(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystem = mapped
    }

    /**
     * @param value A reference to the Azure SQL linked service that points to the HCatalog database.
     */
    @JvmName("epllhwixdbbymthw")
    public suspend fun hcatalogLinkedServiceName(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hcatalogLinkedServiceName = mapped
    }

    /**
     * @param argument A reference to the Azure SQL linked service that points to the HCatalog database.
     */
    @JvmName("ndxprrilxrnweigq")
    public suspend
    fun hcatalogLinkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hcatalogLinkedServiceName = mapped
    }

    /**
     * @param value Specify if the HDInsight is created with ESP (Enterprise Security Package). Type: Boolean.
     */
    @JvmName("xrmcuqyqspdlacmj")
    public suspend fun isEspEnabled(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEspEnabled = mapped
    }

    /**
     * @param value The Azure Storage linked service reference.
     */
    @JvmName("swugubcmcjmpwfcp")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument The Azure Storage linked service reference.
     */
    @JvmName("xivonlruvbypmbap")
    public suspend
    fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("vsqvhxvkodgjqhow")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("xfypbrtgtvmjevgt")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("jmjvsgewwmrepcem")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value HDInsight cluster password.
     */
    @JvmName("pcregugfppobibbn")
    public suspend
    fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value HDInsight cluster password.
     */
    @JvmName("pgvarmimmkpambod")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value HDInsight cluster password.
     */
    @JvmName("cdfeewifrshdhmwc")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'HDInsight'.
     */
    @JvmName("lwxxjvrnkiwponts")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value HDInsight cluster user name. Type: string (or Expression with resultType string).
     */
    @JvmName("twudorffabsyocrv")
    public suspend fun userName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): HDInsightLinkedServiceArgs = HDInsightLinkedServiceArgs(
        annotations = annotations,
        clusterUri = clusterUri ?: throw PulumiNullFieldException("clusterUri"),
        connectVia = connectVia,
        description = description,
        encryptedCredential = encryptedCredential,
        fileSystem = fileSystem,
        hcatalogLinkedServiceName = hcatalogLinkedServiceName,
        isEspEnabled = isEspEnabled,
        linkedServiceName = linkedServiceName,
        parameters = parameters,
        password = password,
        type = type ?: throw PulumiNullFieldException("type"),
        userName = userName,
    )
}
