@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.HDInsightMapReduceActivityArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityOnInactiveMarkAs
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityState
import com.pulumi.azurenative.datafactory.kotlin.enums.HDInsightActivityDebugInfoOption
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * HDInsight MapReduce activity type.
 * @property arguments User specified arguments to HDInsightActivity.
 * @property className Class name. Type: string (or Expression with resultType string).
 * @property defines Allows user to specify defines for the MapReduce job request.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property getDebugInfo Debug info option.
 * @property jarFilePath Jar path. Type: string (or Expression with resultType string).
 * @property jarLibs Jar libs.
 * @property jarLinkedService Jar linked service reference.
 * @property linkedServiceName Linked service reference.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property policy Activity policy.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property storageLinkedServices Storage linked service references.
 * @property type Type of activity.
 * Expected value is 'HDInsightMapReduce'.
 * @property userProperties Activity user properties.
 */
public data class HDInsightMapReduceActivityArgs(
    public val arguments: Output<List<Any>>? = null,
    public val className: Output<Any>,
    public val defines: Output<Map<String, Any>>? = null,
    public val dependsOn: Output<List<ActivityDependencyArgs>>? = null,
    public val description: Output<String>? = null,
    public val getDebugInfo: Output<Either<String, HDInsightActivityDebugInfoOption>>? = null,
    public val jarFilePath: Output<Any>,
    public val jarLibs: Output<List<Any>>? = null,
    public val jarLinkedService: Output<LinkedServiceReferenceArgs>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>? = null,
    public val name: Output<String>,
    public val onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null,
    public val policy: Output<ActivityPolicyArgs>? = null,
    public val state: Output<Either<String, ActivityState>>? = null,
    public val storageLinkedServices: Output<List<LinkedServiceReferenceArgs>>? = null,
    public val type: Output<String>,
    public val userProperties: Output<List<UserPropertyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.HDInsightMapReduceActivityArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.HDInsightMapReduceActivityArgs =
        com.pulumi.azurenative.datafactory.inputs.HDInsightMapReduceActivityArgs.builder()
            .arguments(arguments?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .className(className.applyValue({ args0 -> args0 }))
            .defines(defines?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .dependsOn(
                dependsOn?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .getDebugInfo(
                getDebugInfo?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .jarFilePath(jarFilePath.applyValue({ args0 -> args0 }))
            .jarLibs(jarLibs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .jarLinkedService(jarLinkedService?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .linkedServiceName(linkedServiceName?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .onInactiveMarkAs(
                onInactiveMarkAs?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .policy(policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .storageLinkedServices(
                storageLinkedServices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .userProperties(
                userProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [HDInsightMapReduceActivityArgs].
 */
@PulumiTagMarker
public class HDInsightMapReduceActivityArgsBuilder internal constructor() {
    private var arguments: Output<List<Any>>? = null

    private var className: Output<Any>? = null

    private var defines: Output<Map<String, Any>>? = null

    private var dependsOn: Output<List<ActivityDependencyArgs>>? = null

    private var description: Output<String>? = null

    private var getDebugInfo: Output<Either<String, HDInsightActivityDebugInfoOption>>? = null

    private var jarFilePath: Output<Any>? = null

    private var jarLibs: Output<List<Any>>? = null

    private var jarLinkedService: Output<LinkedServiceReferenceArgs>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var name: Output<String>? = null

    private var onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null

    private var policy: Output<ActivityPolicyArgs>? = null

    private var state: Output<Either<String, ActivityState>>? = null

    private var storageLinkedServices: Output<List<LinkedServiceReferenceArgs>>? = null

    private var type: Output<String>? = null

    private var userProperties: Output<List<UserPropertyArgs>>? = null

    /**
     * @param value User specified arguments to HDInsightActivity.
     */
    @JvmName("vsxkpqtlxffojrxn")
    public suspend fun arguments(`value`: Output<List<Any>>) {
        this.arguments = value
    }

    @JvmName("fscupshiripubdtj")
    public suspend fun arguments(vararg values: Output<Any>) {
        this.arguments = Output.all(values.asList())
    }

    /**
     * @param values User specified arguments to HDInsightActivity.
     */
    @JvmName("cxhcllosbfrxuuwa")
    public suspend fun arguments(values: List<Output<Any>>) {
        this.arguments = Output.all(values)
    }

    /**
     * @param value Class name. Type: string (or Expression with resultType string).
     */
    @JvmName("drgjdajepmkadmne")
    public suspend fun className(`value`: Output<Any>) {
        this.className = value
    }

    /**
     * @param value Allows user to specify defines for the MapReduce job request.
     */
    @JvmName("qvstlbidhsapwpea")
    public suspend fun defines(`value`: Output<Map<String, Any>>) {
        this.defines = value
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("pkcldcatkbilwwmy")
    public suspend fun dependsOn(`value`: Output<List<ActivityDependencyArgs>>) {
        this.dependsOn = value
    }

    @JvmName("jgsbxbrdjethslfh")
    public suspend fun dependsOn(vararg values: Output<ActivityDependencyArgs>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("omayhrcupybqoclr")
    public suspend fun dependsOn(values: List<Output<ActivityDependencyArgs>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Activity description.
     */
    @JvmName("gaxarfercvangaoi")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Debug info option.
     */
    @JvmName("ftxjtkcksqvyccfu")
    public suspend
    fun getDebugInfo(`value`: Output<Either<String, HDInsightActivityDebugInfoOption>>) {
        this.getDebugInfo = value
    }

    /**
     * @param value Jar path. Type: string (or Expression with resultType string).
     */
    @JvmName("edevpbguyussfufu")
    public suspend fun jarFilePath(`value`: Output<Any>) {
        this.jarFilePath = value
    }

    /**
     * @param value Jar libs.
     */
    @JvmName("bbifixyfkuyxvtjw")
    public suspend fun jarLibs(`value`: Output<List<Any>>) {
        this.jarLibs = value
    }

    @JvmName("qyynundqjkgtqemc")
    public suspend fun jarLibs(vararg values: Output<Any>) {
        this.jarLibs = Output.all(values.asList())
    }

    /**
     * @param values Jar libs.
     */
    @JvmName("iuladxmjqxhhaeef")
    public suspend fun jarLibs(values: List<Output<Any>>) {
        this.jarLibs = Output.all(values)
    }

    /**
     * @param value Jar linked service reference.
     */
    @JvmName("xyqqniofgmujbtig")
    public suspend fun jarLinkedService(`value`: Output<LinkedServiceReferenceArgs>) {
        this.jarLinkedService = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("iqekjxkytaoekffp")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value Activity name.
     */
    @JvmName("udpxxkqaenaaciyj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("judxaslcjxtslrgq")
    public suspend fun onInactiveMarkAs(`value`: Output<Either<String, ActivityOnInactiveMarkAs>>) {
        this.onInactiveMarkAs = value
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("hiiudnhvtvarvrqd")
    public suspend fun policy(`value`: Output<ActivityPolicyArgs>) {
        this.policy = value
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("rsgkxiblrrairyww")
    public suspend fun state(`value`: Output<Either<String, ActivityState>>) {
        this.state = value
    }

    /**
     * @param value Storage linked service references.
     */
    @JvmName("hpxmcgdkindhlshu")
    public suspend fun storageLinkedServices(`value`: Output<List<LinkedServiceReferenceArgs>>) {
        this.storageLinkedServices = value
    }

    @JvmName("jkbtojqloouryxke")
    public suspend fun storageLinkedServices(vararg values: Output<LinkedServiceReferenceArgs>) {
        this.storageLinkedServices = Output.all(values.asList())
    }

    /**
     * @param values Storage linked service references.
     */
    @JvmName("waaxawgxoaiwalaq")
    public suspend fun storageLinkedServices(values: List<Output<LinkedServiceReferenceArgs>>) {
        this.storageLinkedServices = Output.all(values)
    }

    /**
     * @param value Type of activity.
     * Expected value is 'HDInsightMapReduce'.
     */
    @JvmName("tjbvxdthvhvtdixq")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("rdmnqpivwocorlil")
    public suspend fun userProperties(`value`: Output<List<UserPropertyArgs>>) {
        this.userProperties = value
    }

    @JvmName("hhrglwkaildcgldv")
    public suspend fun userProperties(vararg values: Output<UserPropertyArgs>) {
        this.userProperties = Output.all(values.asList())
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("yvyjdgddwlxbpntq")
    public suspend fun userProperties(values: List<Output<UserPropertyArgs>>) {
        this.userProperties = Output.all(values)
    }

    /**
     * @param value User specified arguments to HDInsightActivity.
     */
    @JvmName("prttdtjbbcpmyoum")
    public suspend fun arguments(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param values User specified arguments to HDInsightActivity.
     */
    @JvmName("nbkvwixxcpawwoot")
    public suspend fun arguments(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param value Class name. Type: string (or Expression with resultType string).
     */
    @JvmName("ovelvsotljswltam")
    public suspend fun className(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.className = mapped
    }

    /**
     * @param value Allows user to specify defines for the MapReduce job request.
     */
    @JvmName("rwcjylqfrnbguxil")
    public suspend fun defines(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defines = mapped
    }

    /**
     * @param values Allows user to specify defines for the MapReduce job request.
     */
    @JvmName("eioxtciclmaqvans")
    public fun defines(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defines = mapped
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("gpfnsfrfxujinien")
    public suspend fun dependsOn(`value`: List<ActivityDependencyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("vigphvjofxngdaoa")
    public suspend fun dependsOn(argument: List<suspend ActivityDependencyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("uawqeoquebspwsxp")
    public suspend fun dependsOn(vararg argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("chydiqwschrngnfx")
    public suspend fun dependsOn(argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ActivityDependencyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("xjqdpjopeyshvxlc")
    public suspend fun dependsOn(vararg values: ActivityDependencyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Activity description.
     */
    @JvmName("wqvbgnjpmkcinmmg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Debug info option.
     */
    @JvmName("movuqlaporinqecf")
    public suspend fun getDebugInfo(`value`: Either<String, HDInsightActivityDebugInfoOption>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.getDebugInfo = mapped
    }

    /**
     * @param value Debug info option.
     */
    @JvmName("klvvuyoffooynkhb")
    public fun getDebugInfo(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HDInsightActivityDebugInfoOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.getDebugInfo = mapped
    }

    /**
     * @param value Debug info option.
     */
    @JvmName("pigsahmffsohrubr")
    public fun getDebugInfo(`value`: HDInsightActivityDebugInfoOption) {
        val toBeMapped = Either.ofRight<String, HDInsightActivityDebugInfoOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.getDebugInfo = mapped
    }

    /**
     * @param value Jar path. Type: string (or Expression with resultType string).
     */
    @JvmName("toueccaiqdihgepg")
    public suspend fun jarFilePath(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jarFilePath = mapped
    }

    /**
     * @param value Jar libs.
     */
    @JvmName("kcraiwkqclncwfww")
    public suspend fun jarLibs(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jarLibs = mapped
    }

    /**
     * @param values Jar libs.
     */
    @JvmName("gcpypfkwqmwudtuh")
    public suspend fun jarLibs(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jarLibs = mapped
    }

    /**
     * @param value Jar linked service reference.
     */
    @JvmName("uuqrlsoiikjeusih")
    public suspend fun jarLinkedService(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jarLinkedService = mapped
    }

    /**
     * @param argument Jar linked service reference.
     */
    @JvmName("xdmujhtlnwkkmdve")
    public suspend
    fun jarLinkedService(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.jarLinkedService = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("mbycbqqinbgdwlgg")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("hilubljjfdrglkfg")
    public suspend
    fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value Activity name.
     */
    @JvmName("asciviwpughqfylk")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("nvxrtaqgqsilnedu")
    public suspend fun onInactiveMarkAs(`value`: Either<String, ActivityOnInactiveMarkAs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("udijgfgpxdeqohfk")
    public fun onInactiveMarkAs(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("cuuqyfgmupshbkqr")
    public fun onInactiveMarkAs(`value`: ActivityOnInactiveMarkAs) {
        val toBeMapped = Either.ofRight<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("wqilyeopemscdtfv")
    public suspend fun policy(`value`: ActivityPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param argument Activity policy.
     */
    @JvmName("yxrsgmkmowbmptrv")
    public suspend fun policy(argument: suspend ActivityPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ActivityPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policy = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("iiqphqrekcvetain")
    public suspend fun state(`value`: Either<String, ActivityState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("wrirnppkaknomamr")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("ddfgqwttbfgvvehb")
    public fun state(`value`: ActivityState) {
        val toBeMapped = Either.ofRight<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Storage linked service references.
     */
    @JvmName("rjaeflgvhtcuoajd")
    public suspend fun storageLinkedServices(`value`: List<LinkedServiceReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageLinkedServices = mapped
    }

    /**
     * @param argument Storage linked service references.
     */
    @JvmName("ibapciljyhnymcfp")
    public suspend
    fun storageLinkedServices(argument: List<suspend LinkedServiceReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LinkedServiceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageLinkedServices = mapped
    }

    /**
     * @param argument Storage linked service references.
     */
    @JvmName("nqlcjwwfhfbujxon")
    public suspend fun storageLinkedServices(
        vararg
        argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LinkedServiceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageLinkedServices = mapped
    }

    /**
     * @param argument Storage linked service references.
     */
    @JvmName("pyrhppktjyrocieo")
    public suspend
    fun storageLinkedServices(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.storageLinkedServices = mapped
    }

    /**
     * @param values Storage linked service references.
     */
    @JvmName("cxqxbncarlekycpf")
    public suspend fun storageLinkedServices(vararg values: LinkedServiceReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageLinkedServices = mapped
    }

    /**
     * @param value Type of activity.
     * Expected value is 'HDInsightMapReduce'.
     */
    @JvmName("edwnxcrxfcptrxmj")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("yaoxrjqglvdaffkm")
    public suspend fun userProperties(`value`: List<UserPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("tgahrautnboksvwo")
    public suspend fun userProperties(argument: List<suspend UserPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("xjoafelqqfuhbwur")
    public suspend fun userProperties(vararg argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("mlawdxxsgpycrkty")
    public suspend fun userProperties(argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserPropertyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("jeqgaltpthddmiwn")
    public suspend fun userProperties(vararg values: UserPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    internal fun build(): HDInsightMapReduceActivityArgs = HDInsightMapReduceActivityArgs(
        arguments = arguments,
        className = className ?: throw PulumiNullFieldException("className"),
        defines = defines,
        dependsOn = dependsOn,
        description = description,
        getDebugInfo = getDebugInfo,
        jarFilePath = jarFilePath ?: throw PulumiNullFieldException("jarFilePath"),
        jarLibs = jarLibs,
        jarLinkedService = jarLinkedService,
        linkedServiceName = linkedServiceName,
        name = name ?: throw PulumiNullFieldException("name"),
        onInactiveMarkAs = onInactiveMarkAs,
        policy = policy,
        state = state,
        storageLinkedServices = storageLinkedServices,
        type = type ?: throw PulumiNullFieldException("type"),
        userProperties = userProperties,
    )
}
