@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.HDInsightOnDemandLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * HDInsight ondemand linked service.
 * @property additionalLinkedServiceNames Specifies additional storage accounts for the HDInsight linked service so that the Data Factory service can register them on your behalf.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property clusterNamePrefix The prefix of cluster name, postfix will be distinct with timestamp. Type: string (or Expression with resultType string).
 * @property clusterPassword The password to access the cluster.
 * @property clusterResourceGroup The resource group where the cluster belongs. Type: string (or Expression with resultType string).
 * @property clusterSize Number of worker/data nodes in the cluster. Suggestion value: 4. Type: int (or Expression with resultType int).
 * @property clusterSshPassword The password to SSH remotely connect cluster’s node (for Linux).
 * @property clusterSshUserName The username to SSH remotely connect to cluster’s node (for Linux). Type: string (or Expression with resultType string).
 * @property clusterType The cluster type. Type: string (or Expression with resultType string).
 * @property clusterUserName The username to access the cluster. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property coreConfiguration Specifies the core configuration parameters (as in core-site.xml) for the HDInsight cluster to be created.
 * @property credential The credential reference containing authentication information.
 * @property dataNodeSize Specifies the size of the data node for the HDInsight cluster.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property hBaseConfiguration Specifies the HBase configuration parameters (hbase-site.xml) for the HDInsight cluster.
 * @property hcatalogLinkedServiceName The name of Azure SQL linked service that point to the HCatalog database. The on-demand HDInsight cluster is created by using the Azure SQL database as the metastore.
 * @property hdfsConfiguration Specifies the HDFS configuration parameters (hdfs-site.xml) for the HDInsight cluster.
 * @property headNodeSize Specifies the size of the head node for the HDInsight cluster.
 * @property hiveConfiguration Specifies the hive configuration parameters (hive-site.xml) for the HDInsight cluster.
 * @property hostSubscriptionId The customer’s subscription to host the cluster. Type: string (or Expression with resultType string).
 * @property linkedServiceName Azure Storage linked service to be used by the on-demand cluster for storing and processing data.
 * @property mapReduceConfiguration Specifies the MapReduce configuration parameters (mapred-site.xml) for the HDInsight cluster.
 * @property oozieConfiguration Specifies the Oozie configuration parameters (oozie-site.xml) for the HDInsight cluster.
 * @property parameters Parameters for linked service.
 * @property scriptActions Custom script actions to run on HDI ondemand cluster once it's up. Please refer to https://docs.microsoft.com/en-us/azure/hdinsight/hdinsight-hadoop-customize-cluster-linux?toc=%2Fen-us%2Fazure%2Fhdinsight%2Fr-server%2FTOC.json&bc=%2Fen-us%2Fazure%2Fbread%2Ftoc.json#understanding-script-actions.
 * @property servicePrincipalId The service principal id for the hostSubscriptionId. Type: string (or Expression with resultType string).
 * @property servicePrincipalKey The key for the service principal id.
 * @property sparkVersion The version of spark if the cluster type is 'spark'. Type: string (or Expression with resultType string).
 * @property stormConfiguration Specifies the Storm configuration parameters (storm-site.xml) for the HDInsight cluster.
 * @property subnetName The ARM resource ID for the subnet in the vNet. If virtualNetworkId was specified, then this property is required. Type: string (or Expression with resultType string).
 * @property tenant The Tenant id/name to which the service principal belongs. Type: string (or Expression with resultType string).
 * @property timeToLive The allowed idle time for the on-demand HDInsight cluster. Specifies how long the on-demand HDInsight cluster stays alive after completion of an activity run if there are no other active jobs in the cluster. The minimum value is 5 mins. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'HDInsightOnDemand'.
 * @property version Version of the HDInsight cluster.  Type: string (or Expression with resultType string).
 * @property virtualNetworkId The ARM resource ID for the vNet to which the cluster should be joined after creation. Type: string (or Expression with resultType string).
 * @property yarnConfiguration Specifies the Yarn configuration parameters (yarn-site.xml) for the HDInsight cluster.
 * @property zookeeperNodeSize Specifies the size of the Zoo Keeper node for the HDInsight cluster.
 */
public data class HDInsightOnDemandLinkedServiceArgs(
    public val additionalLinkedServiceNames: Output<List<LinkedServiceReferenceArgs>>? = null,
    public val annotations: Output<List<Any>>? = null,
    public val clusterNamePrefix: Output<Any>? = null,
    public val clusterPassword: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val clusterResourceGroup: Output<Any>,
    public val clusterSize: Output<Any>,
    public val clusterSshPassword: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val clusterSshUserName: Output<Any>? = null,
    public val clusterType: Output<Any>? = null,
    public val clusterUserName: Output<Any>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val coreConfiguration: Output<Any>? = null,
    public val credential: Output<CredentialReferenceArgs>? = null,
    public val dataNodeSize: Output<Any>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val hBaseConfiguration: Output<Any>? = null,
    public val hcatalogLinkedServiceName: Output<LinkedServiceReferenceArgs>? = null,
    public val hdfsConfiguration: Output<Any>? = null,
    public val headNodeSize: Output<Any>? = null,
    public val hiveConfiguration: Output<Any>? = null,
    public val hostSubscriptionId: Output<Any>,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>,
    public val mapReduceConfiguration: Output<Any>? = null,
    public val oozieConfiguration: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val scriptActions: Output<List<ScriptActionArgs>>? = null,
    public val servicePrincipalId: Output<Any>? = null,
    public val servicePrincipalKey:
    Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val sparkVersion: Output<Any>? = null,
    public val stormConfiguration: Output<Any>? = null,
    public val subnetName: Output<Any>? = null,
    public val tenant: Output<Any>,
    public val timeToLive: Output<Any>,
    public val type: Output<String>,
    public val version: Output<Any>,
    public val virtualNetworkId: Output<Any>? = null,
    public val yarnConfiguration: Output<Any>? = null,
    public val zookeeperNodeSize: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.HDInsightOnDemandLinkedServiceArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.HDInsightOnDemandLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.HDInsightOnDemandLinkedServiceArgs.builder()
            .additionalLinkedServiceNames(
                additionalLinkedServiceNames?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .clusterNamePrefix(clusterNamePrefix?.applyValue({ args0 -> args0 }))
            .clusterPassword(
                clusterPassword?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .clusterResourceGroup(clusterResourceGroup.applyValue({ args0 -> args0 }))
            .clusterSize(clusterSize.applyValue({ args0 -> args0 }))
            .clusterSshPassword(
                clusterSshPassword?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .clusterSshUserName(clusterSshUserName?.applyValue({ args0 -> args0 }))
            .clusterType(clusterType?.applyValue({ args0 -> args0 }))
            .clusterUserName(clusterUserName?.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .coreConfiguration(coreConfiguration?.applyValue({ args0 -> args0 }))
            .credential(credential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dataNodeSize(dataNodeSize?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .hBaseConfiguration(hBaseConfiguration?.applyValue({ args0 -> args0 }))
            .hcatalogLinkedServiceName(
                hcatalogLinkedServiceName?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .hdfsConfiguration(hdfsConfiguration?.applyValue({ args0 -> args0 }))
            .headNodeSize(headNodeSize?.applyValue({ args0 -> args0 }))
            .hiveConfiguration(hiveConfiguration?.applyValue({ args0 -> args0 }))
            .hostSubscriptionId(hostSubscriptionId.applyValue({ args0 -> args0 }))
            .linkedServiceName(linkedServiceName.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .mapReduceConfiguration(mapReduceConfiguration?.applyValue({ args0 -> args0 }))
            .oozieConfiguration(oozieConfiguration?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .scriptActions(
                scriptActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .servicePrincipalId(servicePrincipalId?.applyValue({ args0 -> args0 }))
            .servicePrincipalKey(
                servicePrincipalKey?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .sparkVersion(sparkVersion?.applyValue({ args0 -> args0 }))
            .stormConfiguration(stormConfiguration?.applyValue({ args0 -> args0 }))
            .subnetName(subnetName?.applyValue({ args0 -> args0 }))
            .tenant(tenant.applyValue({ args0 -> args0 }))
            .timeToLive(timeToLive.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .version(version.applyValue({ args0 -> args0 }))
            .virtualNetworkId(virtualNetworkId?.applyValue({ args0 -> args0 }))
            .yarnConfiguration(yarnConfiguration?.applyValue({ args0 -> args0 }))
            .zookeeperNodeSize(zookeeperNodeSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HDInsightOnDemandLinkedServiceArgs].
 */
@PulumiTagMarker
public class HDInsightOnDemandLinkedServiceArgsBuilder internal constructor() {
    private var additionalLinkedServiceNames: Output<List<LinkedServiceReferenceArgs>>? = null

    private var annotations: Output<List<Any>>? = null

    private var clusterNamePrefix: Output<Any>? = null

    private var clusterPassword: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var clusterResourceGroup: Output<Any>? = null

    private var clusterSize: Output<Any>? = null

    private var clusterSshPassword:
        Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var clusterSshUserName: Output<Any>? = null

    private var clusterType: Output<Any>? = null

    private var clusterUserName: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var coreConfiguration: Output<Any>? = null

    private var credential: Output<CredentialReferenceArgs>? = null

    private var dataNodeSize: Output<Any>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var hBaseConfiguration: Output<Any>? = null

    private var hcatalogLinkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var hdfsConfiguration: Output<Any>? = null

    private var headNodeSize: Output<Any>? = null

    private var hiveConfiguration: Output<Any>? = null

    private var hostSubscriptionId: Output<Any>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var mapReduceConfiguration: Output<Any>? = null

    private var oozieConfiguration: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var scriptActions: Output<List<ScriptActionArgs>>? = null

    private var servicePrincipalId: Output<Any>? = null

    private var servicePrincipalKey:
        Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var sparkVersion: Output<Any>? = null

    private var stormConfiguration: Output<Any>? = null

    private var subnetName: Output<Any>? = null

    private var tenant: Output<Any>? = null

    private var timeToLive: Output<Any>? = null

    private var type: Output<String>? = null

    private var version: Output<Any>? = null

    private var virtualNetworkId: Output<Any>? = null

    private var yarnConfiguration: Output<Any>? = null

    private var zookeeperNodeSize: Output<Any>? = null

    /**
     * @param value Specifies additional storage accounts for the HDInsight linked service so that the Data Factory service can register them on your behalf.
     */
    @JvmName("yffkffesecahrnob")
    public suspend
    fun additionalLinkedServiceNames(`value`: Output<List<LinkedServiceReferenceArgs>>) {
        this.additionalLinkedServiceNames = value
    }

    @JvmName("lwdcjsrxaeubxvwg")
    public suspend fun additionalLinkedServiceNames(
        vararg
        values: Output<LinkedServiceReferenceArgs>,
    ) {
        this.additionalLinkedServiceNames = Output.all(values.asList())
    }

    /**
     * @param values Specifies additional storage accounts for the HDInsight linked service so that the Data Factory service can register them on your behalf.
     */
    @JvmName("oisdnhrghysxcuvs")
    public suspend
    fun additionalLinkedServiceNames(values: List<Output<LinkedServiceReferenceArgs>>) {
        this.additionalLinkedServiceNames = Output.all(values)
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("pkseokpkimpsiove")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("tmfsmjroydhehidj")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("wytinbvnynepxptw")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The prefix of cluster name, postfix will be distinct with timestamp. Type: string (or Expression with resultType string).
     */
    @JvmName("dinbbxqxitfpkpky")
    public suspend fun clusterNamePrefix(`value`: Output<Any>) {
        this.clusterNamePrefix = value
    }

    /**
     * @param value The password to access the cluster.
     */
    @JvmName("bfdwkfqqbcqklhsr")
    public suspend
    fun clusterPassword(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.clusterPassword = value
    }

    /**
     * @param value The resource group where the cluster belongs. Type: string (or Expression with resultType string).
     */
    @JvmName("mcbrirkhrtcpatik")
    public suspend fun clusterResourceGroup(`value`: Output<Any>) {
        this.clusterResourceGroup = value
    }

    /**
     * @param value Number of worker/data nodes in the cluster. Suggestion value: 4. Type: int (or Expression with resultType int).
     */
    @JvmName("oxreuugmoxlaijdp")
    public suspend fun clusterSize(`value`: Output<Any>) {
        this.clusterSize = value
    }

    /**
     * @param value The password to SSH remotely connect cluster’s node (for Linux).
     */
    @JvmName("ykbifmdmxvxwvpup")
    public suspend
    fun clusterSshPassword(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.clusterSshPassword = value
    }

    /**
     * @param value The username to SSH remotely connect to cluster’s node (for Linux). Type: string (or Expression with resultType string).
     */
    @JvmName("jjpulptkxvggrrxt")
    public suspend fun clusterSshUserName(`value`: Output<Any>) {
        this.clusterSshUserName = value
    }

    /**
     * @param value The cluster type. Type: string (or Expression with resultType string).
     */
    @JvmName("mniftnqxdfphdjwi")
    public suspend fun clusterType(`value`: Output<Any>) {
        this.clusterType = value
    }

    /**
     * @param value The username to access the cluster. Type: string (or Expression with resultType string).
     */
    @JvmName("kpwtkwibaqtclyds")
    public suspend fun clusterUserName(`value`: Output<Any>) {
        this.clusterUserName = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("vvoquywqsufeivlk")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Specifies the core configuration parameters (as in core-site.xml) for the HDInsight cluster to be created.
     */
    @JvmName("iiqkillignrcilfv")
    public suspend fun coreConfiguration(`value`: Output<Any>) {
        this.coreConfiguration = value
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("sdvtchdlggavvtqh")
    public suspend fun credential(`value`: Output<CredentialReferenceArgs>) {
        this.credential = value
    }

    /**
     * @param value Specifies the size of the data node for the HDInsight cluster.
     */
    @JvmName("bqwkdydaelywxxdp")
    public suspend fun dataNodeSize(`value`: Output<Any>) {
        this.dataNodeSize = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("jpykxfvwvqmutejj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("emqdsahdypybcjtp")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value Specifies the HBase configuration parameters (hbase-site.xml) for the HDInsight cluster.
     */
    @JvmName("lcemmvnfackoolgf")
    public suspend fun hBaseConfiguration(`value`: Output<Any>) {
        this.hBaseConfiguration = value
    }

    /**
     * @param value The name of Azure SQL linked service that point to the HCatalog database. The on-demand HDInsight cluster is created by using the Azure SQL database as the metastore.
     */
    @JvmName("erbdsttbwoulshau")
    public suspend fun hcatalogLinkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.hcatalogLinkedServiceName = value
    }

    /**
     * @param value Specifies the HDFS configuration parameters (hdfs-site.xml) for the HDInsight cluster.
     */
    @JvmName("jfnpnxomgwiousee")
    public suspend fun hdfsConfiguration(`value`: Output<Any>) {
        this.hdfsConfiguration = value
    }

    /**
     * @param value Specifies the size of the head node for the HDInsight cluster.
     */
    @JvmName("ugqqflaqplpnjcir")
    public suspend fun headNodeSize(`value`: Output<Any>) {
        this.headNodeSize = value
    }

    /**
     * @param value Specifies the hive configuration parameters (hive-site.xml) for the HDInsight cluster.
     */
    @JvmName("akymilmhusnhsluu")
    public suspend fun hiveConfiguration(`value`: Output<Any>) {
        this.hiveConfiguration = value
    }

    /**
     * @param value The customer’s subscription to host the cluster. Type: string (or Expression with resultType string).
     */
    @JvmName("gdrcipuuuyrmcnmj")
    public suspend fun hostSubscriptionId(`value`: Output<Any>) {
        this.hostSubscriptionId = value
    }

    /**
     * @param value Azure Storage linked service to be used by the on-demand cluster for storing and processing data.
     */
    @JvmName("kkqvcsgisdnitmyv")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value Specifies the MapReduce configuration parameters (mapred-site.xml) for the HDInsight cluster.
     */
    @JvmName("nsjgcryygcybsmhq")
    public suspend fun mapReduceConfiguration(`value`: Output<Any>) {
        this.mapReduceConfiguration = value
    }

    /**
     * @param value Specifies the Oozie configuration parameters (oozie-site.xml) for the HDInsight cluster.
     */
    @JvmName("sovhvaohopknpuls")
    public suspend fun oozieConfiguration(`value`: Output<Any>) {
        this.oozieConfiguration = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("ogwnkwwbfmwhiguy")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Custom script actions to run on HDI ondemand cluster once it's up. Please refer to https://docs.microsoft.com/en-us/azure/hdinsight/hdinsight-hadoop-customize-cluster-linux?toc=%2Fen-us%2Fazure%2Fhdinsight%2Fr-server%2FTOC.json&bc=%2Fen-us%2Fazure%2Fbread%2Ftoc.json#understanding-script-actions.
     */
    @JvmName("txidfqttyinsxhmu")
    public suspend fun scriptActions(`value`: Output<List<ScriptActionArgs>>) {
        this.scriptActions = value
    }

    @JvmName("fystldvxnlsbbxom")
    public suspend fun scriptActions(vararg values: Output<ScriptActionArgs>) {
        this.scriptActions = Output.all(values.asList())
    }

    /**
     * @param values Custom script actions to run on HDI ondemand cluster once it's up. Please refer to https://docs.microsoft.com/en-us/azure/hdinsight/hdinsight-hadoop-customize-cluster-linux?toc=%2Fen-us%2Fazure%2Fhdinsight%2Fr-server%2FTOC.json&bc=%2Fen-us%2Fazure%2Fbread%2Ftoc.json#understanding-script-actions.
     */
    @JvmName("dchvirwpktntihcg")
    public suspend fun scriptActions(values: List<Output<ScriptActionArgs>>) {
        this.scriptActions = Output.all(values)
    }

    /**
     * @param value The service principal id for the hostSubscriptionId. Type: string (or Expression with resultType string).
     */
    @JvmName("itucboxfhcxcgtnm")
    public suspend fun servicePrincipalId(`value`: Output<Any>) {
        this.servicePrincipalId = value
    }

    /**
     * @param value The key for the service principal id.
     */
    @JvmName("lpurhaqlrjdkxctu")
    public suspend
    fun servicePrincipalKey(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.servicePrincipalKey = value
    }

    /**
     * @param value The version of spark if the cluster type is 'spark'. Type: string (or Expression with resultType string).
     */
    @JvmName("pdystycujwinfgxi")
    public suspend fun sparkVersion(`value`: Output<Any>) {
        this.sparkVersion = value
    }

    /**
     * @param value Specifies the Storm configuration parameters (storm-site.xml) for the HDInsight cluster.
     */
    @JvmName("vnjtfxdgxucjpdww")
    public suspend fun stormConfiguration(`value`: Output<Any>) {
        this.stormConfiguration = value
    }

    /**
     * @param value The ARM resource ID for the subnet in the vNet. If virtualNetworkId was specified, then this property is required. Type: string (or Expression with resultType string).
     */
    @JvmName("vmpxjfoqqxkbhmha")
    public suspend fun subnetName(`value`: Output<Any>) {
        this.subnetName = value
    }

    /**
     * @param value The Tenant id/name to which the service principal belongs. Type: string (or Expression with resultType string).
     */
    @JvmName("qdfpaxecsfvscsba")
    public suspend fun tenant(`value`: Output<Any>) {
        this.tenant = value
    }

    /**
     * @param value The allowed idle time for the on-demand HDInsight cluster. Specifies how long the on-demand HDInsight cluster stays alive after completion of an activity run if there are no other active jobs in the cluster. The minimum value is 5 mins. Type: string (or Expression with resultType string).
     */
    @JvmName("vjbvpkamnejeyoqr")
    public suspend fun timeToLive(`value`: Output<Any>) {
        this.timeToLive = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'HDInsightOnDemand'.
     */
    @JvmName("sbrjxuyhssysfser")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Version of the HDInsight cluster.  Type: string (or Expression with resultType string).
     */
    @JvmName("uxvpbgrnpwgwvqhr")
    public suspend fun version(`value`: Output<Any>) {
        this.version = value
    }

    /**
     * @param value The ARM resource ID for the vNet to which the cluster should be joined after creation. Type: string (or Expression with resultType string).
     */
    @JvmName("dblscthkbbcvpamn")
    public suspend fun virtualNetworkId(`value`: Output<Any>) {
        this.virtualNetworkId = value
    }

    /**
     * @param value Specifies the Yarn configuration parameters (yarn-site.xml) for the HDInsight cluster.
     */
    @JvmName("trhsliymyhroufel")
    public suspend fun yarnConfiguration(`value`: Output<Any>) {
        this.yarnConfiguration = value
    }

    /**
     * @param value Specifies the size of the Zoo Keeper node for the HDInsight cluster.
     */
    @JvmName("bawkrsmpcssubanx")
    public suspend fun zookeeperNodeSize(`value`: Output<Any>) {
        this.zookeeperNodeSize = value
    }

    /**
     * @param value Specifies additional storage accounts for the HDInsight linked service so that the Data Factory service can register them on your behalf.
     */
    @JvmName("fwivcbmjmnuqqgfr")
    public suspend fun additionalLinkedServiceNames(`value`: List<LinkedServiceReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalLinkedServiceNames = mapped
    }

    /**
     * @param argument Specifies additional storage accounts for the HDInsight linked service so that the Data Factory service can register them on your behalf.
     */
    @JvmName("hpoabotanhdfepnh")
    public suspend
    fun additionalLinkedServiceNames(argument: List<suspend LinkedServiceReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LinkedServiceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalLinkedServiceNames = mapped
    }

    /**
     * @param argument Specifies additional storage accounts for the HDInsight linked service so that the Data Factory service can register them on your behalf.
     */
    @JvmName("bveedkpmtsfsdvsg")
    public suspend fun additionalLinkedServiceNames(
        vararg
        argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LinkedServiceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalLinkedServiceNames = mapped
    }

    /**
     * @param argument Specifies additional storage accounts for the HDInsight linked service so that the Data Factory service can register them on your behalf.
     */
    @JvmName("wxiwrknmcweaiijd")
    public suspend
    fun additionalLinkedServiceNames(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.additionalLinkedServiceNames = mapped
    }

    /**
     * @param values Specifies additional storage accounts for the HDInsight linked service so that the Data Factory service can register them on your behalf.
     */
    @JvmName("oryqevxoxtoiimvc")
    public suspend fun additionalLinkedServiceNames(vararg values: LinkedServiceReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalLinkedServiceNames = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("otqfobmmpxgpqyjq")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("xwknoofnvxggocqh")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The prefix of cluster name, postfix will be distinct with timestamp. Type: string (or Expression with resultType string).
     */
    @JvmName("aolulgtdgyqbirrx")
    public suspend fun clusterNamePrefix(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterNamePrefix = mapped
    }

    /**
     * @param value The password to access the cluster.
     */
    @JvmName("ldhvgmnvpauufrmm")
    public suspend
    fun clusterPassword(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterPassword = mapped
    }

    /**
     * @param value The password to access the cluster.
     */
    @JvmName("dwudhctljaiabppa")
    public fun clusterPassword(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterPassword = mapped
    }

    /**
     * @param value The password to access the cluster.
     */
    @JvmName("ijdswnysbycfpwok")
    public fun clusterPassword(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterPassword = mapped
    }

    /**
     * @param value The resource group where the cluster belongs. Type: string (or Expression with resultType string).
     */
    @JvmName("kaxbohemofujioen")
    public suspend fun clusterResourceGroup(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterResourceGroup = mapped
    }

    /**
     * @param value Number of worker/data nodes in the cluster. Suggestion value: 4. Type: int (or Expression with resultType int).
     */
    @JvmName("ayrffinvcvyfhnku")
    public suspend fun clusterSize(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterSize = mapped
    }

    /**
     * @param value The password to SSH remotely connect cluster’s node (for Linux).
     */
    @JvmName("abmuhlbpxclsjamw")
    public suspend
    fun clusterSshPassword(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterSshPassword = mapped
    }

    /**
     * @param value The password to SSH remotely connect cluster’s node (for Linux).
     */
    @JvmName("ddcomqatdoligeda")
    public fun clusterSshPassword(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterSshPassword = mapped
    }

    /**
     * @param value The password to SSH remotely connect cluster’s node (for Linux).
     */
    @JvmName("ckkdkrwjdupwayta")
    public fun clusterSshPassword(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterSshPassword = mapped
    }

    /**
     * @param value The username to SSH remotely connect to cluster’s node (for Linux). Type: string (or Expression with resultType string).
     */
    @JvmName("goajyufhdgkykyax")
    public suspend fun clusterSshUserName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterSshUserName = mapped
    }

    /**
     * @param value The cluster type. Type: string (or Expression with resultType string).
     */
    @JvmName("rhipcljoapsxhjip")
    public suspend fun clusterType(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterType = mapped
    }

    /**
     * @param value The username to access the cluster. Type: string (or Expression with resultType string).
     */
    @JvmName("sekitdentufqmycn")
    public suspend fun clusterUserName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterUserName = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("rpqadooywhirgdob")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("kfcslhaeuhoxvsys")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Specifies the core configuration parameters (as in core-site.xml) for the HDInsight cluster to be created.
     */
    @JvmName("kuttqmrjghlnujum")
    public suspend fun coreConfiguration(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreConfiguration = mapped
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("ietwdqrfpgiutday")
    public suspend fun credential(`value`: CredentialReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credential = mapped
    }

    /**
     * @param argument The credential reference containing authentication information.
     */
    @JvmName("iqqwqvrcepypbrox")
    public suspend fun credential(argument: suspend CredentialReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = CredentialReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credential = mapped
    }

    /**
     * @param value Specifies the size of the data node for the HDInsight cluster.
     */
    @JvmName("kghwoxscrunjyvuw")
    public suspend fun dataNodeSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataNodeSize = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("oirvtvldhmooewir")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("unjskedesbqaodwb")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value Specifies the HBase configuration parameters (hbase-site.xml) for the HDInsight cluster.
     */
    @JvmName("lhqdpntblhohqnav")
    public suspend fun hBaseConfiguration(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hBaseConfiguration = mapped
    }

    /**
     * @param value The name of Azure SQL linked service that point to the HCatalog database. The on-demand HDInsight cluster is created by using the Azure SQL database as the metastore.
     */
    @JvmName("xowrnflbtpvbfmqs")
    public suspend fun hcatalogLinkedServiceName(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hcatalogLinkedServiceName = mapped
    }

    /**
     * @param argument The name of Azure SQL linked service that point to the HCatalog database. The on-demand HDInsight cluster is created by using the Azure SQL database as the metastore.
     */
    @JvmName("uehlrlbgpycnyyto")
    public suspend
    fun hcatalogLinkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hcatalogLinkedServiceName = mapped
    }

    /**
     * @param value Specifies the HDFS configuration parameters (hdfs-site.xml) for the HDInsight cluster.
     */
    @JvmName("dfvkwjpytxkqupul")
    public suspend fun hdfsConfiguration(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hdfsConfiguration = mapped
    }

    /**
     * @param value Specifies the size of the head node for the HDInsight cluster.
     */
    @JvmName("areakhgedgpbkgdd")
    public suspend fun headNodeSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headNodeSize = mapped
    }

    /**
     * @param value Specifies the hive configuration parameters (hive-site.xml) for the HDInsight cluster.
     */
    @JvmName("tupihyxkdqhadrqj")
    public suspend fun hiveConfiguration(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hiveConfiguration = mapped
    }

    /**
     * @param value The customer’s subscription to host the cluster. Type: string (or Expression with resultType string).
     */
    @JvmName("akfhgewgnyaogvuw")
    public suspend fun hostSubscriptionId(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostSubscriptionId = mapped
    }

    /**
     * @param value Azure Storage linked service to be used by the on-demand cluster for storing and processing data.
     */
    @JvmName("cgnhyuhmgpujgnqw")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Azure Storage linked service to be used by the on-demand cluster for storing and processing data.
     */
    @JvmName("cclwdccjwpccnudl")
    public suspend
    fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value Specifies the MapReduce configuration parameters (mapred-site.xml) for the HDInsight cluster.
     */
    @JvmName("qtxclcdstypvidig")
    public suspend fun mapReduceConfiguration(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mapReduceConfiguration = mapped
    }

    /**
     * @param value Specifies the Oozie configuration parameters (oozie-site.xml) for the HDInsight cluster.
     */
    @JvmName("xdlxeehxsmdgoetn")
    public suspend fun oozieConfiguration(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oozieConfiguration = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("iipqylnbececqnoh")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("jmrjrtnncucjsalt")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("jkfphypiaxbqmvga")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Custom script actions to run on HDI ondemand cluster once it's up. Please refer to https://docs.microsoft.com/en-us/azure/hdinsight/hdinsight-hadoop-customize-cluster-linux?toc=%2Fen-us%2Fazure%2Fhdinsight%2Fr-server%2FTOC.json&bc=%2Fen-us%2Fazure%2Fbread%2Ftoc.json#understanding-script-actions.
     */
    @JvmName("oeqrimiturndylgq")
    public suspend fun scriptActions(`value`: List<ScriptActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptActions = mapped
    }

    /**
     * @param argument Custom script actions to run on HDI ondemand cluster once it's up. Please refer to https://docs.microsoft.com/en-us/azure/hdinsight/hdinsight-hadoop-customize-cluster-linux?toc=%2Fen-us%2Fazure%2Fhdinsight%2Fr-server%2FTOC.json&bc=%2Fen-us%2Fazure%2Fbread%2Ftoc.json#understanding-script-actions.
     */
    @JvmName("ddcmokwvdaydtwsu")
    public suspend fun scriptActions(argument: List<suspend ScriptActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScriptActionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.scriptActions = mapped
    }

    /**
     * @param argument Custom script actions to run on HDI ondemand cluster once it's up. Please refer to https://docs.microsoft.com/en-us/azure/hdinsight/hdinsight-hadoop-customize-cluster-linux?toc=%2Fen-us%2Fazure%2Fhdinsight%2Fr-server%2FTOC.json&bc=%2Fen-us%2Fazure%2Fbread%2Ftoc.json#understanding-script-actions.
     */
    @JvmName("jmgtcecefmcutumb")
    public suspend fun scriptActions(vararg argument: suspend ScriptActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScriptActionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.scriptActions = mapped
    }

    /**
     * @param argument Custom script actions to run on HDI ondemand cluster once it's up. Please refer to https://docs.microsoft.com/en-us/azure/hdinsight/hdinsight-hadoop-customize-cluster-linux?toc=%2Fen-us%2Fazure%2Fhdinsight%2Fr-server%2FTOC.json&bc=%2Fen-us%2Fazure%2Fbread%2Ftoc.json#understanding-script-actions.
     */
    @JvmName("mwdenbiaajgisulq")
    public suspend fun scriptActions(argument: suspend ScriptActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ScriptActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.scriptActions = mapped
    }

    /**
     * @param values Custom script actions to run on HDI ondemand cluster once it's up. Please refer to https://docs.microsoft.com/en-us/azure/hdinsight/hdinsight-hadoop-customize-cluster-linux?toc=%2Fen-us%2Fazure%2Fhdinsight%2Fr-server%2FTOC.json&bc=%2Fen-us%2Fazure%2Fbread%2Ftoc.json#understanding-script-actions.
     */
    @JvmName("axoqadcxhqywbgsn")
    public suspend fun scriptActions(vararg values: ScriptActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scriptActions = mapped
    }

    /**
     * @param value The service principal id for the hostSubscriptionId. Type: string (or Expression with resultType string).
     */
    @JvmName("eonxiatnnkrabvky")
    public suspend fun servicePrincipalId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalId = mapped
    }

    /**
     * @param value The key for the service principal id.
     */
    @JvmName("esdjtbnyuahgmpom")
    public suspend
    fun servicePrincipalKey(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The key for the service principal id.
     */
    @JvmName("xsbvdqsmbickajyg")
    public fun servicePrincipalKey(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The key for the service principal id.
     */
    @JvmName("xahdqryjxuufkucv")
    public fun servicePrincipalKey(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The version of spark if the cluster type is 'spark'. Type: string (or Expression with resultType string).
     */
    @JvmName("pdjsfcsqtkqlivct")
    public suspend fun sparkVersion(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sparkVersion = mapped
    }

    /**
     * @param value Specifies the Storm configuration parameters (storm-site.xml) for the HDInsight cluster.
     */
    @JvmName("vptggyjlnkpwtamt")
    public suspend fun stormConfiguration(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stormConfiguration = mapped
    }

    /**
     * @param value The ARM resource ID for the subnet in the vNet. If virtualNetworkId was specified, then this property is required. Type: string (or Expression with resultType string).
     */
    @JvmName("ahvwufgjshpyocvr")
    public suspend fun subnetName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetName = mapped
    }

    /**
     * @param value The Tenant id/name to which the service principal belongs. Type: string (or Expression with resultType string).
     */
    @JvmName("nvcpfjaaskakgfyw")
    public suspend fun tenant(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tenant = mapped
    }

    /**
     * @param value The allowed idle time for the on-demand HDInsight cluster. Specifies how long the on-demand HDInsight cluster stays alive after completion of an activity run if there are no other active jobs in the cluster. The minimum value is 5 mins. Type: string (or Expression with resultType string).
     */
    @JvmName("fnclfpsrwjsbdbob")
    public suspend fun timeToLive(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeToLive = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'HDInsightOnDemand'.
     */
    @JvmName("tgvfqcdpdktrjigt")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Version of the HDInsight cluster.  Type: string (or Expression with resultType string).
     */
    @JvmName("exqntnrxrfjrxmeg")
    public suspend fun version(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value The ARM resource ID for the vNet to which the cluster should be joined after creation. Type: string (or Expression with resultType string).
     */
    @JvmName("drylsxknetoxorgb")
    public suspend fun virtualNetworkId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkId = mapped
    }

    /**
     * @param value Specifies the Yarn configuration parameters (yarn-site.xml) for the HDInsight cluster.
     */
    @JvmName("bkbqbhnjveqklglb")
    public suspend fun yarnConfiguration(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.yarnConfiguration = mapped
    }

    /**
     * @param value Specifies the size of the Zoo Keeper node for the HDInsight cluster.
     */
    @JvmName("mdiolvfntdhrfaxg")
    public suspend fun zookeeperNodeSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zookeeperNodeSize = mapped
    }

    internal fun build(): HDInsightOnDemandLinkedServiceArgs = HDInsightOnDemandLinkedServiceArgs(
        additionalLinkedServiceNames = additionalLinkedServiceNames,
        annotations = annotations,
        clusterNamePrefix = clusterNamePrefix,
        clusterPassword = clusterPassword,
        clusterResourceGroup = clusterResourceGroup ?: throw
            PulumiNullFieldException("clusterResourceGroup"),
        clusterSize = clusterSize ?: throw PulumiNullFieldException("clusterSize"),
        clusterSshPassword = clusterSshPassword,
        clusterSshUserName = clusterSshUserName,
        clusterType = clusterType,
        clusterUserName = clusterUserName,
        connectVia = connectVia,
        coreConfiguration = coreConfiguration,
        credential = credential,
        dataNodeSize = dataNodeSize,
        description = description,
        encryptedCredential = encryptedCredential,
        hBaseConfiguration = hBaseConfiguration,
        hcatalogLinkedServiceName = hcatalogLinkedServiceName,
        hdfsConfiguration = hdfsConfiguration,
        headNodeSize = headNodeSize,
        hiveConfiguration = hiveConfiguration,
        hostSubscriptionId = hostSubscriptionId ?: throw PulumiNullFieldException("hostSubscriptionId"),
        linkedServiceName = linkedServiceName ?: throw PulumiNullFieldException("linkedServiceName"),
        mapReduceConfiguration = mapReduceConfiguration,
        oozieConfiguration = oozieConfiguration,
        parameters = parameters,
        scriptActions = scriptActions,
        servicePrincipalId = servicePrincipalId,
        servicePrincipalKey = servicePrincipalKey,
        sparkVersion = sparkVersion,
        stormConfiguration = stormConfiguration,
        subnetName = subnetName,
        tenant = tenant ?: throw PulumiNullFieldException("tenant"),
        timeToLive = timeToLive ?: throw PulumiNullFieldException("timeToLive"),
        type = type ?: throw PulumiNullFieldException("type"),
        version = version ?: throw PulumiNullFieldException("version"),
        virtualNetworkId = virtualNetworkId,
        yarnConfiguration = yarnConfiguration,
        zookeeperNodeSize = zookeeperNodeSize,
    )
}
