@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.HDInsightSparkActivityArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityOnInactiveMarkAs
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityState
import com.pulumi.azurenative.datafactory.kotlin.enums.HDInsightActivityDebugInfoOption
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * HDInsight Spark activity.
 * @property arguments The user-specified arguments to HDInsightSparkActivity.
 * @property className The application's Java/Spark main class.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property entryFilePath The relative path to the root folder of the code/package to be executed. Type: string (or Expression with resultType string).
 * @property getDebugInfo Debug info option.
 * @property linkedServiceName Linked service reference.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property policy Activity policy.
 * @property proxyUser The user to impersonate that will execute the job. Type: string (or Expression with resultType string).
 * @property rootPath The root path in 'sparkJobLinkedService' for all the job’s files. Type: string (or Expression with resultType string).
 * @property sparkConfig Spark configuration property.
 * @property sparkJobLinkedService The storage linked service for uploading the entry file and dependencies, and for receiving logs.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property type Type of activity.
 * Expected value is 'HDInsightSpark'.
 * @property userProperties Activity user properties.
 */
public data class HDInsightSparkActivityArgs(
    public val arguments: Output<List<Any>>? = null,
    public val className: Output<String>? = null,
    public val dependsOn: Output<List<ActivityDependencyArgs>>? = null,
    public val description: Output<String>? = null,
    public val entryFilePath: Output<Any>,
    public val getDebugInfo: Output<Either<String, HDInsightActivityDebugInfoOption>>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>? = null,
    public val name: Output<String>,
    public val onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null,
    public val policy: Output<ActivityPolicyArgs>? = null,
    public val proxyUser: Output<Any>? = null,
    public val rootPath: Output<Any>,
    public val sparkConfig: Output<Map<String, Any>>? = null,
    public val sparkJobLinkedService: Output<LinkedServiceReferenceArgs>? = null,
    public val state: Output<Either<String, ActivityState>>? = null,
    public val type: Output<String>,
    public val userProperties: Output<List<UserPropertyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.HDInsightSparkActivityArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.HDInsightSparkActivityArgs =
        com.pulumi.azurenative.datafactory.inputs.HDInsightSparkActivityArgs.builder()
            .arguments(arguments?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .className(className?.applyValue({ args0 -> args0 }))
            .dependsOn(
                dependsOn?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .entryFilePath(entryFilePath.applyValue({ args0 -> args0 }))
            .getDebugInfo(
                getDebugInfo?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .linkedServiceName(linkedServiceName?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .onInactiveMarkAs(
                onInactiveMarkAs?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .policy(policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .proxyUser(proxyUser?.applyValue({ args0 -> args0 }))
            .rootPath(rootPath.applyValue({ args0 -> args0 }))
            .sparkConfig(
                sparkConfig?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .sparkJobLinkedService(
                sparkJobLinkedService?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .userProperties(
                userProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [HDInsightSparkActivityArgs].
 */
@PulumiTagMarker
public class HDInsightSparkActivityArgsBuilder internal constructor() {
    private var arguments: Output<List<Any>>? = null

    private var className: Output<String>? = null

    private var dependsOn: Output<List<ActivityDependencyArgs>>? = null

    private var description: Output<String>? = null

    private var entryFilePath: Output<Any>? = null

    private var getDebugInfo: Output<Either<String, HDInsightActivityDebugInfoOption>>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var name: Output<String>? = null

    private var onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null

    private var policy: Output<ActivityPolicyArgs>? = null

    private var proxyUser: Output<Any>? = null

    private var rootPath: Output<Any>? = null

    private var sparkConfig: Output<Map<String, Any>>? = null

    private var sparkJobLinkedService: Output<LinkedServiceReferenceArgs>? = null

    private var state: Output<Either<String, ActivityState>>? = null

    private var type: Output<String>? = null

    private var userProperties: Output<List<UserPropertyArgs>>? = null

    /**
     * @param value The user-specified arguments to HDInsightSparkActivity.
     */
    @JvmName("ejrgeawrcipacstd")
    public suspend fun arguments(`value`: Output<List<Any>>) {
        this.arguments = value
    }

    @JvmName("fcivgpxvlhorwxkl")
    public suspend fun arguments(vararg values: Output<Any>) {
        this.arguments = Output.all(values.asList())
    }

    /**
     * @param values The user-specified arguments to HDInsightSparkActivity.
     */
    @JvmName("exseyxeubmdelegq")
    public suspend fun arguments(values: List<Output<Any>>) {
        this.arguments = Output.all(values)
    }

    /**
     * @param value The application's Java/Spark main class.
     */
    @JvmName("dpcbcupohrbrkvbw")
    public suspend fun className(`value`: Output<String>) {
        this.className = value
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("drtgsaxnrtgnbarx")
    public suspend fun dependsOn(`value`: Output<List<ActivityDependencyArgs>>) {
        this.dependsOn = value
    }

    @JvmName("wdulgbxuasxeycfr")
    public suspend fun dependsOn(vararg values: Output<ActivityDependencyArgs>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("nwedkyluhvgiqcjf")
    public suspend fun dependsOn(values: List<Output<ActivityDependencyArgs>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Activity description.
     */
    @JvmName("wkfodeelgksucpsn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The relative path to the root folder of the code/package to be executed. Type: string (or Expression with resultType string).
     */
    @JvmName("cawslyqjqyktbvsy")
    public suspend fun entryFilePath(`value`: Output<Any>) {
        this.entryFilePath = value
    }

    /**
     * @param value Debug info option.
     */
    @JvmName("sjxyurbrsjxsotnf")
    public suspend
    fun getDebugInfo(`value`: Output<Either<String, HDInsightActivityDebugInfoOption>>) {
        this.getDebugInfo = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("tyyxtrowekduldoy")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value Activity name.
     */
    @JvmName("mnspujawhioespat")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("rqbvhqiureaqwhrw")
    public suspend fun onInactiveMarkAs(`value`: Output<Either<String, ActivityOnInactiveMarkAs>>) {
        this.onInactiveMarkAs = value
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("hrowhshbhwrxdtxg")
    public suspend fun policy(`value`: Output<ActivityPolicyArgs>) {
        this.policy = value
    }

    /**
     * @param value The user to impersonate that will execute the job. Type: string (or Expression with resultType string).
     */
    @JvmName("efgabcaiktpyjfab")
    public suspend fun proxyUser(`value`: Output<Any>) {
        this.proxyUser = value
    }

    /**
     * @param value The root path in 'sparkJobLinkedService' for all the job’s files. Type: string (or Expression with resultType string).
     */
    @JvmName("teamcfiphbgadlef")
    public suspend fun rootPath(`value`: Output<Any>) {
        this.rootPath = value
    }

    /**
     * @param value Spark configuration property.
     */
    @JvmName("fghcotwdlrigxomi")
    public suspend fun sparkConfig(`value`: Output<Map<String, Any>>) {
        this.sparkConfig = value
    }

    /**
     * @param value The storage linked service for uploading the entry file and dependencies, and for receiving logs.
     */
    @JvmName("sbxgnlfdvbacnusi")
    public suspend fun sparkJobLinkedService(`value`: Output<LinkedServiceReferenceArgs>) {
        this.sparkJobLinkedService = value
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("orqkicenkavsuuwf")
    public suspend fun state(`value`: Output<Either<String, ActivityState>>) {
        this.state = value
    }

    /**
     * @param value Type of activity.
     * Expected value is 'HDInsightSpark'.
     */
    @JvmName("tqmsbxbuygycsmcw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("oyuybmofdtxuhbmb")
    public suspend fun userProperties(`value`: Output<List<UserPropertyArgs>>) {
        this.userProperties = value
    }

    @JvmName("xlhmsohoeyqrqheh")
    public suspend fun userProperties(vararg values: Output<UserPropertyArgs>) {
        this.userProperties = Output.all(values.asList())
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("eecofubvktyjcqqg")
    public suspend fun userProperties(values: List<Output<UserPropertyArgs>>) {
        this.userProperties = Output.all(values)
    }

    /**
     * @param value The user-specified arguments to HDInsightSparkActivity.
     */
    @JvmName("ubitwcsosjkptjdy")
    public suspend fun arguments(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param values The user-specified arguments to HDInsightSparkActivity.
     */
    @JvmName("ofbffvntacaoinch")
    public suspend fun arguments(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param value The application's Java/Spark main class.
     */
    @JvmName("mqurojoqoyrkeixh")
    public suspend fun className(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.className = mapped
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("baqcnruhklrlngua")
    public suspend fun dependsOn(`value`: List<ActivityDependencyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("gqoflqxjxqgsynbw")
    public suspend fun dependsOn(argument: List<suspend ActivityDependencyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("otomcsjbkwvsakgm")
    public suspend fun dependsOn(vararg argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("owpsgsadslxydhwt")
    public suspend fun dependsOn(argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ActivityDependencyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("vergamvuoasyoaxe")
    public suspend fun dependsOn(vararg values: ActivityDependencyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Activity description.
     */
    @JvmName("swrrtvfectsyxooh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The relative path to the root folder of the code/package to be executed. Type: string (or Expression with resultType string).
     */
    @JvmName("ylcnkfeucrdibjgu")
    public suspend fun entryFilePath(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entryFilePath = mapped
    }

    /**
     * @param value Debug info option.
     */
    @JvmName("pntxrnlgdmelbdpl")
    public suspend fun getDebugInfo(`value`: Either<String, HDInsightActivityDebugInfoOption>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.getDebugInfo = mapped
    }

    /**
     * @param value Debug info option.
     */
    @JvmName("kcbkvkyvshtuvxqd")
    public fun getDebugInfo(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HDInsightActivityDebugInfoOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.getDebugInfo = mapped
    }

    /**
     * @param value Debug info option.
     */
    @JvmName("khkkypipcuunqcbs")
    public fun getDebugInfo(`value`: HDInsightActivityDebugInfoOption) {
        val toBeMapped = Either.ofRight<String, HDInsightActivityDebugInfoOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.getDebugInfo = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("wuvvqftkmajalhtn")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("phkijsuackynglwo")
    public suspend
    fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value Activity name.
     */
    @JvmName("vrxfrhlwpnhfpeme")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("lopjlygypxuhihnj")
    public suspend fun onInactiveMarkAs(`value`: Either<String, ActivityOnInactiveMarkAs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("fcrjwlofdkehfmfn")
    public fun onInactiveMarkAs(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("wmupdktrrytmdvvx")
    public fun onInactiveMarkAs(`value`: ActivityOnInactiveMarkAs) {
        val toBeMapped = Either.ofRight<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("fviikrqdhbdhdyic")
    public suspend fun policy(`value`: ActivityPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param argument Activity policy.
     */
    @JvmName("gigsdaxnhgqdgwgh")
    public suspend fun policy(argument: suspend ActivityPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ActivityPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policy = mapped
    }

    /**
     * @param value The user to impersonate that will execute the job. Type: string (or Expression with resultType string).
     */
    @JvmName("xhbotefxhiajhobl")
    public suspend fun proxyUser(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxyUser = mapped
    }

    /**
     * @param value The root path in 'sparkJobLinkedService' for all the job’s files. Type: string (or Expression with resultType string).
     */
    @JvmName("iffgytltqqyjpkmc")
    public suspend fun rootPath(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rootPath = mapped
    }

    /**
     * @param value Spark configuration property.
     */
    @JvmName("teenmrkktxftmiyh")
    public suspend fun sparkConfig(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sparkConfig = mapped
    }

    /**
     * @param values Spark configuration property.
     */
    @JvmName("elgfibabkcfoejxb")
    public fun sparkConfig(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sparkConfig = mapped
    }

    /**
     * @param value The storage linked service for uploading the entry file and dependencies, and for receiving logs.
     */
    @JvmName("qlvxqnegeoyidfra")
    public suspend fun sparkJobLinkedService(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sparkJobLinkedService = mapped
    }

    /**
     * @param argument The storage linked service for uploading the entry file and dependencies, and for receiving logs.
     */
    @JvmName("tothduxwmtotmksv")
    public suspend
    fun sparkJobLinkedService(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sparkJobLinkedService = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("cosdxvnusvefxdkv")
    public suspend fun state(`value`: Either<String, ActivityState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("cyrniprcttkewupm")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("rlcbkwritddhpnwc")
    public fun state(`value`: ActivityState) {
        val toBeMapped = Either.ofRight<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Type of activity.
     * Expected value is 'HDInsightSpark'.
     */
    @JvmName("qmrykldjskwlmman")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("xfmaptmdnrunembn")
    public suspend fun userProperties(`value`: List<UserPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("ljyqtaenqdltuejq")
    public suspend fun userProperties(argument: List<suspend UserPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("koducatdejjsflgp")
    public suspend fun userProperties(vararg argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("cmwdujpyuknhlatx")
    public suspend fun userProperties(argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserPropertyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("vufpkwvkxwhoycaw")
    public suspend fun userProperties(vararg values: UserPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    internal fun build(): HDInsightSparkActivityArgs = HDInsightSparkActivityArgs(
        arguments = arguments,
        className = className,
        dependsOn = dependsOn,
        description = description,
        entryFilePath = entryFilePath ?: throw PulumiNullFieldException("entryFilePath"),
        getDebugInfo = getDebugInfo,
        linkedServiceName = linkedServiceName,
        name = name ?: throw PulumiNullFieldException("name"),
        onInactiveMarkAs = onInactiveMarkAs,
        policy = policy,
        proxyUser = proxyUser,
        rootPath = rootPath ?: throw PulumiNullFieldException("rootPath"),
        sparkConfig = sparkConfig,
        sparkJobLinkedService = sparkJobLinkedService,
        state = state,
        type = type ?: throw PulumiNullFieldException("type"),
        userProperties = userProperties,
    )
}
