@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.HttpDatasetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A file in an HTTP web server.
 * @property additionalHeaders The headers for the HTTP Request. e.g. request-header-name-1:request-header-value-1
 * ...
 * request-header-name-n:request-header-value-n Type: string (or Expression with resultType string).
 * @property annotations List of tags that can be used for describing the Dataset.
 * @property compression The data compression method used on files.
 * @property description Dataset description.
 * @property folder The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
 * @property format The format of files.
 * @property linkedServiceName Linked service reference.
 * @property parameters Parameters for dataset.
 * @property relativeUrl The relative URL based on the URL in the HttpLinkedService refers to an HTTP file Type: string (or Expression with resultType string).
 * @property requestBody The body for the HTTP request. Type: string (or Expression with resultType string).
 * @property requestMethod The HTTP method for the HTTP request. Type: string (or Expression with resultType string).
 * @property schema Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
 * @property structure Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
 * @property type Type of dataset.
 * Expected value is 'HttpFile'.
 */
public data class HttpDatasetArgs(
    public val additionalHeaders: Output<Any>? = null,
    public val annotations: Output<List<Any>>? = null,
    public val compression: Output<DatasetCompressionArgs>? = null,
    public val description: Output<String>? = null,
    public val folder: Output<DatasetFolderArgs>? = null,
    public val format: Output<Any>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val relativeUrl: Output<Any>? = null,
    public val requestBody: Output<Any>? = null,
    public val requestMethod: Output<Any>? = null,
    public val schema: Output<Any>? = null,
    public val structure: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.HttpDatasetArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.HttpDatasetArgs =
        com.pulumi.azurenative.datafactory.inputs.HttpDatasetArgs.builder()
            .additionalHeaders(additionalHeaders?.applyValue({ args0 -> args0 }))
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .compression(compression?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .folder(folder?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .format(format?.applyValue({ args0 -> args0 }))
            .linkedServiceName(linkedServiceName.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .relativeUrl(relativeUrl?.applyValue({ args0 -> args0 }))
            .requestBody(requestBody?.applyValue({ args0 -> args0 }))
            .requestMethod(requestMethod?.applyValue({ args0 -> args0 }))
            .schema(schema?.applyValue({ args0 -> args0 }))
            .structure(structure?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HttpDatasetArgs].
 */
@PulumiTagMarker
public class HttpDatasetArgsBuilder internal constructor() {
    private var additionalHeaders: Output<Any>? = null

    private var annotations: Output<List<Any>>? = null

    private var compression: Output<DatasetCompressionArgs>? = null

    private var description: Output<String>? = null

    private var folder: Output<DatasetFolderArgs>? = null

    private var format: Output<Any>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var relativeUrl: Output<Any>? = null

    private var requestBody: Output<Any>? = null

    private var requestMethod: Output<Any>? = null

    private var schema: Output<Any>? = null

    private var structure: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value The headers for the HTTP Request. e.g. request-header-name-1:request-header-value-1
     * ...
     * request-header-name-n:request-header-value-n Type: string (or Expression with resultType string).
     */
    @JvmName("ypvvqvdoorlxobjq")
    public suspend fun additionalHeaders(`value`: Output<Any>) {
        this.additionalHeaders = value
    }

    /**
     * @param value List of tags that can be used for describing the Dataset.
     */
    @JvmName("wtaqlnxbjjqrjjos")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("lcnatumsxanfxbyh")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the Dataset.
     */
    @JvmName("fscdhkhxpvrldudh")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The data compression method used on files.
     */
    @JvmName("tywyodrdkehqhnii")
    public suspend fun compression(`value`: Output<DatasetCompressionArgs>) {
        this.compression = value
    }

    /**
     * @param value Dataset description.
     */
    @JvmName("htwrhubcrpqtpxsa")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("jlmgivwqvawoipkq")
    public suspend fun folder(`value`: Output<DatasetFolderArgs>) {
        this.folder = value
    }

    /**
     * @param value The format of files.
     */
    @JvmName("bfleycybqbdcdamk")
    public suspend fun format(`value`: Output<Any>) {
        this.format = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("smpqfmlocygxhadr")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value Parameters for dataset.
     */
    @JvmName("dbaovbckmyixxjdy")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The relative URL based on the URL in the HttpLinkedService refers to an HTTP file Type: string (or Expression with resultType string).
     */
    @JvmName("rcmptyogfmtbuqkq")
    public suspend fun relativeUrl(`value`: Output<Any>) {
        this.relativeUrl = value
    }

    /**
     * @param value The body for the HTTP request. Type: string (or Expression with resultType string).
     */
    @JvmName("sjkkmaqfpytrgxqq")
    public suspend fun requestBody(`value`: Output<Any>) {
        this.requestBody = value
    }

    /**
     * @param value The HTTP method for the HTTP request. Type: string (or Expression with resultType string).
     */
    @JvmName("hxhlwlvypdcfsgxy")
    public suspend fun requestMethod(`value`: Output<Any>) {
        this.requestMethod = value
    }

    /**
     * @param value Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
     */
    @JvmName("bmsyjpyjpwhjppia")
    public suspend fun schema(`value`: Output<Any>) {
        this.schema = value
    }

    /**
     * @param value Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
     */
    @JvmName("qftvjwfgdqmblxcb")
    public suspend fun structure(`value`: Output<Any>) {
        this.structure = value
    }

    /**
     * @param value Type of dataset.
     * Expected value is 'HttpFile'.
     */
    @JvmName("lmipaxigmelpihpb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The headers for the HTTP Request. e.g. request-header-name-1:request-header-value-1
     * ...
     * request-header-name-n:request-header-value-n Type: string (or Expression with resultType string).
     */
    @JvmName("uhuxsbmyyjpcywdp")
    public suspend fun additionalHeaders(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalHeaders = mapped
    }

    /**
     * @param value List of tags that can be used for describing the Dataset.
     */
    @JvmName("ofpbkejfqmxinuls")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the Dataset.
     */
    @JvmName("jeutnwgymbenkuot")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The data compression method used on files.
     */
    @JvmName("vvpevmfvglcapluk")
    public suspend fun compression(`value`: DatasetCompressionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compression = mapped
    }

    /**
     * @param argument The data compression method used on files.
     */
    @JvmName("sjgrnhhldlcoympr")
    public suspend fun compression(argument: suspend DatasetCompressionArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetCompressionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.compression = mapped
    }

    /**
     * @param value Dataset description.
     */
    @JvmName("oxiopfbaratlvkft")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("lfjfcyjjdqgorwyv")
    public suspend fun folder(`value`: DatasetFolderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folder = mapped
    }

    /**
     * @param argument The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("gcqwbryyscoopjhy")
    public suspend fun folder(argument: suspend DatasetFolderArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetFolderArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.folder = mapped
    }

    /**
     * @param value The format of files.
     */
    @JvmName("njdvbdciddqeyvtj")
    public suspend fun format(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("ohtxdoybivjjntvk")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("imqfgauuguwcydsg")
    public suspend
    fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value Parameters for dataset.
     */
    @JvmName("xqqibbpvtcmlhpos")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for dataset.
     */
    @JvmName("femxqjyjojxtrcot")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for dataset.
     */
    @JvmName("qyepmsgdxixyelvl")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The relative URL based on the URL in the HttpLinkedService refers to an HTTP file Type: string (or Expression with resultType string).
     */
    @JvmName("ievnbsouiyghjuej")
    public suspend fun relativeUrl(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relativeUrl = mapped
    }

    /**
     * @param value The body for the HTTP request. Type: string (or Expression with resultType string).
     */
    @JvmName("rrvvwkkgqsikmvtf")
    public suspend fun requestBody(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestBody = mapped
    }

    /**
     * @param value The HTTP method for the HTTP request. Type: string (or Expression with resultType string).
     */
    @JvmName("yhkjubwmnupnypyu")
    public suspend fun requestMethod(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestMethod = mapped
    }

    /**
     * @param value Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
     */
    @JvmName("epljlsxcatqxchss")
    public suspend fun schema(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param value Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
     */
    @JvmName("xkxqosdkejpdmxho")
    public suspend fun structure(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.structure = mapped
    }

    /**
     * @param value Type of dataset.
     * Expected value is 'HttpFile'.
     */
    @JvmName("gyjgyffssqtdvunb")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): HttpDatasetArgs = HttpDatasetArgs(
        additionalHeaders = additionalHeaders,
        annotations = annotations,
        compression = compression,
        description = description,
        folder = folder,
        format = format,
        linkedServiceName = linkedServiceName ?: throw PulumiNullFieldException("linkedServiceName"),
        parameters = parameters,
        relativeUrl = relativeUrl,
        requestBody = requestBody,
        requestMethod = requestMethod,
        schema = schema,
        structure = structure,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
