@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeSsisCatalogInfoArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.IntegrationRuntimeSsisCatalogPricingTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Catalog information for managed dedicated integration runtime.
 * @property catalogAdminPassword The password of the administrator user account of the catalog database.
 * @property catalogAdminUserName The administrator user name of catalog database.
 * @property catalogPricingTier The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
 * @property catalogServerEndpoint The catalog database server URL.
 * @property dualStandbyPairName The dual standby pair name of Azure-SSIS Integration Runtimes to support SSISDB failover.
 */
public data class IntegrationRuntimeSsisCatalogInfoArgs(
    public val catalogAdminPassword: Output<SecureStringArgs>? = null,
    public val catalogAdminUserName: Output<String>? = null,
    public val catalogPricingTier: Output<Either<String, IntegrationRuntimeSsisCatalogPricingTier>>? =
        null,
    public val catalogServerEndpoint: Output<String>? = null,
    public val dualStandbyPairName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeSsisCatalogInfoArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeSsisCatalogInfoArgs =
        com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeSsisCatalogInfoArgs.builder()
            .catalogAdminPassword(
                catalogAdminPassword?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .catalogAdminUserName(catalogAdminUserName?.applyValue({ args0 -> args0 }))
            .catalogPricingTier(
                catalogPricingTier?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .catalogServerEndpoint(catalogServerEndpoint?.applyValue({ args0 -> args0 }))
            .dualStandbyPairName(dualStandbyPairName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntegrationRuntimeSsisCatalogInfoArgs].
 */
@PulumiTagMarker
public class IntegrationRuntimeSsisCatalogInfoArgsBuilder internal constructor() {
    private var catalogAdminPassword: Output<SecureStringArgs>? = null

    private var catalogAdminUserName: Output<String>? = null

    private var catalogPricingTier: Output<Either<String, IntegrationRuntimeSsisCatalogPricingTier>>? =
        null

    private var catalogServerEndpoint: Output<String>? = null

    private var dualStandbyPairName: Output<String>? = null

    /**
     * @param value The password of the administrator user account of the catalog database.
     */
    @JvmName("cecwhxakwwtnnhrs")
    public suspend fun catalogAdminPassword(`value`: Output<SecureStringArgs>) {
        this.catalogAdminPassword = value
    }

    /**
     * @param value The administrator user name of catalog database.
     */
    @JvmName("tkitmnrnxcfqndve")
    public suspend fun catalogAdminUserName(`value`: Output<String>) {
        this.catalogAdminUserName = value
    }

    /**
     * @param value The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
     */
    @JvmName("pxxbgxbhwndyadkc")
    public suspend
    fun catalogPricingTier(`value`: Output<Either<String, IntegrationRuntimeSsisCatalogPricingTier>>) {
        this.catalogPricingTier = value
    }

    /**
     * @param value The catalog database server URL.
     */
    @JvmName("mwmumgsgjmxultgk")
    public suspend fun catalogServerEndpoint(`value`: Output<String>) {
        this.catalogServerEndpoint = value
    }

    /**
     * @param value The dual standby pair name of Azure-SSIS Integration Runtimes to support SSISDB failover.
     */
    @JvmName("vubcodsoaaronbpq")
    public suspend fun dualStandbyPairName(`value`: Output<String>) {
        this.dualStandbyPairName = value
    }

    /**
     * @param value The password of the administrator user account of the catalog database.
     */
    @JvmName("pywvovxdcykrehar")
    public suspend fun catalogAdminPassword(`value`: SecureStringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogAdminPassword = mapped
    }

    /**
     * @param argument The password of the administrator user account of the catalog database.
     */
    @JvmName("lajsqhhydnbmbrwa")
    public suspend fun catalogAdminPassword(argument: suspend SecureStringArgsBuilder.() -> Unit) {
        val toBeMapped = SecureStringArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.catalogAdminPassword = mapped
    }

    /**
     * @param value The administrator user name of catalog database.
     */
    @JvmName("pnrajaxmnhvulmmq")
    public suspend fun catalogAdminUserName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogAdminUserName = mapped
    }

    /**
     * @param value The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
     */
    @JvmName("oergmnupktixoqby")
    public suspend
    fun catalogPricingTier(`value`: Either<String, IntegrationRuntimeSsisCatalogPricingTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogPricingTier = mapped
    }

    /**
     * @param value The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
     */
    @JvmName("miwaarabrudumwcp")
    public fun catalogPricingTier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IntegrationRuntimeSsisCatalogPricingTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.catalogPricingTier = mapped
    }

    /**
     * @param value The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
     */
    @JvmName("bjwxbxrwbqrvkojy")
    public fun catalogPricingTier(`value`: IntegrationRuntimeSsisCatalogPricingTier) {
        val toBeMapped = Either.ofRight<String, IntegrationRuntimeSsisCatalogPricingTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.catalogPricingTier = mapped
    }

    /**
     * @param value The catalog database server URL.
     */
    @JvmName("swtpkcnbjwtuwosg")
    public suspend fun catalogServerEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogServerEndpoint = mapped
    }

    /**
     * @param value The dual standby pair name of Azure-SSIS Integration Runtimes to support SSISDB failover.
     */
    @JvmName("uysgnfyvnydvwged")
    public suspend fun dualStandbyPairName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dualStandbyPairName = mapped
    }

    internal fun build(): IntegrationRuntimeSsisCatalogInfoArgs =
        IntegrationRuntimeSsisCatalogInfoArgs(
            catalogAdminPassword = catalogAdminPassword,
            catalogAdminUserName = catalogAdminUserName,
            catalogPricingTier = catalogPricingTier,
            catalogServerEndpoint = catalogServerEndpoint,
            dualStandbyPairName = dualStandbyPairName,
        )
}
