@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.JsonFormatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The data stored in JSON format.
 * @property deserializer Deserializer. Type: string (or Expression with resultType string).
 * @property encodingName The code page name of the preferred encoding. If not provided, the default value is 'utf-8', unless the byte order mark (BOM) denotes another Unicode encoding. The full list of supported values can be found in the 'Name' column of the table of encodings in the following reference: https://go.microsoft.com/fwlink/?linkid=861078. Type: string (or Expression with resultType string).
 * @property filePattern File pattern of JSON. To be more specific, the way of separating a collection of JSON objects. The default value is 'setOfObjects'. It is case-sensitive.
 * @property jsonNodeReference The JSONPath of the JSON array element to be flattened. Example: "$.ArrayPath". Type: string (or Expression with resultType string).
 * @property jsonPathDefinition The JSONPath definition for each column mapping with a customized column name to extract data from JSON file. For fields under root object, start with "$"; for fields inside the array chosen by jsonNodeReference property, start from the array element. Example: {"Column1": "$.Column1Path", "Column2": "Column2PathInArray"}. Type: object (or Expression with resultType object).
 * @property nestingSeparator The character used to separate nesting levels. Default value is '.' (dot). Type: string (or Expression with resultType string).
 * @property serializer Serializer. Type: string (or Expression with resultType string).
 * @property type Type of dataset storage format.
 * Expected value is 'JsonFormat'.
 */
public data class JsonFormatArgs(
    public val deserializer: Output<Any>? = null,
    public val encodingName: Output<Any>? = null,
    public val filePattern: Output<Any>? = null,
    public val jsonNodeReference: Output<Any>? = null,
    public val jsonPathDefinition: Output<Any>? = null,
    public val nestingSeparator: Output<Any>? = null,
    public val serializer: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.JsonFormatArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.JsonFormatArgs =
        com.pulumi.azurenative.datafactory.inputs.JsonFormatArgs.builder()
            .deserializer(deserializer?.applyValue({ args0 -> args0 }))
            .encodingName(encodingName?.applyValue({ args0 -> args0 }))
            .filePattern(filePattern?.applyValue({ args0 -> args0 }))
            .jsonNodeReference(jsonNodeReference?.applyValue({ args0 -> args0 }))
            .jsonPathDefinition(jsonPathDefinition?.applyValue({ args0 -> args0 }))
            .nestingSeparator(nestingSeparator?.applyValue({ args0 -> args0 }))
            .serializer(serializer?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JsonFormatArgs].
 */
@PulumiTagMarker
public class JsonFormatArgsBuilder internal constructor() {
    private var deserializer: Output<Any>? = null

    private var encodingName: Output<Any>? = null

    private var filePattern: Output<Any>? = null

    private var jsonNodeReference: Output<Any>? = null

    private var jsonPathDefinition: Output<Any>? = null

    private var nestingSeparator: Output<Any>? = null

    private var serializer: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Deserializer. Type: string (or Expression with resultType string).
     */
    @JvmName("rioqokciqhnefonj")
    public suspend fun deserializer(`value`: Output<Any>) {
        this.deserializer = value
    }

    /**
     * @param value The code page name of the preferred encoding. If not provided, the default value is 'utf-8', unless the byte order mark (BOM) denotes another Unicode encoding. The full list of supported values can be found in the 'Name' column of the table of encodings in the following reference: https://go.microsoft.com/fwlink/?linkid=861078. Type: string (or Expression with resultType string).
     */
    @JvmName("umbnslqnhjwmuboo")
    public suspend fun encodingName(`value`: Output<Any>) {
        this.encodingName = value
    }

    /**
     * @param value File pattern of JSON. To be more specific, the way of separating a collection of JSON objects. The default value is 'setOfObjects'. It is case-sensitive.
     */
    @JvmName("okddlmxwittwchvd")
    public suspend fun filePattern(`value`: Output<Any>) {
        this.filePattern = value
    }

    /**
     * @param value The JSONPath of the JSON array element to be flattened. Example: "$.ArrayPath". Type: string (or Expression with resultType string).
     */
    @JvmName("qlpluirvcqqmbgad")
    public suspend fun jsonNodeReference(`value`: Output<Any>) {
        this.jsonNodeReference = value
    }

    /**
     * @param value The JSONPath definition for each column mapping with a customized column name to extract data from JSON file. For fields under root object, start with "$"; for fields inside the array chosen by jsonNodeReference property, start from the array element. Example: {"Column1": "$.Column1Path", "Column2": "Column2PathInArray"}. Type: object (or Expression with resultType object).
     */
    @JvmName("kpnrtyvmkshimgtm")
    public suspend fun jsonPathDefinition(`value`: Output<Any>) {
        this.jsonPathDefinition = value
    }

    /**
     * @param value The character used to separate nesting levels. Default value is '.' (dot). Type: string (or Expression with resultType string).
     */
    @JvmName("nukjebfydihnqkff")
    public suspend fun nestingSeparator(`value`: Output<Any>) {
        this.nestingSeparator = value
    }

    /**
     * @param value Serializer. Type: string (or Expression with resultType string).
     */
    @JvmName("iyblhyybigdpygjh")
    public suspend fun serializer(`value`: Output<Any>) {
        this.serializer = value
    }

    /**
     * @param value Type of dataset storage format.
     * Expected value is 'JsonFormat'.
     */
    @JvmName("mxtndjnopxfvtoij")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Deserializer. Type: string (or Expression with resultType string).
     */
    @JvmName("knxpsypvjgenexll")
    public suspend fun deserializer(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deserializer = mapped
    }

    /**
     * @param value The code page name of the preferred encoding. If not provided, the default value is 'utf-8', unless the byte order mark (BOM) denotes another Unicode encoding. The full list of supported values can be found in the 'Name' column of the table of encodings in the following reference: https://go.microsoft.com/fwlink/?linkid=861078. Type: string (or Expression with resultType string).
     */
    @JvmName("kncseshgoqxqwkhb")
    public suspend fun encodingName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encodingName = mapped
    }

    /**
     * @param value File pattern of JSON. To be more specific, the way of separating a collection of JSON objects. The default value is 'setOfObjects'. It is case-sensitive.
     */
    @JvmName("vfealihbryqopatd")
    public suspend fun filePattern(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filePattern = mapped
    }

    /**
     * @param value The JSONPath of the JSON array element to be flattened. Example: "$.ArrayPath". Type: string (or Expression with resultType string).
     */
    @JvmName("gttwkrpeyqitwwkn")
    public suspend fun jsonNodeReference(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonNodeReference = mapped
    }

    /**
     * @param value The JSONPath definition for each column mapping with a customized column name to extract data from JSON file. For fields under root object, start with "$"; for fields inside the array chosen by jsonNodeReference property, start from the array element. Example: {"Column1": "$.Column1Path", "Column2": "Column2PathInArray"}. Type: object (or Expression with resultType object).
     */
    @JvmName("ooubcnyxfyndianf")
    public suspend fun jsonPathDefinition(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonPathDefinition = mapped
    }

    /**
     * @param value The character used to separate nesting levels. Default value is '.' (dot). Type: string (or Expression with resultType string).
     */
    @JvmName("msvuxtygxlgusyvh")
    public suspend fun nestingSeparator(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nestingSeparator = mapped
    }

    /**
     * @param value Serializer. Type: string (or Expression with resultType string).
     */
    @JvmName("xnfpwqekqhyfoman")
    public suspend fun serializer(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serializer = mapped
    }

    /**
     * @param value Type of dataset storage format.
     * Expected value is 'JsonFormat'.
     */
    @JvmName("tpnpotuaxoacjqur")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): JsonFormatArgs = JsonFormatArgs(
        deserializer = deserializer,
        encodingName = encodingName,
        filePattern = filePattern,
        jsonNodeReference = jsonNodeReference,
        jsonPathDefinition = jsonPathDefinition,
        nestingSeparator = nestingSeparator,
        serializer = serializer,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
