@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.MapperConnectionArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ConnectionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Source connection details.
 * @property commonDslConnectorProperties List of name/value pairs for connection properties.
 * @property isInlineDataset A boolean indicating whether linked service is of type inline dataset. Currently only inline datasets are supported.
 * @property linkedService Linked service reference.
 * @property linkedServiceType Type of the linked service e.g.: AzureBlobFS.
 * @property type Type of connection via linked service or dataset.
 */
public data class MapperConnectionArgs(
    public val commonDslConnectorProperties: Output<List<MapperDslConnectorPropertiesArgs>>? = null,
    public val isInlineDataset: Output<Boolean>? = null,
    public val linkedService: Output<LinkedServiceReferenceArgs>? = null,
    public val linkedServiceType: Output<String>? = null,
    public val type: Output<Either<String, ConnectionType>>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.MapperConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.MapperConnectionArgs =
        com.pulumi.azurenative.datafactory.inputs.MapperConnectionArgs.builder()
            .commonDslConnectorProperties(
                commonDslConnectorProperties?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .isInlineDataset(isInlineDataset?.applyValue({ args0 -> args0 }))
            .linkedService(linkedService?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .linkedServiceType(linkedServiceType?.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [MapperConnectionArgs].
 */
@PulumiTagMarker
public class MapperConnectionArgsBuilder internal constructor() {
    private var commonDslConnectorProperties: Output<List<MapperDslConnectorPropertiesArgs>>? = null

    private var isInlineDataset: Output<Boolean>? = null

    private var linkedService: Output<LinkedServiceReferenceArgs>? = null

    private var linkedServiceType: Output<String>? = null

    private var type: Output<Either<String, ConnectionType>>? = null

    /**
     * @param value List of name/value pairs for connection properties.
     */
    @JvmName("ofahnkwendmkwpfk")
    public suspend
    fun commonDslConnectorProperties(`value`: Output<List<MapperDslConnectorPropertiesArgs>>) {
        this.commonDslConnectorProperties = value
    }

    @JvmName("cbntjnngedifdypv")
    public suspend fun commonDslConnectorProperties(
        vararg
        values: Output<MapperDslConnectorPropertiesArgs>,
    ) {
        this.commonDslConnectorProperties = Output.all(values.asList())
    }

    /**
     * @param values List of name/value pairs for connection properties.
     */
    @JvmName("txawiibjotnobset")
    public suspend
    fun commonDslConnectorProperties(values: List<Output<MapperDslConnectorPropertiesArgs>>) {
        this.commonDslConnectorProperties = Output.all(values)
    }

    /**
     * @param value A boolean indicating whether linked service is of type inline dataset. Currently only inline datasets are supported.
     */
    @JvmName("etjnjbocsispuasi")
    public suspend fun isInlineDataset(`value`: Output<Boolean>) {
        this.isInlineDataset = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("twhqnbiekmrqlkjk")
    public suspend fun linkedService(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedService = value
    }

    /**
     * @param value Type of the linked service e.g.: AzureBlobFS.
     */
    @JvmName("psohqftqvbejfnxd")
    public suspend fun linkedServiceType(`value`: Output<String>) {
        this.linkedServiceType = value
    }

    /**
     * @param value Type of connection via linked service or dataset.
     */
    @JvmName("jsdkmsmlansksgha")
    public suspend fun type(`value`: Output<Either<String, ConnectionType>>) {
        this.type = value
    }

    /**
     * @param value List of name/value pairs for connection properties.
     */
    @JvmName("plhljfxaslsximtr")
    public suspend
    fun commonDslConnectorProperties(`value`: List<MapperDslConnectorPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commonDslConnectorProperties = mapped
    }

    /**
     * @param argument List of name/value pairs for connection properties.
     */
    @JvmName("uotuwtjnscroctjq")
    public suspend
    fun commonDslConnectorProperties(argument: List<suspend MapperDslConnectorPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MapperDslConnectorPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.commonDslConnectorProperties = mapped
    }

    /**
     * @param argument List of name/value pairs for connection properties.
     */
    @JvmName("tmbndsolrhaxnlbo")
    public suspend fun commonDslConnectorProperties(
        vararg
        argument: suspend MapperDslConnectorPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MapperDslConnectorPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.commonDslConnectorProperties = mapped
    }

    /**
     * @param argument List of name/value pairs for connection properties.
     */
    @JvmName("pmkcbmtjjggwyoin")
    public suspend
    fun commonDslConnectorProperties(argument: suspend MapperDslConnectorPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MapperDslConnectorPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.commonDslConnectorProperties = mapped
    }

    /**
     * @param values List of name/value pairs for connection properties.
     */
    @JvmName("flhxadjfvarwywgr")
    public suspend fun commonDslConnectorProperties(vararg values: MapperDslConnectorPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commonDslConnectorProperties = mapped
    }

    /**
     * @param value A boolean indicating whether linked service is of type inline dataset. Currently only inline datasets are supported.
     */
    @JvmName("skdeawmcfchyfehw")
    public suspend fun isInlineDataset(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isInlineDataset = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("djxredmewekgvcdu")
    public suspend fun linkedService(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedService = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("bfjvcyiqniqfegky")
    public suspend fun linkedService(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedService = mapped
    }

    /**
     * @param value Type of the linked service e.g.: AzureBlobFS.
     */
    @JvmName("jvwfvmsnirjguxhh")
    public suspend fun linkedServiceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedServiceType = mapped
    }

    /**
     * @param value Type of connection via linked service or dataset.
     */
    @JvmName("mtvnjkgifccdgwxv")
    public suspend fun type(`value`: Either<String, ConnectionType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of connection via linked service or dataset.
     */
    @JvmName("pctayacmauncpexb")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConnectionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of connection via linked service or dataset.
     */
    @JvmName("ubpeugciqejqaxba")
    public fun type(`value`: ConnectionType) {
        val toBeMapped = Either.ofRight<String, ConnectionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): MapperConnectionArgs = MapperConnectionArgs(
        commonDslConnectorProperties = commonDslConnectorProperties,
        isInlineDataset = isInlineDataset,
        linkedService = linkedService,
        linkedServiceType = linkedServiceType,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
