@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.MapperConnectionReferenceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ConnectionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Source or target connection reference details.
 * @property connectionName Name of the connection
 * @property type Type of connection via linked service or dataset.
 */
public data class MapperConnectionReferenceArgs(
    public val connectionName: Output<String>? = null,
    public val type: Output<Either<String, ConnectionType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.MapperConnectionReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.MapperConnectionReferenceArgs =
        com.pulumi.azurenative.datafactory.inputs.MapperConnectionReferenceArgs.builder()
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [MapperConnectionReferenceArgs].
 */
@PulumiTagMarker
public class MapperConnectionReferenceArgsBuilder internal constructor() {
    private var connectionName: Output<String>? = null

    private var type: Output<Either<String, ConnectionType>>? = null

    /**
     * @param value Name of the connection
     */
    @JvmName("ainnfuvwotkpwwlq")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value Type of connection via linked service or dataset.
     */
    @JvmName("lrrusfmogooncrfn")
    public suspend fun type(`value`: Output<Either<String, ConnectionType>>) {
        this.type = value
    }

    /**
     * @param value Name of the connection
     */
    @JvmName("tnsggrtntnexqfhc")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value Type of connection via linked service or dataset.
     */
    @JvmName("tlxqckewhmfrkdny")
    public suspend fun type(`value`: Either<String, ConnectionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of connection via linked service or dataset.
     */
    @JvmName("hnijwrmyhuemrjgc")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConnectionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of connection via linked service or dataset.
     */
    @JvmName("jopmyddqpufjayrb")
    public fun type(`value`: ConnectionType) {
        val toBeMapped = Either.ofRight<String, ConnectionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): MapperConnectionReferenceArgs = MapperConnectionReferenceArgs(
        connectionName = connectionName,
        type = type,
    )
}
