@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.MapperDslConnectorPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Connector properties of a CDC table in terms of name / value pairs.
 * @property name Name of the property.
 * @property value Value of the property.
 */
public data class MapperDslConnectorPropertiesArgs(
    public val name: Output<String>? = null,
    public val `value`: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.MapperDslConnectorPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.MapperDslConnectorPropertiesArgs =
        com.pulumi.azurenative.datafactory.inputs.MapperDslConnectorPropertiesArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MapperDslConnectorPropertiesArgs].
 */
@PulumiTagMarker
public class MapperDslConnectorPropertiesArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<Any>? = null

    /**
     * @param value Name of the property.
     */
    @JvmName("icfhoohbtacawyus")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Value of the property.
     */
    @JvmName("gcjtwsudtccopfjs")
    public suspend fun `value`(`value`: Output<Any>) {
        this.`value` = value
    }

    /**
     * @param value Name of the property.
     */
    @JvmName("ieeqrkwfsdrjdkvu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Value of the property.
     */
    @JvmName("pbimogpmviprgfjk")
    public suspend fun `value`(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): MapperDslConnectorPropertiesArgs = MapperDslConnectorPropertiesArgs(
        name = name,
        `value` = `value`,
    )
}
