@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.MapperPolicyRecurrenceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.FrequencyType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * CDC policy recurrence details.
 * @property frequency Frequency of period in terms of 'Hour', 'Minute' or 'Second'.
 * @property interval Actual interval value as per chosen frequency.
 */
public data class MapperPolicyRecurrenceArgs(
    public val frequency: Output<Either<String, FrequencyType>>? = null,
    public val interval: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.MapperPolicyRecurrenceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.MapperPolicyRecurrenceArgs =
        com.pulumi.azurenative.datafactory.inputs.MapperPolicyRecurrenceArgs.builder()
            .frequency(
                frequency?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .interval(interval?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MapperPolicyRecurrenceArgs].
 */
@PulumiTagMarker
public class MapperPolicyRecurrenceArgsBuilder internal constructor() {
    private var frequency: Output<Either<String, FrequencyType>>? = null

    private var interval: Output<Int>? = null

    /**
     * @param value Frequency of period in terms of 'Hour', 'Minute' or 'Second'.
     */
    @JvmName("tnyiopdacslsmngg")
    public suspend fun frequency(`value`: Output<Either<String, FrequencyType>>) {
        this.frequency = value
    }

    /**
     * @param value Actual interval value as per chosen frequency.
     */
    @JvmName("rigsjkjsulksxcyo")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value Frequency of period in terms of 'Hour', 'Minute' or 'Second'.
     */
    @JvmName("dynlbxawhukhholr")
    public suspend fun frequency(`value`: Either<String, FrequencyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value Frequency of period in terms of 'Hour', 'Minute' or 'Second'.
     */
    @JvmName("ssblicnygvheucyf")
    public fun frequency(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FrequencyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value Frequency of period in terms of 'Hour', 'Minute' or 'Second'.
     */
    @JvmName("tfahamlxpkqqurgb")
    public fun frequency(`value`: FrequencyType) {
        val toBeMapped = Either.ofRight<String, FrequencyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value Actual interval value as per chosen frequency.
     */
    @JvmName("nqvimaksdxtwqdxf")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    internal fun build(): MapperPolicyRecurrenceArgs = MapperPolicyRecurrenceArgs(
        frequency = frequency,
        interval = interval,
    )
}
