@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.MapperTableSchemaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Schema of a CDC table in terms of column names and their corresponding data types.
 * @property dataType Data type of the column.
 * @property name Name of the column.
 */
public data class MapperTableSchemaArgs(
    public val dataType: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.MapperTableSchemaArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.MapperTableSchemaArgs =
        com.pulumi.azurenative.datafactory.inputs.MapperTableSchemaArgs.builder()
            .dataType(dataType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MapperTableSchemaArgs].
 */
@PulumiTagMarker
public class MapperTableSchemaArgsBuilder internal constructor() {
    private var dataType: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Data type of the column.
     */
    @JvmName("pgjeiiwjmcvcfulr")
    public suspend fun dataType(`value`: Output<String>) {
        this.dataType = value
    }

    /**
     * @param value Name of the column.
     */
    @JvmName("rwmravhtjokkjpkr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Data type of the column.
     */
    @JvmName("lgfyuvcfgppablci")
    public suspend fun dataType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataType = mapped
    }

    /**
     * @param value Name of the column.
     */
    @JvmName("wphybsohdjrvmfop")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): MapperTableSchemaArgs = MapperTableSchemaArgs(
        dataType = dataType,
        name = name,
    )
}
