@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.NotebookParameterArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.NotebookParameterType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Notebook parameter.
 * @property type Notebook parameter type.
 * @property value Notebook parameter value. Type: string (or Expression with resultType string).
 */
public data class NotebookParameterArgs(
    public val type: Output<Either<String, NotebookParameterType>>? = null,
    public val `value`: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.NotebookParameterArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.NotebookParameterArgs =
        com.pulumi.azurenative.datafactory.inputs.NotebookParameterArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NotebookParameterArgs].
 */
@PulumiTagMarker
public class NotebookParameterArgsBuilder internal constructor() {
    private var type: Output<Either<String, NotebookParameterType>>? = null

    private var `value`: Output<Any>? = null

    /**
     * @param value Notebook parameter type.
     */
    @JvmName("npsetxjyadjkfbnx")
    public suspend fun type(`value`: Output<Either<String, NotebookParameterType>>) {
        this.type = value
    }

    /**
     * @param value Notebook parameter value. Type: string (or Expression with resultType string).
     */
    @JvmName("jggummxbadssfbbj")
    public suspend fun `value`(`value`: Output<Any>) {
        this.`value` = value
    }

    /**
     * @param value Notebook parameter type.
     */
    @JvmName("rdbwmrecjryjavnj")
    public suspend fun type(`value`: Either<String, NotebookParameterType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Notebook parameter type.
     */
    @JvmName("rxdomvhboretbkse")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NotebookParameterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Notebook parameter type.
     */
    @JvmName("vbluvrpmmgrgfsmq")
    public fun type(`value`: NotebookParameterType) {
        val toBeMapped = Either.ofRight<String, NotebookParameterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Notebook parameter value. Type: string (or Expression with resultType string).
     */
    @JvmName("cibkipetwahtmdul")
    public suspend fun `value`(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): NotebookParameterArgs = NotebookParameterArgs(
        type = type,
        `value` = `value`,
    )
}
