@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ODataLinkedServiceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ODataAadServicePrincipalCredentialType
import com.pulumi.azurenative.datafactory.kotlin.enums.ODataAuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Open Data Protocol (OData) linked service.
 * @property aadResourceId Specify the resource you are requesting authorization to use Directory. Type: string (or Expression with resultType string).
 * @property aadServicePrincipalCredentialType Specify the credential type (key or cert) is used for service principal.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authHeaders The additional HTTP headers in the request to RESTful API used for authorization. Type: key value pairs (value should be string type).
 * @property authenticationType Type of authentication used to connect to the OData service.
 * @property azureCloudType Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property password Password of the OData service.
 * @property servicePrincipalEmbeddedCert Specify the base64 encoded certificate of your application registered in Azure Active Directory. Type: string (or Expression with resultType string).
 * @property servicePrincipalEmbeddedCertPassword Specify the password of your certificate if your certificate has a password and you are using AadServicePrincipal authentication. Type: string (or Expression with resultType string).
 * @property servicePrincipalId Specify the application id of your application registered in Azure Active Directory. Type: string (or Expression with resultType string).
 * @property servicePrincipalKey Specify the secret of your application registered in Azure Active Directory. Type: string (or Expression with resultType string).
 * @property tenant Specify the tenant information (domain name or tenant ID) under which your application resides. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'OData'.
 * @property url The URL of the OData service endpoint. Type: string (or Expression with resultType string).
 * @property userName User name of the OData service. Type: string (or Expression with resultType string).
 */
public data class ODataLinkedServiceArgs(
    public val aadResourceId: Output<Any>? = null,
    public val aadServicePrincipalCredentialType:
    Output<Either<String, ODataAadServicePrincipalCredentialType>>? = null,
    public val annotations: Output<List<Any>>? = null,
    public val authHeaders: Output<Any>? = null,
    public val authenticationType: Output<Either<String, ODataAuthenticationType>>? = null,
    public val azureCloudType: Output<Any>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val servicePrincipalEmbeddedCert:
    Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val servicePrincipalEmbeddedCertPassword:
    Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val servicePrincipalId: Output<Any>? = null,
    public val servicePrincipalKey:
    Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val tenant: Output<Any>? = null,
    public val type: Output<String>,
    public val url: Output<Any>,
    public val userName: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ODataLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ODataLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.ODataLinkedServiceArgs.builder()
            .aadResourceId(aadResourceId?.applyValue({ args0 -> args0 }))
            .aadServicePrincipalCredentialType(
                aadServicePrincipalCredentialType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authHeaders(authHeaders?.applyValue({ args0 -> args0 }))
            .authenticationType(
                authenticationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .azureCloudType(azureCloudType?.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(
                password?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .servicePrincipalEmbeddedCert(
                servicePrincipalEmbeddedCert?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0.let({ args0 -> args0.toJava() }) }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .servicePrincipalEmbeddedCertPassword(
                servicePrincipalEmbeddedCertPassword?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0.let({ args0 -> args0.toJava() }) }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .servicePrincipalId(servicePrincipalId?.applyValue({ args0 -> args0 }))
            .servicePrincipalKey(
                servicePrincipalKey?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .tenant(tenant?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .url(url.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ODataLinkedServiceArgs].
 */
@PulumiTagMarker
public class ODataLinkedServiceArgsBuilder internal constructor() {
    private var aadResourceId: Output<Any>? = null

    private var aadServicePrincipalCredentialType:
        Output<Either<String, ODataAadServicePrincipalCredentialType>>? = null

    private var annotations: Output<List<Any>>? = null

    private var authHeaders: Output<Any>? = null

    private var authenticationType: Output<Either<String, ODataAuthenticationType>>? = null

    private var azureCloudType: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var servicePrincipalEmbeddedCert:
        Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var servicePrincipalEmbeddedCertPassword:
        Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var servicePrincipalId: Output<Any>? = null

    private var servicePrincipalKey:
        Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var tenant: Output<Any>? = null

    private var type: Output<String>? = null

    private var url: Output<Any>? = null

    private var userName: Output<Any>? = null

    /**
     * @param value Specify the resource you are requesting authorization to use Directory. Type: string (or Expression with resultType string).
     */
    @JvmName("wmukpuvoqubfymlc")
    public suspend fun aadResourceId(`value`: Output<Any>) {
        this.aadResourceId = value
    }

    /**
     * @param value Specify the credential type (key or cert) is used for service principal.
     */
    @JvmName("onlsfvtqqpnxjpps")
    public suspend
    fun aadServicePrincipalCredentialType(`value`: Output<Either<String, ODataAadServicePrincipalCredentialType>>) {
        this.aadServicePrincipalCredentialType = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("uaytotfviaigdkeg")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("luwdluaxlddjxcga")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("grgeuysyqrlxvort")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The additional HTTP headers in the request to RESTful API used for authorization. Type: key value pairs (value should be string type).
     */
    @JvmName("wuvkyttvaopfhctt")
    public suspend fun authHeaders(`value`: Output<Any>) {
        this.authHeaders = value
    }

    /**
     * @param value Type of authentication used to connect to the OData service.
     */
    @JvmName("ldgahfibqtfnafaq")
    public suspend fun authenticationType(`value`: Output<Either<String, ODataAuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
     */
    @JvmName("dqhjobqtnikargkp")
    public suspend fun azureCloudType(`value`: Output<Any>) {
        this.azureCloudType = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("wemsubrjbpmtpsgb")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("silqwtmyoqfccjfb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("gxejpndmoxstncsg")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("kgxuancijvnybocm")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Password of the OData service.
     */
    @JvmName("jwhurfejgflosixe")
    public suspend
    fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value Specify the base64 encoded certificate of your application registered in Azure Active Directory. Type: string (or Expression with resultType string).
     */
    @JvmName("tegvjfwhmtnqxpke")
    public suspend
    fun servicePrincipalEmbeddedCert(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.servicePrincipalEmbeddedCert = value
    }

    /**
     * @param value Specify the password of your certificate if your certificate has a password and you are using AadServicePrincipal authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("jolncauevfwanjur")
    public suspend
    fun servicePrincipalEmbeddedCertPassword(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.servicePrincipalEmbeddedCertPassword = value
    }

    /**
     * @param value Specify the application id of your application registered in Azure Active Directory. Type: string (or Expression with resultType string).
     */
    @JvmName("doonnslhsatwnhar")
    public suspend fun servicePrincipalId(`value`: Output<Any>) {
        this.servicePrincipalId = value
    }

    /**
     * @param value Specify the secret of your application registered in Azure Active Directory. Type: string (or Expression with resultType string).
     */
    @JvmName("eyeknvykvegilvul")
    public suspend
    fun servicePrincipalKey(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.servicePrincipalKey = value
    }

    /**
     * @param value Specify the tenant information (domain name or tenant ID) under which your application resides. Type: string (or Expression with resultType string).
     */
    @JvmName("bsxxluokmkixdlay")
    public suspend fun tenant(`value`: Output<Any>) {
        this.tenant = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'OData'.
     */
    @JvmName("ejxvrdxeobowhdgg")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The URL of the OData service endpoint. Type: string (or Expression with resultType string).
     */
    @JvmName("wnbqijxbvxaytrgm")
    public suspend fun url(`value`: Output<Any>) {
        this.url = value
    }

    /**
     * @param value User name of the OData service. Type: string (or Expression with resultType string).
     */
    @JvmName("hepgbtgcalidhjym")
    public suspend fun userName(`value`: Output<Any>) {
        this.userName = value
    }

    /**
     * @param value Specify the resource you are requesting authorization to use Directory. Type: string (or Expression with resultType string).
     */
    @JvmName("wxsddiawjdgrdsva")
    public suspend fun aadResourceId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadResourceId = mapped
    }

    /**
     * @param value Specify the credential type (key or cert) is used for service principal.
     */
    @JvmName("xbxnylqhgtkuxboj")
    public suspend
    fun aadServicePrincipalCredentialType(`value`: Either<String, ODataAadServicePrincipalCredentialType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadServicePrincipalCredentialType = mapped
    }

    /**
     * @param value Specify the credential type (key or cert) is used for service principal.
     */
    @JvmName("krxpkjbhgwhdsrgm")
    public fun aadServicePrincipalCredentialType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ODataAadServicePrincipalCredentialType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aadServicePrincipalCredentialType = mapped
    }

    /**
     * @param value Specify the credential type (key or cert) is used for service principal.
     */
    @JvmName("omqytvfqtafkbfjy")
    public fun aadServicePrincipalCredentialType(`value`: ODataAadServicePrincipalCredentialType) {
        val toBeMapped = Either.ofRight<String, ODataAadServicePrincipalCredentialType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aadServicePrincipalCredentialType = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("puiqskvlxjhsxgle")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("huodwexjshywjbrd")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The additional HTTP headers in the request to RESTful API used for authorization. Type: key value pairs (value should be string type).
     */
    @JvmName("urufjuugmdefrwmp")
    public suspend fun authHeaders(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authHeaders = mapped
    }

    /**
     * @param value Type of authentication used to connect to the OData service.
     */
    @JvmName("mxpvkjrrnonaokxj")
    public suspend fun authenticationType(`value`: Either<String, ODataAuthenticationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Type of authentication used to connect to the OData service.
     */
    @JvmName("iobgkbkwiyvxfjfv")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ODataAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Type of authentication used to connect to the OData service.
     */
    @JvmName("abvnvongwticejbi")
    public fun authenticationType(`value`: ODataAuthenticationType) {
        val toBeMapped = Either.ofRight<String, ODataAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
     */
    @JvmName("gdblftvhbxdifqvp")
    public suspend fun azureCloudType(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureCloudType = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("xffusdajsqwxbijw")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("owwpsctnymuqpojt")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("louqnxpqihfsrrpx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("lrwrjfngmujtvfmm")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("ongsbgrhlkrxaojd")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("rgphovqsfgpvwrti")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("gjjmipwvvpoysyhr")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Password of the OData service.
     */
    @JvmName("kcepcrlwctvvlkjt")
    public suspend
    fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password of the OData service.
     */
    @JvmName("hihjqphdobojeeps")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password of the OData service.
     */
    @JvmName("rrknpxcknwxolejs")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Specify the base64 encoded certificate of your application registered in Azure Active Directory. Type: string (or Expression with resultType string).
     */
    @JvmName("rawwgcfbvupiwwmk")
    public suspend
    fun servicePrincipalEmbeddedCert(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalEmbeddedCert = mapped
    }

    /**
     * @param value Specify the base64 encoded certificate of your application registered in Azure Active Directory. Type: string (or Expression with resultType string).
     */
    @JvmName("erhgpyqgaidujujv")
    public fun servicePrincipalEmbeddedCert(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalEmbeddedCert = mapped
    }

    /**
     * @param value Specify the base64 encoded certificate of your application registered in Azure Active Directory. Type: string (or Expression with resultType string).
     */
    @JvmName("cfxanrdqrybuyixj")
    public fun servicePrincipalEmbeddedCert(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalEmbeddedCert = mapped
    }

    /**
     * @param value Specify the password of your certificate if your certificate has a password and you are using AadServicePrincipal authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("snrfiduoovrftbfa")
    public suspend
    fun servicePrincipalEmbeddedCertPassword(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalEmbeddedCertPassword = mapped
    }

    /**
     * @param value Specify the password of your certificate if your certificate has a password and you are using AadServicePrincipal authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("ulkunvdojpbaxvsu")
    public fun servicePrincipalEmbeddedCertPassword(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalEmbeddedCertPassword = mapped
    }

    /**
     * @param value Specify the password of your certificate if your certificate has a password and you are using AadServicePrincipal authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("hxdbgsuvrkacogqh")
    public fun servicePrincipalEmbeddedCertPassword(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalEmbeddedCertPassword = mapped
    }

    /**
     * @param value Specify the application id of your application registered in Azure Active Directory. Type: string (or Expression with resultType string).
     */
    @JvmName("jhhqqxubclamnopx")
    public suspend fun servicePrincipalId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalId = mapped
    }

    /**
     * @param value Specify the secret of your application registered in Azure Active Directory. Type: string (or Expression with resultType string).
     */
    @JvmName("ekjyitjqiasrirrr")
    public suspend
    fun servicePrincipalKey(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value Specify the secret of your application registered in Azure Active Directory. Type: string (or Expression with resultType string).
     */
    @JvmName("lajphnqxofqxchgn")
    public fun servicePrincipalKey(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value Specify the secret of your application registered in Azure Active Directory. Type: string (or Expression with resultType string).
     */
    @JvmName("kufbaosgbdhvaeox")
    public fun servicePrincipalKey(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value Specify the tenant information (domain name or tenant ID) under which your application resides. Type: string (or Expression with resultType string).
     */
    @JvmName("geujttdrhicxiisi")
    public suspend fun tenant(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenant = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'OData'.
     */
    @JvmName("sorwhpckllmikoah")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The URL of the OData service endpoint. Type: string (or Expression with resultType string).
     */
    @JvmName("bsnnugdieucqsovd")
    public suspend fun url(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    /**
     * @param value User name of the OData service. Type: string (or Expression with resultType string).
     */
    @JvmName("fofyppdsuolrymyk")
    public suspend fun userName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): ODataLinkedServiceArgs = ODataLinkedServiceArgs(
        aadResourceId = aadResourceId,
        aadServicePrincipalCredentialType = aadServicePrincipalCredentialType,
        annotations = annotations,
        authHeaders = authHeaders,
        authenticationType = authenticationType,
        azureCloudType = azureCloudType,
        connectVia = connectVia,
        description = description,
        encryptedCredential = encryptedCredential,
        parameters = parameters,
        password = password,
        servicePrincipalEmbeddedCert = servicePrincipalEmbeddedCert,
        servicePrincipalEmbeddedCertPassword = servicePrincipalEmbeddedCertPassword,
        servicePrincipalId = servicePrincipalId,
        servicePrincipalKey = servicePrincipalKey,
        tenant = tenant,
        type = type ?: throw PulumiNullFieldException("type"),
        url = url ?: throw PulumiNullFieldException("url"),
        userName = userName,
    )
}
