@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.Office365LinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Office365 linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property office365TenantId Azure tenant ID to which the Office 365 account belongs. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property servicePrincipalId Specify the application's client ID. Type: string (or Expression with resultType string).
 * @property servicePrincipalKey Specify the application's key.
 * @property servicePrincipalTenantId Specify the tenant information under which your Azure AD web application resides. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'Office365'.
 */
public data class Office365LinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val office365TenantId: Output<Any>,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val servicePrincipalId: Output<Any>,
    public val servicePrincipalKey:
    Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>,
    public val servicePrincipalTenantId: Output<Any>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.Office365LinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.Office365LinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.Office365LinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .office365TenantId(office365TenantId.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .servicePrincipalId(servicePrincipalId.applyValue({ args0 -> args0 }))
            .servicePrincipalKey(
                servicePrincipalKey.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .servicePrincipalTenantId(servicePrincipalTenantId.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [Office365LinkedServiceArgs].
 */
@PulumiTagMarker
public class Office365LinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var office365TenantId: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var servicePrincipalId: Output<Any>? = null

    private var servicePrincipalKey:
        Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var servicePrincipalTenantId: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("dhmycsowsghmkfeb")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("mfuwmjwufimkbipr")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("ymgpbgqgbhtapjxs")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("vyntpkvhyxympfbk")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("gwpugtfivueukace")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("uqdrbvusbogllimj")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value Azure tenant ID to which the Office 365 account belongs. Type: string (or Expression with resultType string).
     */
    @JvmName("fodrnixapwxusfts")
    public suspend fun office365TenantId(`value`: Output<Any>) {
        this.office365TenantId = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("ncjnumqhgvabddpa")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Specify the application's client ID. Type: string (or Expression with resultType string).
     */
    @JvmName("xtucgvfhyrtqrfth")
    public suspend fun servicePrincipalId(`value`: Output<Any>) {
        this.servicePrincipalId = value
    }

    /**
     * @param value Specify the application's key.
     */
    @JvmName("yrbnjstcbncplfix")
    public suspend
    fun servicePrincipalKey(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.servicePrincipalKey = value
    }

    /**
     * @param value Specify the tenant information under which your Azure AD web application resides. Type: string (or Expression with resultType string).
     */
    @JvmName("qtwfkqlkqfpaiukm")
    public suspend fun servicePrincipalTenantId(`value`: Output<Any>) {
        this.servicePrincipalTenantId = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Office365'.
     */
    @JvmName("gumciijjhocqhchk")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("vtlgvpyfbtqgrrca")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("sejmlpxjjxefvrff")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("wghljewshnuspibv")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("lnjyjnxjwiisugba")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("ifppfkolhltjjhlm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("lvsccsqfgpurdeof")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value Azure tenant ID to which the Office 365 account belongs. Type: string (or Expression with resultType string).
     */
    @JvmName("ueacunayxxykkqje")
    public suspend fun office365TenantId(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.office365TenantId = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("pgmhdpvncviteyyy")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("veqqbuxnjevdlcdy")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("bgjoogyjyejcgvlo")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Specify the application's client ID. Type: string (or Expression with resultType string).
     */
    @JvmName("etvaenlhpvxmjpio")
    public suspend fun servicePrincipalId(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalId = mapped
    }

    /**
     * @param value Specify the application's key.
     */
    @JvmName("dtgidrdnxtervlyy")
    public suspend
    fun servicePrincipalKey(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value Specify the application's key.
     */
    @JvmName("bqqduhjjpjntrnih")
    public fun servicePrincipalKey(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value Specify the application's key.
     */
    @JvmName("kkllwikrjgpyfafo")
    public fun servicePrincipalKey(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value Specify the tenant information under which your Azure AD web application resides. Type: string (or Expression with resultType string).
     */
    @JvmName("lvqymljisffwvfpl")
    public suspend fun servicePrincipalTenantId(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalTenantId = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Office365'.
     */
    @JvmName("tjscgwpricicbdco")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): Office365LinkedServiceArgs = Office365LinkedServiceArgs(
        annotations = annotations,
        connectVia = connectVia,
        description = description,
        encryptedCredential = encryptedCredential,
        office365TenantId = office365TenantId ?: throw PulumiNullFieldException("office365TenantId"),
        parameters = parameters,
        servicePrincipalId = servicePrincipalId ?: throw PulumiNullFieldException("servicePrincipalId"),
        servicePrincipalKey = servicePrincipalKey ?: throw PulumiNullFieldException("servicePrincipalKey"),
        servicePrincipalTenantId = servicePrincipalTenantId ?: throw
            PulumiNullFieldException("servicePrincipalTenantId"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
