@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.Office365SourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A copy activity source for an Office 365 service.
 * @property allowedGroups The groups containing all the users. Type: array of strings (or Expression with resultType array of strings).
 * @property dateFilterColumn The Column to apply the <paramref name="StartTime"/> and <paramref name="EndTime"/>. Type: string (or Expression with resultType string).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property endTime End time of the requested range for this dataset. Type: string (or Expression with resultType string).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property outputColumns The columns to be read out from the Office 365 table. Type: array of objects (or Expression with resultType array of objects). itemType: OutputColumn. Example: [ { "name": "Id" }, { "name": "CreatedDateTime" } ]
 * @property sourceRetryCount Source retry count. Type: integer (or Expression with resultType integer).
 * @property sourceRetryWait Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property startTime Start time of the requested range for this dataset. Type: string (or Expression with resultType string).
 * @property type Copy source type.
 * Expected value is 'Office365Source'.
 * @property userScopeFilterUri The user scope uri. Type: string (or Expression with resultType string).
 */
public data class Office365SourceArgs(
    public val allowedGroups: Output<Any>? = null,
    public val dateFilterColumn: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val endTime: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val outputColumns: Output<Any>? = null,
    public val sourceRetryCount: Output<Any>? = null,
    public val sourceRetryWait: Output<Any>? = null,
    public val startTime: Output<Any>? = null,
    public val type: Output<String>,
    public val userScopeFilterUri: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.Office365SourceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.Office365SourceArgs =
        com.pulumi.azurenative.datafactory.inputs.Office365SourceArgs.builder()
            .allowedGroups(allowedGroups?.applyValue({ args0 -> args0 }))
            .dateFilterColumn(dateFilterColumn?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .outputColumns(outputColumns?.applyValue({ args0 -> args0 }))
            .sourceRetryCount(sourceRetryCount?.applyValue({ args0 -> args0 }))
            .sourceRetryWait(sourceRetryWait?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .userScopeFilterUri(userScopeFilterUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [Office365SourceArgs].
 */
@PulumiTagMarker
public class Office365SourceArgsBuilder internal constructor() {
    private var allowedGroups: Output<Any>? = null

    private var dateFilterColumn: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var endTime: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var outputColumns: Output<Any>? = null

    private var sourceRetryCount: Output<Any>? = null

    private var sourceRetryWait: Output<Any>? = null

    private var startTime: Output<Any>? = null

    private var type: Output<String>? = null

    private var userScopeFilterUri: Output<Any>? = null

    /**
     * @param value The groups containing all the users. Type: array of strings (or Expression with resultType array of strings).
     */
    @JvmName("ngtqfebinnyifpju")
    public suspend fun allowedGroups(`value`: Output<Any>) {
        this.allowedGroups = value
    }

    /**
     * @param value The Column to apply the <paramref name="StartTime"/> and <paramref name="EndTime"/>. Type: string (or Expression with resultType string).
     */
    @JvmName("odpfpmvhnawvrfsf")
    public suspend fun dateFilterColumn(`value`: Output<Any>) {
        this.dateFilterColumn = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("spfyfyvqvhlotldd")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value End time of the requested range for this dataset. Type: string (or Expression with resultType string).
     */
    @JvmName("arglgcvhrjuckwrc")
    public suspend fun endTime(`value`: Output<Any>) {
        this.endTime = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("wwdmlksrlqdvuuio")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value The columns to be read out from the Office 365 table. Type: array of objects (or Expression with resultType array of objects). itemType: OutputColumn. Example: [ { "name": "Id" }, { "name": "CreatedDateTime" } ]
     */
    @JvmName("cyskmqjirsgdgnjw")
    public suspend fun outputColumns(`value`: Output<Any>) {
        this.outputColumns = value
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("pdqigewgclkvedli")
    public suspend fun sourceRetryCount(`value`: Output<Any>) {
        this.sourceRetryCount = value
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("ndnuamshuggtvmyi")
    public suspend fun sourceRetryWait(`value`: Output<Any>) {
        this.sourceRetryWait = value
    }

    /**
     * @param value Start time of the requested range for this dataset. Type: string (or Expression with resultType string).
     */
    @JvmName("lhbvqftvybluojfr")
    public suspend fun startTime(`value`: Output<Any>) {
        this.startTime = value
    }

    /**
     * @param value Copy source type.
     * Expected value is 'Office365Source'.
     */
    @JvmName("vegudcvlwqfiyeec")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The user scope uri. Type: string (or Expression with resultType string).
     */
    @JvmName("llmerxddpcuhhoxr")
    public suspend fun userScopeFilterUri(`value`: Output<Any>) {
        this.userScopeFilterUri = value
    }

    /**
     * @param value The groups containing all the users. Type: array of strings (or Expression with resultType array of strings).
     */
    @JvmName("slcoycifofdgwoof")
    public suspend fun allowedGroups(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedGroups = mapped
    }

    /**
     * @param value The Column to apply the <paramref name="StartTime"/> and <paramref name="EndTime"/>. Type: string (or Expression with resultType string).
     */
    @JvmName("ndlrcylswaoyilsp")
    public suspend fun dateFilterColumn(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dateFilterColumn = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("xcflpvjgkvkgfgnk")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value End time of the requested range for this dataset. Type: string (or Expression with resultType string).
     */
    @JvmName("difuaueedwpeulah")
    public suspend fun endTime(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("hgulxsffpywjvxbv")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value The columns to be read out from the Office 365 table. Type: array of objects (or Expression with resultType array of objects). itemType: OutputColumn. Example: [ { "name": "Id" }, { "name": "CreatedDateTime" } ]
     */
    @JvmName("ygapsmmwmiqnuwya")
    public suspend fun outputColumns(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputColumns = mapped
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("cpsartmdqwpvhekv")
    public suspend fun sourceRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryCount = mapped
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("apjtdiuwowyaboqi")
    public suspend fun sourceRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryWait = mapped
    }

    /**
     * @param value Start time of the requested range for this dataset. Type: string (or Expression with resultType string).
     */
    @JvmName("rxmrhrbkpdnbvrjo")
    public suspend fun startTime(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value Copy source type.
     * Expected value is 'Office365Source'.
     */
    @JvmName("feojrxqnmwcusapl")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The user scope uri. Type: string (or Expression with resultType string).
     */
    @JvmName("shfpgenocnwkknev")
    public suspend fun userScopeFilterUri(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userScopeFilterUri = mapped
    }

    internal fun build(): Office365SourceArgs = Office365SourceArgs(
        allowedGroups = allowedGroups,
        dateFilterColumn = dateFilterColumn,
        disableMetricsCollection = disableMetricsCollection,
        endTime = endTime,
        maxConcurrentConnections = maxConcurrentConnections,
        outputColumns = outputColumns,
        sourceRetryCount = sourceRetryCount,
        sourceRetryWait = sourceRetryWait,
        startTime = startTime,
        type = type ?: throw PulumiNullFieldException("type"),
        userScopeFilterUri = userScopeFilterUri,
    )
}
