@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.PackageStoreArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Package store for the SSIS integration runtime.
 * @property name The name of the package store
 * @property packageStoreLinkedService The package store linked service reference.
 */
public data class PackageStoreArgs(
    public val name: Output<String>,
    public val packageStoreLinkedService: Output<EntityReferenceArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.PackageStoreArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.PackageStoreArgs =
        com.pulumi.azurenative.datafactory.inputs.PackageStoreArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .packageStoreLinkedService(
                packageStoreLinkedService.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [PackageStoreArgs].
 */
@PulumiTagMarker
public class PackageStoreArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var packageStoreLinkedService: Output<EntityReferenceArgs>? = null

    /**
     * @param value The name of the package store
     */
    @JvmName("sedfwfodgwejvieb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The package store linked service reference.
     */
    @JvmName("gqgqopadxivdlgns")
    public suspend fun packageStoreLinkedService(`value`: Output<EntityReferenceArgs>) {
        this.packageStoreLinkedService = value
    }

    /**
     * @param value The name of the package store
     */
    @JvmName("pgrgwampdogbotbk")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The package store linked service reference.
     */
    @JvmName("jtyrmesdlwlaawjq")
    public suspend fun packageStoreLinkedService(`value`: EntityReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.packageStoreLinkedService = mapped
    }

    /**
     * @param argument The package store linked service reference.
     */
    @JvmName("xpjrfchmlwhmfcsc")
    public suspend
    fun packageStoreLinkedService(argument: suspend EntityReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = EntityReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.packageStoreLinkedService = mapped
    }

    internal fun build(): PackageStoreArgs = PackageStoreArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        packageStoreLinkedService = packageStoreLinkedService ?: throw
            PulumiNullFieldException("packageStoreLinkedService"),
    )
}
