@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.PipelineElapsedTimeMetricPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Pipeline ElapsedTime Metric Policy.
 * @property duration TimeSpan value, after which an Azure Monitoring Metric is fired.
 */
public data class PipelineElapsedTimeMetricPolicyArgs(
    public val duration: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.PipelineElapsedTimeMetricPolicyArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.PipelineElapsedTimeMetricPolicyArgs =
        com.pulumi.azurenative.datafactory.inputs.PipelineElapsedTimeMetricPolicyArgs.builder()
            .duration(duration?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineElapsedTimeMetricPolicyArgs].
 */
@PulumiTagMarker
public class PipelineElapsedTimeMetricPolicyArgsBuilder internal constructor() {
    private var duration: Output<Any>? = null

    /**
     * @param value TimeSpan value, after which an Azure Monitoring Metric is fired.
     */
    @JvmName("avsbjbljcxsaabeu")
    public suspend fun duration(`value`: Output<Any>) {
        this.duration = value
    }

    /**
     * @param value TimeSpan value, after which an Azure Monitoring Metric is fired.
     */
    @JvmName("bwitwsyegjypcido")
    public suspend fun duration(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    internal fun build(): PipelineElapsedTimeMetricPolicyArgs = PipelineElapsedTimeMetricPolicyArgs(
        duration = duration,
    )
}
