@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.PipelineReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Pipeline reference type.
 * @property name Reference name.
 * @property referenceName Reference pipeline name.
 * @property type Pipeline reference type.
 */
public data class PipelineReferenceArgs(
    public val name: Output<String>? = null,
    public val referenceName: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.PipelineReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.PipelineReferenceArgs =
        com.pulumi.azurenative.datafactory.inputs.PipelineReferenceArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .referenceName(referenceName.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineReferenceArgs].
 */
@PulumiTagMarker
public class PipelineReferenceArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var referenceName: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Reference name.
     */
    @JvmName("oydfqdiqeplmwfui")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Reference pipeline name.
     */
    @JvmName("hxmjaiarbqvjbouv")
    public suspend fun referenceName(`value`: Output<String>) {
        this.referenceName = value
    }

    /**
     * @param value Pipeline reference type.
     */
    @JvmName("fubxhamvjywlognq")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Reference name.
     */
    @JvmName("dyetexlqyhimkgfi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Reference pipeline name.
     */
    @JvmName("ykmhurruqyyhccac")
    public suspend fun referenceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referenceName = mapped
    }

    /**
     * @param value Pipeline reference type.
     */
    @JvmName("xlmxjhyibgkmsden")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PipelineReferenceArgs = PipelineReferenceArgs(
        name = name,
        referenceName = referenceName ?: throw PulumiNullFieldException("referenceName"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
