@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.PolybaseSettingsArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.PolybaseSettingsRejectType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * PolyBase settings.
 * @property rejectSampleValue Determines the number of rows to attempt to retrieve before the PolyBase recalculates the percentage of rejected rows. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property rejectType Reject type.
 * @property rejectValue Specifies the value or the percentage of rows that can be rejected before the query fails. Type: number (or Expression with resultType number), minimum: 0.
 * @property useTypeDefault Specifies how to handle missing values in delimited text files when PolyBase retrieves data from the text file. Type: boolean (or Expression with resultType boolean).
 */
public data class PolybaseSettingsArgs(
    public val rejectSampleValue: Output<Any>? = null,
    public val rejectType: Output<Either<String, PolybaseSettingsRejectType>>? = null,
    public val rejectValue: Output<Any>? = null,
    public val useTypeDefault: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.PolybaseSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.PolybaseSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.PolybaseSettingsArgs.builder()
            .rejectSampleValue(rejectSampleValue?.applyValue({ args0 -> args0 }))
            .rejectType(
                rejectType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .rejectValue(rejectValue?.applyValue({ args0 -> args0 }))
            .useTypeDefault(useTypeDefault?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolybaseSettingsArgs].
 */
@PulumiTagMarker
public class PolybaseSettingsArgsBuilder internal constructor() {
    private var rejectSampleValue: Output<Any>? = null

    private var rejectType: Output<Either<String, PolybaseSettingsRejectType>>? = null

    private var rejectValue: Output<Any>? = null

    private var useTypeDefault: Output<Any>? = null

    /**
     * @param value Determines the number of rows to attempt to retrieve before the PolyBase recalculates the percentage of rejected rows. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("wyiuwecbyvkbtqri")
    public suspend fun rejectSampleValue(`value`: Output<Any>) {
        this.rejectSampleValue = value
    }

    /**
     * @param value Reject type.
     */
    @JvmName("ayxuyitwmdyxbevf")
    public suspend fun rejectType(`value`: Output<Either<String, PolybaseSettingsRejectType>>) {
        this.rejectType = value
    }

    /**
     * @param value Specifies the value or the percentage of rows that can be rejected before the query fails. Type: number (or Expression with resultType number), minimum: 0.
     */
    @JvmName("yfciipkuyxpcgrau")
    public suspend fun rejectValue(`value`: Output<Any>) {
        this.rejectValue = value
    }

    /**
     * @param value Specifies how to handle missing values in delimited text files when PolyBase retrieves data from the text file. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("frieekeqtkovsheh")
    public suspend fun useTypeDefault(`value`: Output<Any>) {
        this.useTypeDefault = value
    }

    /**
     * @param value Determines the number of rows to attempt to retrieve before the PolyBase recalculates the percentage of rejected rows. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("qoidxleohvmorcjp")
    public suspend fun rejectSampleValue(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rejectSampleValue = mapped
    }

    /**
     * @param value Reject type.
     */
    @JvmName("sprjmfephtnolsfi")
    public suspend fun rejectType(`value`: Either<String, PolybaseSettingsRejectType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rejectType = mapped
    }

    /**
     * @param value Reject type.
     */
    @JvmName("unewqqorrcdwduwf")
    public fun rejectType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolybaseSettingsRejectType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rejectType = mapped
    }

    /**
     * @param value Reject type.
     */
    @JvmName("yiyeajiclbudtpms")
    public fun rejectType(`value`: PolybaseSettingsRejectType) {
        val toBeMapped = Either.ofRight<String, PolybaseSettingsRejectType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rejectType = mapped
    }

    /**
     * @param value Specifies the value or the percentage of rows that can be rejected before the query fails. Type: number (or Expression with resultType number), minimum: 0.
     */
    @JvmName("lnakqkqywdtskdju")
    public suspend fun rejectValue(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rejectValue = mapped
    }

    /**
     * @param value Specifies how to handle missing values in delimited text files when PolyBase retrieves data from the text file. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("xdwotnxtajkdawoj")
    public suspend fun useTypeDefault(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useTypeDefault = mapped
    }

    internal fun build(): PolybaseSettingsArgs = PolybaseSettingsArgs(
        rejectSampleValue = rejectSampleValue,
        rejectType = rejectType,
        rejectValue = rejectValue,
        useTypeDefault = useTypeDefault,
    )
}
