@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.RedirectIncompatibleRowSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Redirect incompatible row settings
 * @property linkedServiceName Name of the Azure Storage, Storage SAS, or Azure Data Lake Store linked service used for redirecting incompatible row. Must be specified if redirectIncompatibleRowSettings is specified. Type: string (or Expression with resultType string).
 * @property path The path for storing the redirect incompatible row data. Type: string (or Expression with resultType string).
 */
public data class RedirectIncompatibleRowSettingsArgs(
    public val linkedServiceName: Output<Any>,
    public val path: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.RedirectIncompatibleRowSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.RedirectIncompatibleRowSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.RedirectIncompatibleRowSettingsArgs.builder()
            .linkedServiceName(linkedServiceName.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RedirectIncompatibleRowSettingsArgs].
 */
@PulumiTagMarker
public class RedirectIncompatibleRowSettingsArgsBuilder internal constructor() {
    private var linkedServiceName: Output<Any>? = null

    private var path: Output<Any>? = null

    /**
     * @param value Name of the Azure Storage, Storage SAS, or Azure Data Lake Store linked service used for redirecting incompatible row. Must be specified if redirectIncompatibleRowSettings is specified. Type: string (or Expression with resultType string).
     */
    @JvmName("besrvadandkiskdm")
    public suspend fun linkedServiceName(`value`: Output<Any>) {
        this.linkedServiceName = value
    }

    /**
     * @param value The path for storing the redirect incompatible row data. Type: string (or Expression with resultType string).
     */
    @JvmName("sjivhweundofkpkg")
    public suspend fun path(`value`: Output<Any>) {
        this.path = value
    }

    /**
     * @param value Name of the Azure Storage, Storage SAS, or Azure Data Lake Store linked service used for redirecting incompatible row. Must be specified if redirectIncompatibleRowSettings is specified. Type: string (or Expression with resultType string).
     */
    @JvmName("cflyuvgbjqwqqvjw")
    public suspend fun linkedServiceName(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param value The path for storing the redirect incompatible row data. Type: string (or Expression with resultType string).
     */
    @JvmName("xsnxvfmnniixqifx")
    public suspend fun path(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): RedirectIncompatibleRowSettingsArgs = RedirectIncompatibleRowSettingsArgs(
        linkedServiceName = linkedServiceName ?: throw PulumiNullFieldException("linkedServiceName"),
        path = path,
    )
}
