@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.RerunTumblingWindowTriggerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Trigger that schedules pipeline reruns for all fixed time interval windows from a requested start time to requested end time.
 * @property annotations List of tags that can be used for describing the trigger.
 * @property description Trigger description.
 * @property parentTrigger The parent trigger reference.
 * @property requestedEndTime The end time for the time period for which restatement is initiated. Only UTC time is currently supported.
 * @property requestedStartTime The start time for the time period for which restatement is initiated. Only UTC time is currently supported.
 * @property rerunConcurrency The max number of parallel time windows (ready for execution) for which a rerun is triggered.
 * @property type Trigger type.
 * Expected value is 'RerunTumblingWindowTrigger'.
 */
public data class RerunTumblingWindowTriggerArgs(
    public val annotations: Output<List<Any>>? = null,
    public val description: Output<String>? = null,
    public val parentTrigger: Output<Any>,
    public val requestedEndTime: Output<String>,
    public val requestedStartTime: Output<String>,
    public val rerunConcurrency: Output<Int>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.RerunTumblingWindowTriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.RerunTumblingWindowTriggerArgs =
        com.pulumi.azurenative.datafactory.inputs.RerunTumblingWindowTriggerArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .parentTrigger(parentTrigger.applyValue({ args0 -> args0 }))
            .requestedEndTime(requestedEndTime.applyValue({ args0 -> args0 }))
            .requestedStartTime(requestedStartTime.applyValue({ args0 -> args0 }))
            .rerunConcurrency(rerunConcurrency.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RerunTumblingWindowTriggerArgs].
 */
@PulumiTagMarker
public class RerunTumblingWindowTriggerArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var description: Output<String>? = null

    private var parentTrigger: Output<Any>? = null

    private var requestedEndTime: Output<String>? = null

    private var requestedStartTime: Output<String>? = null

    private var rerunConcurrency: Output<Int>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the trigger.
     */
    @JvmName("dencpybpjhbgtlhg")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("bvrxpcmndsbslejr")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the trigger.
     */
    @JvmName("qbtfylpisyhfoqcn")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value Trigger description.
     */
    @JvmName("netinrkvtrqlcfoa")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The parent trigger reference.
     */
    @JvmName("qicgenveipfiiqqo")
    public suspend fun parentTrigger(`value`: Output<Any>) {
        this.parentTrigger = value
    }

    /**
     * @param value The end time for the time period for which restatement is initiated. Only UTC time is currently supported.
     */
    @JvmName("iocjgfgdahqeiect")
    public suspend fun requestedEndTime(`value`: Output<String>) {
        this.requestedEndTime = value
    }

    /**
     * @param value The start time for the time period for which restatement is initiated. Only UTC time is currently supported.
     */
    @JvmName("ngipomgfbjldvwmk")
    public suspend fun requestedStartTime(`value`: Output<String>) {
        this.requestedStartTime = value
    }

    /**
     * @param value The max number of parallel time windows (ready for execution) for which a rerun is triggered.
     */
    @JvmName("uabpskjsghtqtluo")
    public suspend fun rerunConcurrency(`value`: Output<Int>) {
        this.rerunConcurrency = value
    }

    /**
     * @param value Trigger type.
     * Expected value is 'RerunTumblingWindowTrigger'.
     */
    @JvmName("nxorloprktkubaif")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the trigger.
     */
    @JvmName("vrvnywkwvctwcsem")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the trigger.
     */
    @JvmName("wqnvcfyhvvreaxai")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Trigger description.
     */
    @JvmName("fxwumvxaghysalgi")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The parent trigger reference.
     */
    @JvmName("xdphojrobvqtjigo")
    public suspend fun parentTrigger(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parentTrigger = mapped
    }

    /**
     * @param value The end time for the time period for which restatement is initiated. Only UTC time is currently supported.
     */
    @JvmName("qqykenwvsjfseuxn")
    public suspend fun requestedEndTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestedEndTime = mapped
    }

    /**
     * @param value The start time for the time period for which restatement is initiated. Only UTC time is currently supported.
     */
    @JvmName("kaifoblwntnwdery")
    public suspend fun requestedStartTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestedStartTime = mapped
    }

    /**
     * @param value The max number of parallel time windows (ready for execution) for which a rerun is triggered.
     */
    @JvmName("drpntweiorplsgwq")
    public suspend fun rerunConcurrency(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rerunConcurrency = mapped
    }

    /**
     * @param value Trigger type.
     * Expected value is 'RerunTumblingWindowTrigger'.
     */
    @JvmName("jaohgsuvndldmrsg")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): RerunTumblingWindowTriggerArgs = RerunTumblingWindowTriggerArgs(
        annotations = annotations,
        description = description,
        parentTrigger = parentTrigger ?: throw PulumiNullFieldException("parentTrigger"),
        requestedEndTime = requestedEndTime ?: throw PulumiNullFieldException("requestedEndTime"),
        requestedStartTime = requestedStartTime ?: throw PulumiNullFieldException("requestedStartTime"),
        rerunConcurrency = rerunConcurrency ?: throw PulumiNullFieldException("rerunConcurrency"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
