@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.RestResourceDatasetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A Rest service dataset.
 * @property additionalHeaders The additional HTTP headers in the request to the RESTful API.
 * @property annotations List of tags that can be used for describing the Dataset.
 * @property description Dataset description.
 * @property folder The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
 * @property linkedServiceName Linked service reference.
 * @property paginationRules The pagination rules to compose next page requests.
 * @property parameters Parameters for dataset.
 * @property relativeUrl The relative URL to the resource that the RESTful API provides. Type: string (or Expression with resultType string).
 * @property requestBody The HTTP request body to the RESTful API if requestMethod is POST. Type: string (or Expression with resultType string).
 * @property requestMethod The HTTP method used to call the RESTful API. The default is GET. Type: string (or Expression with resultType string).
 * @property schema Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
 * @property structure Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
 * @property type Type of dataset.
 * Expected value is 'RestResource'.
 */
public data class RestResourceDatasetArgs(
    public val additionalHeaders: Output<Map<String, Any>>? = null,
    public val annotations: Output<List<Any>>? = null,
    public val description: Output<String>? = null,
    public val folder: Output<DatasetFolderArgs>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>,
    public val paginationRules: Output<Map<String, Any>>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val relativeUrl: Output<Any>? = null,
    public val requestBody: Output<Any>? = null,
    public val requestMethod: Output<Any>? = null,
    public val schema: Output<Any>? = null,
    public val structure: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.RestResourceDatasetArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.RestResourceDatasetArgs =
        com.pulumi.azurenative.datafactory.inputs.RestResourceDatasetArgs.builder()
            .additionalHeaders(
                additionalHeaders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .folder(folder?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .linkedServiceName(linkedServiceName.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .paginationRules(
                paginationRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .relativeUrl(relativeUrl?.applyValue({ args0 -> args0 }))
            .requestBody(requestBody?.applyValue({ args0 -> args0 }))
            .requestMethod(requestMethod?.applyValue({ args0 -> args0 }))
            .schema(schema?.applyValue({ args0 -> args0 }))
            .structure(structure?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RestResourceDatasetArgs].
 */
@PulumiTagMarker
public class RestResourceDatasetArgsBuilder internal constructor() {
    private var additionalHeaders: Output<Map<String, Any>>? = null

    private var annotations: Output<List<Any>>? = null

    private var description: Output<String>? = null

    private var folder: Output<DatasetFolderArgs>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var paginationRules: Output<Map<String, Any>>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var relativeUrl: Output<Any>? = null

    private var requestBody: Output<Any>? = null

    private var requestMethod: Output<Any>? = null

    private var schema: Output<Any>? = null

    private var structure: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value The additional HTTP headers in the request to the RESTful API.
     */
    @JvmName("bpfcetuitddtwcrm")
    public suspend fun additionalHeaders(`value`: Output<Map<String, Any>>) {
        this.additionalHeaders = value
    }

    /**
     * @param value List of tags that can be used for describing the Dataset.
     */
    @JvmName("hkjtmonqpoyomqwi")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("tolhorxyrgfiotct")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the Dataset.
     */
    @JvmName("qgvmxilyljlvxyck")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value Dataset description.
     */
    @JvmName("iuwjaagbbeocqffe")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("vllpnmgytxuypdvg")
    public suspend fun folder(`value`: Output<DatasetFolderArgs>) {
        this.folder = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("jvpvsmoyemsqmiyf")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value The pagination rules to compose next page requests.
     */
    @JvmName("qyxacwaexbphjlcx")
    public suspend fun paginationRules(`value`: Output<Map<String, Any>>) {
        this.paginationRules = value
    }

    /**
     * @param value Parameters for dataset.
     */
    @JvmName("fltuoxvnshehiauq")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The relative URL to the resource that the RESTful API provides. Type: string (or Expression with resultType string).
     */
    @JvmName("ohommncsfjvewqkn")
    public suspend fun relativeUrl(`value`: Output<Any>) {
        this.relativeUrl = value
    }

    /**
     * @param value The HTTP request body to the RESTful API if requestMethod is POST. Type: string (or Expression with resultType string).
     */
    @JvmName("mijxmuofmamkmhcu")
    public suspend fun requestBody(`value`: Output<Any>) {
        this.requestBody = value
    }

    /**
     * @param value The HTTP method used to call the RESTful API. The default is GET. Type: string (or Expression with resultType string).
     */
    @JvmName("jdpyitsmgmjpcsve")
    public suspend fun requestMethod(`value`: Output<Any>) {
        this.requestMethod = value
    }

    /**
     * @param value Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
     */
    @JvmName("nrsiqswvpdjyadqd")
    public suspend fun schema(`value`: Output<Any>) {
        this.schema = value
    }

    /**
     * @param value Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
     */
    @JvmName("isjyjdxbkjvbtxbg")
    public suspend fun structure(`value`: Output<Any>) {
        this.structure = value
    }

    /**
     * @param value Type of dataset.
     * Expected value is 'RestResource'.
     */
    @JvmName("hpfblgonkvnwawpc")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The additional HTTP headers in the request to the RESTful API.
     */
    @JvmName("ramwvcbttexopwsg")
    public suspend fun additionalHeaders(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalHeaders = mapped
    }

    /**
     * @param values The additional HTTP headers in the request to the RESTful API.
     */
    @JvmName("hvutpukbrjpjhcpf")
    public fun additionalHeaders(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalHeaders = mapped
    }

    /**
     * @param value List of tags that can be used for describing the Dataset.
     */
    @JvmName("jmeyejpffqmtbqxo")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the Dataset.
     */
    @JvmName("ybsmmylkrbblxkud")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Dataset description.
     */
    @JvmName("yhetcfbgdhevpdvk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("hhusaelkegwtichs")
    public suspend fun folder(`value`: DatasetFolderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folder = mapped
    }

    /**
     * @param argument The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("oivmbbkddqvptchn")
    public suspend fun folder(argument: suspend DatasetFolderArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetFolderArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.folder = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("fskpmdisnkuknqov")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("vkywocyrwwyxstxi")
    public suspend
    fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value The pagination rules to compose next page requests.
     */
    @JvmName("qtxjwfsgiawcoudo")
    public suspend fun paginationRules(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paginationRules = mapped
    }

    /**
     * @param values The pagination rules to compose next page requests.
     */
    @JvmName("yatohmorbogmemcx")
    public fun paginationRules(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.paginationRules = mapped
    }

    /**
     * @param value Parameters for dataset.
     */
    @JvmName("oqogbwhadjddpbds")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for dataset.
     */
    @JvmName("bjdluotveebxkqen")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for dataset.
     */
    @JvmName("dqgrgbxocfghxlqs")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The relative URL to the resource that the RESTful API provides. Type: string (or Expression with resultType string).
     */
    @JvmName("lsanxtntdqjnjaot")
    public suspend fun relativeUrl(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relativeUrl = mapped
    }

    /**
     * @param value The HTTP request body to the RESTful API if requestMethod is POST. Type: string (or Expression with resultType string).
     */
    @JvmName("ogqcnnweuxlrjvvv")
    public suspend fun requestBody(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestBody = mapped
    }

    /**
     * @param value The HTTP method used to call the RESTful API. The default is GET. Type: string (or Expression with resultType string).
     */
    @JvmName("wrtwrqsgkqxygqiu")
    public suspend fun requestMethod(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestMethod = mapped
    }

    /**
     * @param value Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
     */
    @JvmName("otmsjwbmxqeusnjd")
    public suspend fun schema(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param value Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
     */
    @JvmName("bqpaacdxenwpjefq")
    public suspend fun structure(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.structure = mapped
    }

    /**
     * @param value Type of dataset.
     * Expected value is 'RestResource'.
     */
    @JvmName("lxxwbdjteejrbupg")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): RestResourceDatasetArgs = RestResourceDatasetArgs(
        additionalHeaders = additionalHeaders,
        annotations = annotations,
        description = description,
        folder = folder,
        linkedServiceName = linkedServiceName ?: throw PulumiNullFieldException("linkedServiceName"),
        paginationRules = paginationRules,
        parameters = parameters,
        relativeUrl = relativeUrl,
        requestBody = requestBody,
        requestMethod = requestMethod,
        schema = schema,
        structure = structure,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
