@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.RestSinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A copy activity Rest service Sink.
 * @property additionalHeaders The additional HTTP headers in the request to the RESTful API. Type: key value pairs (value should be string type).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property httpCompressionType Http Compression Type to Send data in compressed format with Optimal Compression Level, Default is None. And The Only Supported option is Gzip. Type: string (or Expression with resultType string).
 * @property httpRequestTimeout The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data. Default value: 00:01:40. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property maxConcurrentConnections The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
 * @property requestInterval The time to await before sending next request, in milliseconds
 * @property requestMethod The HTTP method used to call the RESTful API. The default is POST. Type: string (or Expression with resultType string).
 * @property sinkRetryCount Sink retry count. Type: integer (or Expression with resultType integer).
 * @property sinkRetryWait Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy sink type.
 * Expected value is 'RestSink'.
 * @property writeBatchSize Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property writeBatchTimeout Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 */
public data class RestSinkArgs(
    public val additionalHeaders: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val httpCompressionType: Output<Any>? = null,
    public val httpRequestTimeout: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val requestInterval: Output<Any>? = null,
    public val requestMethod: Output<Any>? = null,
    public val sinkRetryCount: Output<Any>? = null,
    public val sinkRetryWait: Output<Any>? = null,
    public val type: Output<String>,
    public val writeBatchSize: Output<Any>? = null,
    public val writeBatchTimeout: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.RestSinkArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.RestSinkArgs =
        com.pulumi.azurenative.datafactory.inputs.RestSinkArgs.builder()
            .additionalHeaders(additionalHeaders?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .httpCompressionType(httpCompressionType?.applyValue({ args0 -> args0 }))
            .httpRequestTimeout(httpRequestTimeout?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .requestInterval(requestInterval?.applyValue({ args0 -> args0 }))
            .requestMethod(requestMethod?.applyValue({ args0 -> args0 }))
            .sinkRetryCount(sinkRetryCount?.applyValue({ args0 -> args0 }))
            .sinkRetryWait(sinkRetryWait?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .writeBatchSize(writeBatchSize?.applyValue({ args0 -> args0 }))
            .writeBatchTimeout(writeBatchTimeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RestSinkArgs].
 */
@PulumiTagMarker
public class RestSinkArgsBuilder internal constructor() {
    private var additionalHeaders: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var httpCompressionType: Output<Any>? = null

    private var httpRequestTimeout: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var requestInterval: Output<Any>? = null

    private var requestMethod: Output<Any>? = null

    private var sinkRetryCount: Output<Any>? = null

    private var sinkRetryWait: Output<Any>? = null

    private var type: Output<String>? = null

    private var writeBatchSize: Output<Any>? = null

    private var writeBatchTimeout: Output<Any>? = null

    /**
     * @param value The additional HTTP headers in the request to the RESTful API. Type: key value pairs (value should be string type).
     */
    @JvmName("eewpsetpwytkhfen")
    public suspend fun additionalHeaders(`value`: Output<Any>) {
        this.additionalHeaders = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("lrfytfvheyafgsvi")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value Http Compression Type to Send data in compressed format with Optimal Compression Level, Default is None. And The Only Supported option is Gzip. Type: string (or Expression with resultType string).
     */
    @JvmName("fucecdkcgcxslfqp")
    public suspend fun httpCompressionType(`value`: Output<Any>) {
        this.httpCompressionType = value
    }

    /**
     * @param value The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data. Default value: 00:01:40. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("teauvvhhwgntpcxf")
    public suspend fun httpRequestTimeout(`value`: Output<Any>) {
        this.httpRequestTimeout = value
    }

    /**
     * @param value The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("vbhegafcckyeesdb")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value The time to await before sending next request, in milliseconds
     */
    @JvmName("kommxxsodrhcnccj")
    public suspend fun requestInterval(`value`: Output<Any>) {
        this.requestInterval = value
    }

    /**
     * @param value The HTTP method used to call the RESTful API. The default is POST. Type: string (or Expression with resultType string).
     */
    @JvmName("xvdnrpdnbcxmlkoq")
    public suspend fun requestMethod(`value`: Output<Any>) {
        this.requestMethod = value
    }

    /**
     * @param value Sink retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("ahlmiuogsgpcnpsh")
    public suspend fun sinkRetryCount(`value`: Output<Any>) {
        this.sinkRetryCount = value
    }

    /**
     * @param value Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("dviqmwqwvmlomnpc")
    public suspend fun sinkRetryWait(`value`: Output<Any>) {
        this.sinkRetryWait = value
    }

    /**
     * @param value Copy sink type.
     * Expected value is 'RestSink'.
     */
    @JvmName("momcxngkxavliqyo")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("hhsaekjiancumfxg")
    public suspend fun writeBatchSize(`value`: Output<Any>) {
        this.writeBatchSize = value
    }

    /**
     * @param value Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("gpwrnuegycjakdrh")
    public suspend fun writeBatchTimeout(`value`: Output<Any>) {
        this.writeBatchTimeout = value
    }

    /**
     * @param value The additional HTTP headers in the request to the RESTful API. Type: key value pairs (value should be string type).
     */
    @JvmName("ewfknykjnxxtjdbo")
    public suspend fun additionalHeaders(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalHeaders = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("mrywqrpvssmkiqsr")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value Http Compression Type to Send data in compressed format with Optimal Compression Level, Default is None. And The Only Supported option is Gzip. Type: string (or Expression with resultType string).
     */
    @JvmName("xptfejfehjspdccv")
    public suspend fun httpCompressionType(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpCompressionType = mapped
    }

    /**
     * @param value The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data. Default value: 00:01:40. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("oblgisqissvxvcef")
    public suspend fun httpRequestTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpRequestTimeout = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("yfcqsoqpmvjwtkdd")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value The time to await before sending next request, in milliseconds
     */
    @JvmName("bjldocdyuxsjxyte")
    public suspend fun requestInterval(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestInterval = mapped
    }

    /**
     * @param value The HTTP method used to call the RESTful API. The default is POST. Type: string (or Expression with resultType string).
     */
    @JvmName("vsjxdvgdgiaedgor")
    public suspend fun requestMethod(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestMethod = mapped
    }

    /**
     * @param value Sink retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("xsnevaqjcarmxcet")
    public suspend fun sinkRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkRetryCount = mapped
    }

    /**
     * @param value Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("wroupgyuvcoxotpq")
    public suspend fun sinkRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkRetryWait = mapped
    }

    /**
     * @param value Copy sink type.
     * Expected value is 'RestSink'.
     */
    @JvmName("danevchhicqqpstb")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("dycayimsplfiyxnk")
    public suspend fun writeBatchSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBatchSize = mapped
    }

    /**
     * @param value Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("ttxsegicjevgwsdm")
    public suspend fun writeBatchTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBatchTimeout = mapped
    }

    internal fun build(): RestSinkArgs = RestSinkArgs(
        additionalHeaders = additionalHeaders,
        disableMetricsCollection = disableMetricsCollection,
        httpCompressionType = httpCompressionType,
        httpRequestTimeout = httpRequestTimeout,
        maxConcurrentConnections = maxConcurrentConnections,
        requestInterval = requestInterval,
        requestMethod = requestMethod,
        sinkRetryCount = sinkRetryCount,
        sinkRetryWait = sinkRetryWait,
        type = type ?: throw PulumiNullFieldException("type"),
        writeBatchSize = writeBatchSize,
        writeBatchTimeout = writeBatchTimeout,
    )
}
