@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SSISAccessCredentialArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SSIS access credential.
 * @property domain Domain for windows authentication. Type: string (or Expression with resultType string).
 * @property password Password for windows authentication.
 * @property userName UseName for windows authentication. Type: string (or Expression with resultType string).
 */
public data class SSISAccessCredentialArgs(
    public val domain: Output<Any>,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>,
    public val userName: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SSISAccessCredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SSISAccessCredentialArgs =
        com.pulumi.azurenative.datafactory.inputs.SSISAccessCredentialArgs.builder()
            .domain(domain.applyValue({ args0 -> args0 }))
            .password(
                password.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .userName(userName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SSISAccessCredentialArgs].
 */
@PulumiTagMarker
public class SSISAccessCredentialArgsBuilder internal constructor() {
    private var domain: Output<Any>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var userName: Output<Any>? = null

    /**
     * @param value Domain for windows authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("msbxwvdxemruiqsi")
    public suspend fun domain(`value`: Output<Any>) {
        this.domain = value
    }

    /**
     * @param value Password for windows authentication.
     */
    @JvmName("qomgcwdlatbscrhl")
    public suspend
    fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value UseName for windows authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("ioqmopeiujvqbobt")
    public suspend fun userName(`value`: Output<Any>) {
        this.userName = value
    }

    /**
     * @param value Domain for windows authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("rsgtgwvkrkyhgxac")
    public suspend fun domain(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value Password for windows authentication.
     */
    @JvmName("xpkgryjiyqmlyfwk")
    public suspend fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password for windows authentication.
     */
    @JvmName("tlbxjhrwnscqsuwt")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password for windows authentication.
     */
    @JvmName("gshnjfnudqetwqnk")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value UseName for windows authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("rjbjnlnawvubgukh")
    public suspend fun userName(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): SSISAccessCredentialArgs = SSISAccessCredentialArgs(
        domain = domain ?: throw PulumiNullFieldException("domain"),
        password = password ?: throw PulumiNullFieldException("password"),
        userName = userName ?: throw PulumiNullFieldException("userName"),
    )
}
