@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SSISLogLocationArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.SsisLogLocationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * SSIS package execution log location
 * @property accessCredential The package execution log access credential.
 * @property logPath The SSIS package execution log path. Type: string (or Expression with resultType string).
 * @property logRefreshInterval Specifies the interval to refresh log. The default interval is 5 minutes. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type The type of SSIS log location.
 */
public data class SSISLogLocationArgs(
    public val accessCredential: Output<SSISAccessCredentialArgs>? = null,
    public val logPath: Output<Any>,
    public val logRefreshInterval: Output<Any>? = null,
    public val type: Output<Either<String, SsisLogLocationType>>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SSISLogLocationArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SSISLogLocationArgs =
        com.pulumi.azurenative.datafactory.inputs.SSISLogLocationArgs.builder()
            .accessCredential(accessCredential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .logPath(logPath.applyValue({ args0 -> args0 }))
            .logRefreshInterval(logRefreshInterval?.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SSISLogLocationArgs].
 */
@PulumiTagMarker
public class SSISLogLocationArgsBuilder internal constructor() {
    private var accessCredential: Output<SSISAccessCredentialArgs>? = null

    private var logPath: Output<Any>? = null

    private var logRefreshInterval: Output<Any>? = null

    private var type: Output<Either<String, SsisLogLocationType>>? = null

    /**
     * @param value The package execution log access credential.
     */
    @JvmName("qypopexrygpvgwqv")
    public suspend fun accessCredential(`value`: Output<SSISAccessCredentialArgs>) {
        this.accessCredential = value
    }

    /**
     * @param value The SSIS package execution log path. Type: string (or Expression with resultType string).
     */
    @JvmName("iohnttteqvrckrpx")
    public suspend fun logPath(`value`: Output<Any>) {
        this.logPath = value
    }

    /**
     * @param value Specifies the interval to refresh log. The default interval is 5 minutes. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("fhtvhujrctxmlsil")
    public suspend fun logRefreshInterval(`value`: Output<Any>) {
        this.logRefreshInterval = value
    }

    /**
     * @param value The type of SSIS log location.
     */
    @JvmName("vatuhilxgqpiwpkg")
    public suspend fun type(`value`: Output<Either<String, SsisLogLocationType>>) {
        this.type = value
    }

    /**
     * @param value The package execution log access credential.
     */
    @JvmName("ewicyvyjjhigfyoi")
    public suspend fun accessCredential(`value`: SSISAccessCredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessCredential = mapped
    }

    /**
     * @param argument The package execution log access credential.
     */
    @JvmName("nemnyiojovldsnhq")
    public suspend
    fun accessCredential(argument: suspend SSISAccessCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = SSISAccessCredentialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accessCredential = mapped
    }

    /**
     * @param value The SSIS package execution log path. Type: string (or Expression with resultType string).
     */
    @JvmName("oyjcgxcoshhhmgbf")
    public suspend fun logPath(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logPath = mapped
    }

    /**
     * @param value Specifies the interval to refresh log. The default interval is 5 minutes. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("yytgolvdxdoadhjr")
    public suspend fun logRefreshInterval(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logRefreshInterval = mapped
    }

    /**
     * @param value The type of SSIS log location.
     */
    @JvmName("bycyiodqxldimqmy")
    public suspend fun type(`value`: Either<String, SsisLogLocationType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of SSIS log location.
     */
    @JvmName("dgkhkjguamnqlfal")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SsisLogLocationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of SSIS log location.
     */
    @JvmName("pyeoflvmceapmdyx")
    public fun type(`value`: SsisLogLocationType) {
        val toBeMapped = Either.ofRight<String, SsisLogLocationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SSISLogLocationArgs = SSISLogLocationArgs(
        accessCredential = accessCredential,
        logPath = logPath ?: throw PulumiNullFieldException("logPath"),
        logRefreshInterval = logRefreshInterval,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
