@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SalesforceServiceCloudSinkArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.SalesforceSinkWriteBehavior
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A copy activity Salesforce Service Cloud sink.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property externalIdFieldName The name of the external ID field for upsert operation. Default value is 'Id' column. Type: string (or Expression with resultType string).
 * @property ignoreNullValues The flag indicating whether or not to ignore null values from input dataset (except key fields) during write operation. Default value is false. If set it to true, it means ADF will leave the data in the destination object unchanged when doing upsert/update operation and insert defined default value when doing insert operation, versus ADF will update the data in the destination object to NULL when doing upsert/update operation and insert NULL value when doing insert operation. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
 * @property sinkRetryCount Sink retry count. Type: integer (or Expression with resultType integer).
 * @property sinkRetryWait Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy sink type.
 * Expected value is 'SalesforceServiceCloudSink'.
 * @property writeBatchSize Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property writeBatchTimeout Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property writeBehavior The write behavior for the operation. Default is Insert.
 */
public data class SalesforceServiceCloudSinkArgs(
    public val disableMetricsCollection: Output<Any>? = null,
    public val externalIdFieldName: Output<Any>? = null,
    public val ignoreNullValues: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val sinkRetryCount: Output<Any>? = null,
    public val sinkRetryWait: Output<Any>? = null,
    public val type: Output<String>,
    public val writeBatchSize: Output<Any>? = null,
    public val writeBatchTimeout: Output<Any>? = null,
    public val writeBehavior: Output<Either<String, SalesforceSinkWriteBehavior>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SalesforceServiceCloudSinkArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SalesforceServiceCloudSinkArgs =
        com.pulumi.azurenative.datafactory.inputs.SalesforceServiceCloudSinkArgs.builder()
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .externalIdFieldName(externalIdFieldName?.applyValue({ args0 -> args0 }))
            .ignoreNullValues(ignoreNullValues?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .sinkRetryCount(sinkRetryCount?.applyValue({ args0 -> args0 }))
            .sinkRetryWait(sinkRetryWait?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .writeBatchSize(writeBatchSize?.applyValue({ args0 -> args0 }))
            .writeBatchTimeout(writeBatchTimeout?.applyValue({ args0 -> args0 }))
            .writeBehavior(
                writeBehavior?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SalesforceServiceCloudSinkArgs].
 */
@PulumiTagMarker
public class SalesforceServiceCloudSinkArgsBuilder internal constructor() {
    private var disableMetricsCollection: Output<Any>? = null

    private var externalIdFieldName: Output<Any>? = null

    private var ignoreNullValues: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var sinkRetryCount: Output<Any>? = null

    private var sinkRetryWait: Output<Any>? = null

    private var type: Output<String>? = null

    private var writeBatchSize: Output<Any>? = null

    private var writeBatchTimeout: Output<Any>? = null

    private var writeBehavior: Output<Either<String, SalesforceSinkWriteBehavior>>? = null

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("wifkaiaeqhbdcwxb")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value The name of the external ID field for upsert operation. Default value is 'Id' column. Type: string (or Expression with resultType string).
     */
    @JvmName("uysdfcpbdiaumogd")
    public suspend fun externalIdFieldName(`value`: Output<Any>) {
        this.externalIdFieldName = value
    }

    /**
     * @param value The flag indicating whether or not to ignore null values from input dataset (except key fields) during write operation. Default value is false. If set it to true, it means ADF will leave the data in the destination object unchanged when doing upsert/update operation and insert defined default value when doing insert operation, versus ADF will update the data in the destination object to NULL when doing upsert/update operation and insert NULL value when doing insert operation. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("stoyosyaxmntlpee")
    public suspend fun ignoreNullValues(`value`: Output<Any>) {
        this.ignoreNullValues = value
    }

    /**
     * @param value The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("eabsatoeyqggxgbr")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value Sink retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("mjhqaeaevegssbed")
    public suspend fun sinkRetryCount(`value`: Output<Any>) {
        this.sinkRetryCount = value
    }

    /**
     * @param value Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("leadeyioavcmodcp")
    public suspend fun sinkRetryWait(`value`: Output<Any>) {
        this.sinkRetryWait = value
    }

    /**
     * @param value Copy sink type.
     * Expected value is 'SalesforceServiceCloudSink'.
     */
    @JvmName("eyvyaurmklrdsplq")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("vivuykgyarmghrwp")
    public suspend fun writeBatchSize(`value`: Output<Any>) {
        this.writeBatchSize = value
    }

    /**
     * @param value Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("amibxyoccoswxilt")
    public suspend fun writeBatchTimeout(`value`: Output<Any>) {
        this.writeBatchTimeout = value
    }

    /**
     * @param value The write behavior for the operation. Default is Insert.
     */
    @JvmName("akumsjccwlhdxqbf")
    public suspend fun writeBehavior(`value`: Output<Either<String, SalesforceSinkWriteBehavior>>) {
        this.writeBehavior = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("tgkvpddquydnxvoc")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value The name of the external ID field for upsert operation. Default value is 'Id' column. Type: string (or Expression with resultType string).
     */
    @JvmName("aapqlupptijvpxnw")
    public suspend fun externalIdFieldName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalIdFieldName = mapped
    }

    /**
     * @param value The flag indicating whether or not to ignore null values from input dataset (except key fields) during write operation. Default value is false. If set it to true, it means ADF will leave the data in the destination object unchanged when doing upsert/update operation and insert defined default value when doing insert operation, versus ADF will update the data in the destination object to NULL when doing upsert/update operation and insert NULL value when doing insert operation. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("aptgxisuekpdmefy")
    public suspend fun ignoreNullValues(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreNullValues = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("bsemtwtmmlloytjp")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value Sink retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("ukuaspibucoxvqoi")
    public suspend fun sinkRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkRetryCount = mapped
    }

    /**
     * @param value Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("iemkijfsjpaiodww")
    public suspend fun sinkRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkRetryWait = mapped
    }

    /**
     * @param value Copy sink type.
     * Expected value is 'SalesforceServiceCloudSink'.
     */
    @JvmName("xvagotjqkesgfyjs")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("uscohukycdhupcqh")
    public suspend fun writeBatchSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBatchSize = mapped
    }

    /**
     * @param value Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("hprokvesdmyrskxj")
    public suspend fun writeBatchTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBatchTimeout = mapped
    }

    /**
     * @param value The write behavior for the operation. Default is Insert.
     */
    @JvmName("eenvwrbsqbtaydtk")
    public suspend fun writeBehavior(`value`: Either<String, SalesforceSinkWriteBehavior>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBehavior = mapped
    }

    /**
     * @param value The write behavior for the operation. Default is Insert.
     */
    @JvmName("bmhpwbmrbppsoktt")
    public fun writeBehavior(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SalesforceSinkWriteBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.writeBehavior = mapped
    }

    /**
     * @param value The write behavior for the operation. Default is Insert.
     */
    @JvmName("ixbmekyigaesfwep")
    public fun writeBehavior(`value`: SalesforceSinkWriteBehavior) {
        val toBeMapped = Either.ofRight<String, SalesforceSinkWriteBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.writeBehavior = mapped
    }

    internal fun build(): SalesforceServiceCloudSinkArgs = SalesforceServiceCloudSinkArgs(
        disableMetricsCollection = disableMetricsCollection,
        externalIdFieldName = externalIdFieldName,
        ignoreNullValues = ignoreNullValues,
        maxConcurrentConnections = maxConcurrentConnections,
        sinkRetryCount = sinkRetryCount,
        sinkRetryWait = sinkRetryWait,
        type = type ?: throw PulumiNullFieldException("type"),
        writeBatchSize = writeBatchSize,
        writeBatchTimeout = writeBatchTimeout,
        writeBehavior = writeBehavior,
    )
}
