@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SalesforceV2SinkArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.SalesforceV2SinkWriteBehavior
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A copy activity Salesforce V2 sink.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property externalIdFieldName The name of the external ID field for upsert operation. Default value is 'Id' column. Type: string (or Expression with resultType string).
 * @property ignoreNullValues The flag indicating whether or not to ignore null values from input dataset (except key fields) during write operation. Default value is false. If set it to true, it means ADF will leave the data in the destination object unchanged when doing upsert/update operation and insert defined default value when doing insert operation, versus ADF will update the data in the destination object to NULL when doing upsert/update operation and insert NULL value when doing insert operation. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
 * @property sinkRetryCount Sink retry count. Type: integer (or Expression with resultType integer).
 * @property sinkRetryWait Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy sink type.
 * Expected value is 'SalesforceV2Sink'.
 * @property writeBatchSize Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property writeBatchTimeout Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property writeBehavior The write behavior for the operation. Default is Insert.
 */
public data class SalesforceV2SinkArgs(
    public val disableMetricsCollection: Output<Any>? = null,
    public val externalIdFieldName: Output<Any>? = null,
    public val ignoreNullValues: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val sinkRetryCount: Output<Any>? = null,
    public val sinkRetryWait: Output<Any>? = null,
    public val type: Output<String>,
    public val writeBatchSize: Output<Any>? = null,
    public val writeBatchTimeout: Output<Any>? = null,
    public val writeBehavior: Output<Either<String, SalesforceV2SinkWriteBehavior>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SalesforceV2SinkArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SalesforceV2SinkArgs =
        com.pulumi.azurenative.datafactory.inputs.SalesforceV2SinkArgs.builder()
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .externalIdFieldName(externalIdFieldName?.applyValue({ args0 -> args0 }))
            .ignoreNullValues(ignoreNullValues?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .sinkRetryCount(sinkRetryCount?.applyValue({ args0 -> args0 }))
            .sinkRetryWait(sinkRetryWait?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .writeBatchSize(writeBatchSize?.applyValue({ args0 -> args0 }))
            .writeBatchTimeout(writeBatchTimeout?.applyValue({ args0 -> args0 }))
            .writeBehavior(
                writeBehavior?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SalesforceV2SinkArgs].
 */
@PulumiTagMarker
public class SalesforceV2SinkArgsBuilder internal constructor() {
    private var disableMetricsCollection: Output<Any>? = null

    private var externalIdFieldName: Output<Any>? = null

    private var ignoreNullValues: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var sinkRetryCount: Output<Any>? = null

    private var sinkRetryWait: Output<Any>? = null

    private var type: Output<String>? = null

    private var writeBatchSize: Output<Any>? = null

    private var writeBatchTimeout: Output<Any>? = null

    private var writeBehavior: Output<Either<String, SalesforceV2SinkWriteBehavior>>? = null

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("bnlqysgogcagafmi")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value The name of the external ID field for upsert operation. Default value is 'Id' column. Type: string (or Expression with resultType string).
     */
    @JvmName("bhicddvuljgdnnmn")
    public suspend fun externalIdFieldName(`value`: Output<Any>) {
        this.externalIdFieldName = value
    }

    /**
     * @param value The flag indicating whether or not to ignore null values from input dataset (except key fields) during write operation. Default value is false. If set it to true, it means ADF will leave the data in the destination object unchanged when doing upsert/update operation and insert defined default value when doing insert operation, versus ADF will update the data in the destination object to NULL when doing upsert/update operation and insert NULL value when doing insert operation. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("vruiiveewkoknwii")
    public suspend fun ignoreNullValues(`value`: Output<Any>) {
        this.ignoreNullValues = value
    }

    /**
     * @param value The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("gqqkhrhtsrsktwly")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value Sink retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("brosahwnbhgdrtca")
    public suspend fun sinkRetryCount(`value`: Output<Any>) {
        this.sinkRetryCount = value
    }

    /**
     * @param value Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("ipaqweyrfmcjkdhk")
    public suspend fun sinkRetryWait(`value`: Output<Any>) {
        this.sinkRetryWait = value
    }

    /**
     * @param value Copy sink type.
     * Expected value is 'SalesforceV2Sink'.
     */
    @JvmName("lbnqwexlbtvmxwda")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("rltjfuupeyudfhbj")
    public suspend fun writeBatchSize(`value`: Output<Any>) {
        this.writeBatchSize = value
    }

    /**
     * @param value Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("uqsupcjwbxprrwns")
    public suspend fun writeBatchTimeout(`value`: Output<Any>) {
        this.writeBatchTimeout = value
    }

    /**
     * @param value The write behavior for the operation. Default is Insert.
     */
    @JvmName("dicdpyublbfgccgk")
    public suspend fun writeBehavior(`value`: Output<Either<String, SalesforceV2SinkWriteBehavior>>) {
        this.writeBehavior = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("dvnfvypqukkuofvw")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value The name of the external ID field for upsert operation. Default value is 'Id' column. Type: string (or Expression with resultType string).
     */
    @JvmName("pmqdrqrvsyfaaiva")
    public suspend fun externalIdFieldName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalIdFieldName = mapped
    }

    /**
     * @param value The flag indicating whether or not to ignore null values from input dataset (except key fields) during write operation. Default value is false. If set it to true, it means ADF will leave the data in the destination object unchanged when doing upsert/update operation and insert defined default value when doing insert operation, versus ADF will update the data in the destination object to NULL when doing upsert/update operation and insert NULL value when doing insert operation. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("nkwcvvurfqswaylq")
    public suspend fun ignoreNullValues(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreNullValues = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("kmseuirdbdwniimd")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value Sink retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("fdjookwqpqulrtsr")
    public suspend fun sinkRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkRetryCount = mapped
    }

    /**
     * @param value Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("kssbuvfuhgxxodjn")
    public suspend fun sinkRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkRetryWait = mapped
    }

    /**
     * @param value Copy sink type.
     * Expected value is 'SalesforceV2Sink'.
     */
    @JvmName("dftcsvjynetncksj")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("bswivicqqhktqgve")
    public suspend fun writeBatchSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBatchSize = mapped
    }

    /**
     * @param value Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("ntrukunokrbqgdqx")
    public suspend fun writeBatchTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBatchTimeout = mapped
    }

    /**
     * @param value The write behavior for the operation. Default is Insert.
     */
    @JvmName("efmcyfeiktjsnnxx")
    public suspend fun writeBehavior(`value`: Either<String, SalesforceV2SinkWriteBehavior>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBehavior = mapped
    }

    /**
     * @param value The write behavior for the operation. Default is Insert.
     */
    @JvmName("ajtndmcljkhdacer")
    public fun writeBehavior(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SalesforceV2SinkWriteBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.writeBehavior = mapped
    }

    /**
     * @param value The write behavior for the operation. Default is Insert.
     */
    @JvmName("cemsvpwcstjvbyem")
    public fun writeBehavior(`value`: SalesforceV2SinkWriteBehavior) {
        val toBeMapped = Either.ofRight<String, SalesforceV2SinkWriteBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.writeBehavior = mapped
    }

    internal fun build(): SalesforceV2SinkArgs = SalesforceV2SinkArgs(
        disableMetricsCollection = disableMetricsCollection,
        externalIdFieldName = externalIdFieldName,
        ignoreNullValues = ignoreNullValues,
        maxConcurrentConnections = maxConcurrentConnections,
        sinkRetryCount = sinkRetryCount,
        sinkRetryWait = sinkRetryWait,
        type = type ?: throw PulumiNullFieldException("type"),
        writeBatchSize = writeBatchSize,
        writeBatchTimeout = writeBatchTimeout,
        writeBehavior = writeBehavior,
    )
}
