@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SapHanaPartitionSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The settings that will be leveraged for SAP HANA source partitioning.
 * @property partitionColumnName The name of the column that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
 */
public data class SapHanaPartitionSettingsArgs(
    public val partitionColumnName: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SapHanaPartitionSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SapHanaPartitionSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.SapHanaPartitionSettingsArgs.builder()
            .partitionColumnName(partitionColumnName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SapHanaPartitionSettingsArgs].
 */
@PulumiTagMarker
public class SapHanaPartitionSettingsArgsBuilder internal constructor() {
    private var partitionColumnName: Output<Any>? = null

    /**
     * @param value The name of the column that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("icxjhypxwvlcbtby")
    public suspend fun partitionColumnName(`value`: Output<Any>) {
        this.partitionColumnName = value
    }

    /**
     * @param value The name of the column that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("xcuobvlpgqtodgal")
    public suspend fun partitionColumnName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionColumnName = mapped
    }

    internal fun build(): SapHanaPartitionSettingsArgs = SapHanaPartitionSettingsArgs(
        partitionColumnName = partitionColumnName,
    )
}
