@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SapOdpLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * SAP ODP Linked Service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property clientId Client ID of the client on the SAP system where the table is located. (Usually a three-digit decimal number represented as a string) Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property language Language of the SAP system where the table is located. The default value is EN. Type: string (or Expression with resultType string).
 * @property logonGroup The Logon Group for the SAP System. Type: string (or Expression with resultType string).
 * @property messageServer The hostname of the SAP Message Server. Type: string (or Expression with resultType string).
 * @property messageServerService The service name or port number of the Message Server. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property password Password to access the SAP server where the table is located.
 * @property server Host name of the SAP instance where the table is located. Type: string (or Expression with resultType string).
 * @property sncLibraryPath External security product's library to access the SAP server where the table is located. Type: string (or Expression with resultType string).
 * @property sncMode SNC activation indicator to access the SAP server where the table is located. Must be either 0 (off) or 1 (on). Type: string (or Expression with resultType string).
 * @property sncMyName Initiator's SNC name to access the SAP server where the table is located. Type: string (or Expression with resultType string).
 * @property sncPartnerName Communication partner's SNC name to access the SAP server where the table is located. Type: string (or Expression with resultType string).
 * @property sncQop SNC Quality of Protection. Allowed value include: 1, 2, 3, 8, 9. Type: string (or Expression with resultType string).
 * @property subscriberName The subscriber name. Type: string (or Expression with resultType string).
 * @property systemId SystemID of the SAP system where the table is located. Type: string (or Expression with resultType string).
 * @property systemNumber System number of the SAP system where the table is located. (Usually a two-digit decimal number represented as a string.) Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'SapOdp'.
 * @property userName Username to access the SAP server where the table is located. Type: string (or Expression with resultType string).
 * @property x509CertificatePath SNC X509 certificate file path. Type: string (or Expression with resultType string).
 */
public data class SapOdpLinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val clientId: Output<Any>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val language: Output<Any>? = null,
    public val logonGroup: Output<Any>? = null,
    public val messageServer: Output<Any>? = null,
    public val messageServerService: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val server: Output<Any>? = null,
    public val sncLibraryPath: Output<Any>? = null,
    public val sncMode: Output<Any>? = null,
    public val sncMyName: Output<Any>? = null,
    public val sncPartnerName: Output<Any>? = null,
    public val sncQop: Output<Any>? = null,
    public val subscriberName: Output<Any>? = null,
    public val systemId: Output<Any>? = null,
    public val systemNumber: Output<Any>? = null,
    public val type: Output<String>,
    public val userName: Output<Any>? = null,
    public val x509CertificatePath: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SapOdpLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SapOdpLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.SapOdpLinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .language(language?.applyValue({ args0 -> args0 }))
            .logonGroup(logonGroup?.applyValue({ args0 -> args0 }))
            .messageServer(messageServer?.applyValue({ args0 -> args0 }))
            .messageServerService(messageServerService?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(
                password?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .server(server?.applyValue({ args0 -> args0 }))
            .sncLibraryPath(sncLibraryPath?.applyValue({ args0 -> args0 }))
            .sncMode(sncMode?.applyValue({ args0 -> args0 }))
            .sncMyName(sncMyName?.applyValue({ args0 -> args0 }))
            .sncPartnerName(sncPartnerName?.applyValue({ args0 -> args0 }))
            .sncQop(sncQop?.applyValue({ args0 -> args0 }))
            .subscriberName(subscriberName?.applyValue({ args0 -> args0 }))
            .systemId(systemId?.applyValue({ args0 -> args0 }))
            .systemNumber(systemNumber?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 }))
            .x509CertificatePath(x509CertificatePath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SapOdpLinkedServiceArgs].
 */
@PulumiTagMarker
public class SapOdpLinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var clientId: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var language: Output<Any>? = null

    private var logonGroup: Output<Any>? = null

    private var messageServer: Output<Any>? = null

    private var messageServerService: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var server: Output<Any>? = null

    private var sncLibraryPath: Output<Any>? = null

    private var sncMode: Output<Any>? = null

    private var sncMyName: Output<Any>? = null

    private var sncPartnerName: Output<Any>? = null

    private var sncQop: Output<Any>? = null

    private var subscriberName: Output<Any>? = null

    private var systemId: Output<Any>? = null

    private var systemNumber: Output<Any>? = null

    private var type: Output<String>? = null

    private var userName: Output<Any>? = null

    private var x509CertificatePath: Output<Any>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("epwymhicjgjvgrdb")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("wekfsywhcmufiyba")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("vimfqhassidlubmi")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value Client ID of the client on the SAP system where the table is located. (Usually a three-digit decimal number represented as a string) Type: string (or Expression with resultType string).
     */
    @JvmName("fssxknxpftnaiktq")
    public suspend fun clientId(`value`: Output<Any>) {
        this.clientId = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("hvttcpgncjdcafbp")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("cvesclcvkkygstev")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("ifcanxsearaogubv")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value Language of the SAP system where the table is located. The default value is EN. Type: string (or Expression with resultType string).
     */
    @JvmName("rncjbmncvctulthy")
    public suspend fun language(`value`: Output<Any>) {
        this.language = value
    }

    /**
     * @param value The Logon Group for the SAP System. Type: string (or Expression with resultType string).
     */
    @JvmName("oplnpsoktnavostd")
    public suspend fun logonGroup(`value`: Output<Any>) {
        this.logonGroup = value
    }

    /**
     * @param value The hostname of the SAP Message Server. Type: string (or Expression with resultType string).
     */
    @JvmName("qlxlqkcnhhcnekws")
    public suspend fun messageServer(`value`: Output<Any>) {
        this.messageServer = value
    }

    /**
     * @param value The service name or port number of the Message Server. Type: string (or Expression with resultType string).
     */
    @JvmName("skrijufvmiejsdpc")
    public suspend fun messageServerService(`value`: Output<Any>) {
        this.messageServerService = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("bdbsltbesptrdkng")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Password to access the SAP server where the table is located.
     */
    @JvmName("gdximuobptnuubqm")
    public suspend
    fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value Host name of the SAP instance where the table is located. Type: string (or Expression with resultType string).
     */
    @JvmName("brsjihnbwrkpjrrv")
    public suspend fun server(`value`: Output<Any>) {
        this.server = value
    }

    /**
     * @param value External security product's library to access the SAP server where the table is located. Type: string (or Expression with resultType string).
     */
    @JvmName("cmgsyhupxwdbjprf")
    public suspend fun sncLibraryPath(`value`: Output<Any>) {
        this.sncLibraryPath = value
    }

    /**
     * @param value SNC activation indicator to access the SAP server where the table is located. Must be either 0 (off) or 1 (on). Type: string (or Expression with resultType string).
     */
    @JvmName("tglbfcjevaqwpdkq")
    public suspend fun sncMode(`value`: Output<Any>) {
        this.sncMode = value
    }

    /**
     * @param value Initiator's SNC name to access the SAP server where the table is located. Type: string (or Expression with resultType string).
     */
    @JvmName("dxweuwxhatqpdnhe")
    public suspend fun sncMyName(`value`: Output<Any>) {
        this.sncMyName = value
    }

    /**
     * @param value Communication partner's SNC name to access the SAP server where the table is located. Type: string (or Expression with resultType string).
     */
    @JvmName("wkmfwoqnrotoowfd")
    public suspend fun sncPartnerName(`value`: Output<Any>) {
        this.sncPartnerName = value
    }

    /**
     * @param value SNC Quality of Protection. Allowed value include: 1, 2, 3, 8, 9. Type: string (or Expression with resultType string).
     */
    @JvmName("yerkurwtwnydbmmm")
    public suspend fun sncQop(`value`: Output<Any>) {
        this.sncQop = value
    }

    /**
     * @param value The subscriber name. Type: string (or Expression with resultType string).
     */
    @JvmName("cnmspegemlpxbhmy")
    public suspend fun subscriberName(`value`: Output<Any>) {
        this.subscriberName = value
    }

    /**
     * @param value SystemID of the SAP system where the table is located. Type: string (or Expression with resultType string).
     */
    @JvmName("umdumonjnobvcrop")
    public suspend fun systemId(`value`: Output<Any>) {
        this.systemId = value
    }

    /**
     * @param value System number of the SAP system where the table is located. (Usually a two-digit decimal number represented as a string.) Type: string (or Expression with resultType string).
     */
    @JvmName("wbvujgvwyygfxelf")
    public suspend fun systemNumber(`value`: Output<Any>) {
        this.systemNumber = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'SapOdp'.
     */
    @JvmName("nqmmwhakeqjrywbv")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Username to access the SAP server where the table is located. Type: string (or Expression with resultType string).
     */
    @JvmName("khgopvfouernjwyi")
    public suspend fun userName(`value`: Output<Any>) {
        this.userName = value
    }

    /**
     * @param value SNC X509 certificate file path. Type: string (or Expression with resultType string).
     */
    @JvmName("fhleplavtachluwy")
    public suspend fun x509CertificatePath(`value`: Output<Any>) {
        this.x509CertificatePath = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("rukcvqgijdlrjkpa")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("itdcytyiqfbvmdyq")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Client ID of the client on the SAP system where the table is located. (Usually a three-digit decimal number represented as a string) Type: string (or Expression with resultType string).
     */
    @JvmName("tmgqwlmlaolworeg")
    public suspend fun clientId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("mjkvmhvyepogedjv")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("dwrbrxkbrqbvlvax")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("fofbwbfdaygmnrqi")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("pnjywmhhhwptquer")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value Language of the SAP system where the table is located. The default value is EN. Type: string (or Expression with resultType string).
     */
    @JvmName("mhiblfnbaylmlprs")
    public suspend fun language(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.language = mapped
    }

    /**
     * @param value The Logon Group for the SAP System. Type: string (or Expression with resultType string).
     */
    @JvmName("hdtlnqpteuisthpr")
    public suspend fun logonGroup(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logonGroup = mapped
    }

    /**
     * @param value The hostname of the SAP Message Server. Type: string (or Expression with resultType string).
     */
    @JvmName("loefrequspljferd")
    public suspend fun messageServer(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageServer = mapped
    }

    /**
     * @param value The service name or port number of the Message Server. Type: string (or Expression with resultType string).
     */
    @JvmName("xovdjbgcjgsyxpyw")
    public suspend fun messageServerService(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageServerService = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("lyhedffnmvntpaby")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("sxcotcctqrtvbqgs")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("pravroppglupkmhr")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Password to access the SAP server where the table is located.
     */
    @JvmName("ocldpkrbeneyvvwj")
    public suspend
    fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password to access the SAP server where the table is located.
     */
    @JvmName("nrnbpwcsnnldgrgx")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password to access the SAP server where the table is located.
     */
    @JvmName("ivxqdfgteiwmrusj")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Host name of the SAP instance where the table is located. Type: string (or Expression with resultType string).
     */
    @JvmName("yjgsnjhgjrdgjhgo")
    public suspend fun server(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value External security product's library to access the SAP server where the table is located. Type: string (or Expression with resultType string).
     */
    @JvmName("rjmlptpifwfimpva")
    public suspend fun sncLibraryPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sncLibraryPath = mapped
    }

    /**
     * @param value SNC activation indicator to access the SAP server where the table is located. Must be either 0 (off) or 1 (on). Type: string (or Expression with resultType string).
     */
    @JvmName("ivmmwtwjpinbsvdm")
    public suspend fun sncMode(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sncMode = mapped
    }

    /**
     * @param value Initiator's SNC name to access the SAP server where the table is located. Type: string (or Expression with resultType string).
     */
    @JvmName("ucjdargemmayabst")
    public suspend fun sncMyName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sncMyName = mapped
    }

    /**
     * @param value Communication partner's SNC name to access the SAP server where the table is located. Type: string (or Expression with resultType string).
     */
    @JvmName("jwevvfohdqrffsky")
    public suspend fun sncPartnerName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sncPartnerName = mapped
    }

    /**
     * @param value SNC Quality of Protection. Allowed value include: 1, 2, 3, 8, 9. Type: string (or Expression with resultType string).
     */
    @JvmName("txgyrhslccthblnn")
    public suspend fun sncQop(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sncQop = mapped
    }

    /**
     * @param value The subscriber name. Type: string (or Expression with resultType string).
     */
    @JvmName("raxotvjwxbjrfmbx")
    public suspend fun subscriberName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriberName = mapped
    }

    /**
     * @param value SystemID of the SAP system where the table is located. Type: string (or Expression with resultType string).
     */
    @JvmName("jwaymsdoimorispo")
    public suspend fun systemId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemId = mapped
    }

    /**
     * @param value System number of the SAP system where the table is located. (Usually a two-digit decimal number represented as a string.) Type: string (or Expression with resultType string).
     */
    @JvmName("mldrkfdfjteiwtvn")
    public suspend fun systemNumber(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemNumber = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'SapOdp'.
     */
    @JvmName("fsesfdbyjkorxyof")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Username to access the SAP server where the table is located. Type: string (or Expression with resultType string).
     */
    @JvmName("ebmtlkadrfapbqku")
    public suspend fun userName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    /**
     * @param value SNC X509 certificate file path. Type: string (or Expression with resultType string).
     */
    @JvmName("sqmnolmcjyykyudx")
    public suspend fun x509CertificatePath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.x509CertificatePath = mapped
    }

    internal fun build(): SapOdpLinkedServiceArgs = SapOdpLinkedServiceArgs(
        annotations = annotations,
        clientId = clientId,
        connectVia = connectVia,
        description = description,
        encryptedCredential = encryptedCredential,
        language = language,
        logonGroup = logonGroup,
        messageServer = messageServer,
        messageServerService = messageServerService,
        parameters = parameters,
        password = password,
        server = server,
        sncLibraryPath = sncLibraryPath,
        sncMode = sncMode,
        sncMyName = sncMyName,
        sncPartnerName = sncPartnerName,
        sncQop = sncQop,
        subscriberName = subscriberName,
        systemId = systemId,
        systemNumber = systemNumber,
        type = type ?: throw PulumiNullFieldException("type"),
        userName = userName,
        x509CertificatePath = x509CertificatePath,
    )
}
