@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SapOpenHubLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * SAP Business Warehouse Open Hub Destination Linked Service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property clientId Client ID of the client on the BW system where the open hub destination is located. (Usually a three-digit decimal number represented as a string) Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property language Language of the BW system where the open hub destination is located. The default value is EN. Type: string (or Expression with resultType string).
 * @property logonGroup The Logon Group for the SAP System. Type: string (or Expression with resultType string).
 * @property messageServer The hostname of the SAP Message Server. Type: string (or Expression with resultType string).
 * @property messageServerService The service name or port number of the Message Server. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property password Password to access the SAP BW server where the open hub destination is located.
 * @property server Host name of the SAP BW instance where the open hub destination is located. Type: string (or Expression with resultType string).
 * @property systemId SystemID of the SAP system where the table is located. Type: string (or Expression with resultType string).
 * @property systemNumber System number of the BW system where the open hub destination is located. (Usually a two-digit decimal number represented as a string.) Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'SapOpenHub'.
 * @property userName Username to access the SAP BW server where the open hub destination is located. Type: string (or Expression with resultType string).
 */
public data class SapOpenHubLinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val clientId: Output<Any>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val language: Output<Any>? = null,
    public val logonGroup: Output<Any>? = null,
    public val messageServer: Output<Any>? = null,
    public val messageServerService: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val server: Output<Any>? = null,
    public val systemId: Output<Any>? = null,
    public val systemNumber: Output<Any>? = null,
    public val type: Output<String>,
    public val userName: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SapOpenHubLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SapOpenHubLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.SapOpenHubLinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .language(language?.applyValue({ args0 -> args0 }))
            .logonGroup(logonGroup?.applyValue({ args0 -> args0 }))
            .messageServer(messageServer?.applyValue({ args0 -> args0 }))
            .messageServerService(messageServerService?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(
                password?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .server(server?.applyValue({ args0 -> args0 }))
            .systemId(systemId?.applyValue({ args0 -> args0 }))
            .systemNumber(systemNumber?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SapOpenHubLinkedServiceArgs].
 */
@PulumiTagMarker
public class SapOpenHubLinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var clientId: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var language: Output<Any>? = null

    private var logonGroup: Output<Any>? = null

    private var messageServer: Output<Any>? = null

    private var messageServerService: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var server: Output<Any>? = null

    private var systemId: Output<Any>? = null

    private var systemNumber: Output<Any>? = null

    private var type: Output<String>? = null

    private var userName: Output<Any>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("snkdvvkxstavisex")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("gfuospvbiajacija")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("qgjmqhwpkyeivsdj")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value Client ID of the client on the BW system where the open hub destination is located. (Usually a three-digit decimal number represented as a string) Type: string (or Expression with resultType string).
     */
    @JvmName("gpadlaptotwemalb")
    public suspend fun clientId(`value`: Output<Any>) {
        this.clientId = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("smvpapamvviltpmg")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("ghskcllpeqlnyqcq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("hhpagmhwpuhvtjac")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value Language of the BW system where the open hub destination is located. The default value is EN. Type: string (or Expression with resultType string).
     */
    @JvmName("uffwjaedlkqdhwdg")
    public suspend fun language(`value`: Output<Any>) {
        this.language = value
    }

    /**
     * @param value The Logon Group for the SAP System. Type: string (or Expression with resultType string).
     */
    @JvmName("ekwkpscmmnbklfdl")
    public suspend fun logonGroup(`value`: Output<Any>) {
        this.logonGroup = value
    }

    /**
     * @param value The hostname of the SAP Message Server. Type: string (or Expression with resultType string).
     */
    @JvmName("jrwxbsgryffnitwd")
    public suspend fun messageServer(`value`: Output<Any>) {
        this.messageServer = value
    }

    /**
     * @param value The service name or port number of the Message Server. Type: string (or Expression with resultType string).
     */
    @JvmName("ydpmhrlolhobxojj")
    public suspend fun messageServerService(`value`: Output<Any>) {
        this.messageServerService = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("cowlwqcxjpdmphdp")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Password to access the SAP BW server where the open hub destination is located.
     */
    @JvmName("blbkvyfbqsfwuyko")
    public suspend
    fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value Host name of the SAP BW instance where the open hub destination is located. Type: string (or Expression with resultType string).
     */
    @JvmName("xmthycuhkhgopvex")
    public suspend fun server(`value`: Output<Any>) {
        this.server = value
    }

    /**
     * @param value SystemID of the SAP system where the table is located. Type: string (or Expression with resultType string).
     */
    @JvmName("ahddoahxyqfosolk")
    public suspend fun systemId(`value`: Output<Any>) {
        this.systemId = value
    }

    /**
     * @param value System number of the BW system where the open hub destination is located. (Usually a two-digit decimal number represented as a string.) Type: string (or Expression with resultType string).
     */
    @JvmName("egqcomojrdrwhmuq")
    public suspend fun systemNumber(`value`: Output<Any>) {
        this.systemNumber = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'SapOpenHub'.
     */
    @JvmName("ihjrutxxquyutnwp")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Username to access the SAP BW server where the open hub destination is located. Type: string (or Expression with resultType string).
     */
    @JvmName("tpmmxdqmhypgwfgq")
    public suspend fun userName(`value`: Output<Any>) {
        this.userName = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("exhmpbuiwcoltdal")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("ifxnasbxbtkdneum")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Client ID of the client on the BW system where the open hub destination is located. (Usually a three-digit decimal number represented as a string) Type: string (or Expression with resultType string).
     */
    @JvmName("stwqtkdjgtfhuxyu")
    public suspend fun clientId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("bfqpliykmmlaviit")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("hyijqennqonjnbci")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("bwvoxnlhsajfovks")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("ooxmframnhxaxldh")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value Language of the BW system where the open hub destination is located. The default value is EN. Type: string (or Expression with resultType string).
     */
    @JvmName("tamciogsevwvpfho")
    public suspend fun language(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.language = mapped
    }

    /**
     * @param value The Logon Group for the SAP System. Type: string (or Expression with resultType string).
     */
    @JvmName("spwivkvtpohkvqyr")
    public suspend fun logonGroup(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logonGroup = mapped
    }

    /**
     * @param value The hostname of the SAP Message Server. Type: string (or Expression with resultType string).
     */
    @JvmName("vjwrbklwgcaxvjxa")
    public suspend fun messageServer(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageServer = mapped
    }

    /**
     * @param value The service name or port number of the Message Server. Type: string (or Expression with resultType string).
     */
    @JvmName("kloxugnsgqwjsrbl")
    public suspend fun messageServerService(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageServerService = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("ejqbjimywirbuwam")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("xgvkuvgjtpegyrpv")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("xfsjadsrerjgxoyn")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Password to access the SAP BW server where the open hub destination is located.
     */
    @JvmName("pxmajmaqjcwsvpwk")
    public suspend
    fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password to access the SAP BW server where the open hub destination is located.
     */
    @JvmName("ckmadncuvvnaoynl")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password to access the SAP BW server where the open hub destination is located.
     */
    @JvmName("cipdoduawmvubyhu")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Host name of the SAP BW instance where the open hub destination is located. Type: string (or Expression with resultType string).
     */
    @JvmName("fagsfvvfycaclicy")
    public suspend fun server(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value SystemID of the SAP system where the table is located. Type: string (or Expression with resultType string).
     */
    @JvmName("edftxwittyutnteo")
    public suspend fun systemId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemId = mapped
    }

    /**
     * @param value System number of the BW system where the open hub destination is located. (Usually a two-digit decimal number represented as a string.) Type: string (or Expression with resultType string).
     */
    @JvmName("fhmhbmsyxtwbefbv")
    public suspend fun systemNumber(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemNumber = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'SapOpenHub'.
     */
    @JvmName("owculgdhpbbkxwtm")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Username to access the SAP BW server where the open hub destination is located. Type: string (or Expression with resultType string).
     */
    @JvmName("fnnrdqbsiumiercw")
    public suspend fun userName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): SapOpenHubLinkedServiceArgs = SapOpenHubLinkedServiceArgs(
        annotations = annotations,
        clientId = clientId,
        connectVia = connectVia,
        description = description,
        encryptedCredential = encryptedCredential,
        language = language,
        logonGroup = logonGroup,
        messageServer = messageServer,
        messageServerService = messageServerService,
        parameters = parameters,
        password = password,
        server = server,
        systemId = systemId,
        systemNumber = systemNumber,
        type = type ?: throw PulumiNullFieldException("type"),
        userName = userName,
    )
}
