@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SapTablePartitionSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The settings that will be leveraged for SAP table source partitioning.
 * @property maxPartitionsNumber The maximum value of partitions the table will be split into. Type: integer (or Expression with resultType string).
 * @property partitionColumnName The name of the column that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
 * @property partitionLowerBound The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
 * @property partitionUpperBound The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
 */
public data class SapTablePartitionSettingsArgs(
    public val maxPartitionsNumber: Output<Any>? = null,
    public val partitionColumnName: Output<Any>? = null,
    public val partitionLowerBound: Output<Any>? = null,
    public val partitionUpperBound: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SapTablePartitionSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SapTablePartitionSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.SapTablePartitionSettingsArgs.builder()
            .maxPartitionsNumber(maxPartitionsNumber?.applyValue({ args0 -> args0 }))
            .partitionColumnName(partitionColumnName?.applyValue({ args0 -> args0 }))
            .partitionLowerBound(partitionLowerBound?.applyValue({ args0 -> args0 }))
            .partitionUpperBound(partitionUpperBound?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SapTablePartitionSettingsArgs].
 */
@PulumiTagMarker
public class SapTablePartitionSettingsArgsBuilder internal constructor() {
    private var maxPartitionsNumber: Output<Any>? = null

    private var partitionColumnName: Output<Any>? = null

    private var partitionLowerBound: Output<Any>? = null

    private var partitionUpperBound: Output<Any>? = null

    /**
     * @param value The maximum value of partitions the table will be split into. Type: integer (or Expression with resultType string).
     */
    @JvmName("iaghbttpjcbxhmhg")
    public suspend fun maxPartitionsNumber(`value`: Output<Any>) {
        this.maxPartitionsNumber = value
    }

    /**
     * @param value The name of the column that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("idqxhbkjosdmyubo")
    public suspend fun partitionColumnName(`value`: Output<Any>) {
        this.partitionColumnName = value
    }

    /**
     * @param value The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("kuurjypakwogcueh")
    public suspend fun partitionLowerBound(`value`: Output<Any>) {
        this.partitionLowerBound = value
    }

    /**
     * @param value The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("svgjmsvfwnmagnuv")
    public suspend fun partitionUpperBound(`value`: Output<Any>) {
        this.partitionUpperBound = value
    }

    /**
     * @param value The maximum value of partitions the table will be split into. Type: integer (or Expression with resultType string).
     */
    @JvmName("eirypwmkuuxrvxag")
    public suspend fun maxPartitionsNumber(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxPartitionsNumber = mapped
    }

    /**
     * @param value The name of the column that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("kkrfdwbnvpsuotcg")
    public suspend fun partitionColumnName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionColumnName = mapped
    }

    /**
     * @param value The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("hlwreloiuadlgolu")
    public suspend fun partitionLowerBound(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionLowerBound = mapped
    }

    /**
     * @param value The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("tlajgbakoknyfdqc")
    public suspend fun partitionUpperBound(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionUpperBound = mapped
    }

    internal fun build(): SapTablePartitionSettingsArgs = SapTablePartitionSettingsArgs(
        maxPartitionsNumber = maxPartitionsNumber,
        partitionColumnName = partitionColumnName,
        partitionLowerBound = partitionLowerBound,
        partitionUpperBound = partitionUpperBound,
    )
}
