@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ScriptActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Custom script action to run on HDI ondemand cluster once it's up.
 * @property name The user provided name of the script action.
 * @property parameters The parameters for the script action.
 * @property roles The node types on which the script action should be executed.
 * @property uri The URI for the script action.
 */
public data class ScriptActionArgs(
    public val name: Output<String>,
    public val parameters: Output<String>? = null,
    public val roles: Output<Any>,
    public val uri: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ScriptActionArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ScriptActionArgs =
        com.pulumi.azurenative.datafactory.inputs.ScriptActionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters?.applyValue({ args0 -> args0 }))
            .roles(roles.applyValue({ args0 -> args0 }))
            .uri(uri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScriptActionArgs].
 */
@PulumiTagMarker
public class ScriptActionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<String>? = null

    private var roles: Output<Any>? = null

    private var uri: Output<String>? = null

    /**
     * @param value The user provided name of the script action.
     */
    @JvmName("sqrsfahfinxbtust")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The parameters for the script action.
     */
    @JvmName("qwopcrwcxhrqquxc")
    public suspend fun parameters(`value`: Output<String>) {
        this.parameters = value
    }

    /**
     * @param value The node types on which the script action should be executed.
     */
    @JvmName("lqubtsoglygpqgfy")
    public suspend fun roles(`value`: Output<Any>) {
        this.roles = value
    }

    /**
     * @param value The URI for the script action.
     */
    @JvmName("aomxlhsuuihlwlns")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value The user provided name of the script action.
     */
    @JvmName("qyhgabqtxoqodkru")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The parameters for the script action.
     */
    @JvmName("uquaeqgabnuxrdmv")
    public suspend fun parameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The node types on which the script action should be executed.
     */
    @JvmName("dacyjlaphbkiyjrx")
    public suspend fun roles(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param value The URI for the script action.
     */
    @JvmName("vypcibgftugtnpvt")
    public suspend fun uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): ScriptActionArgs = ScriptActionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters,
        roles = roles ?: throw PulumiNullFieldException("roles"),
        uri = uri ?: throw PulumiNullFieldException("uri"),
    )
}
