@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SecureInputOutputPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Execution policy for an activity that supports secure input and output.
 * @property secureInput When set to true, Input from activity is considered as secure and will not be logged to monitoring.
 * @property secureOutput When set to true, Output from activity is considered as secure and will not be logged to monitoring.
 */
public data class SecureInputOutputPolicyArgs(
    public val secureInput: Output<Boolean>? = null,
    public val secureOutput: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SecureInputOutputPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SecureInputOutputPolicyArgs =
        com.pulumi.azurenative.datafactory.inputs.SecureInputOutputPolicyArgs.builder()
            .secureInput(secureInput?.applyValue({ args0 -> args0 }))
            .secureOutput(secureOutput?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecureInputOutputPolicyArgs].
 */
@PulumiTagMarker
public class SecureInputOutputPolicyArgsBuilder internal constructor() {
    private var secureInput: Output<Boolean>? = null

    private var secureOutput: Output<Boolean>? = null

    /**
     * @param value When set to true, Input from activity is considered as secure and will not be logged to monitoring.
     */
    @JvmName("wjrdtlpvlrfibkip")
    public suspend fun secureInput(`value`: Output<Boolean>) {
        this.secureInput = value
    }

    /**
     * @param value When set to true, Output from activity is considered as secure and will not be logged to monitoring.
     */
    @JvmName("tpblilbpnvhisutn")
    public suspend fun secureOutput(`value`: Output<Boolean>) {
        this.secureOutput = value
    }

    /**
     * @param value When set to true, Input from activity is considered as secure and will not be logged to monitoring.
     */
    @JvmName("yyfpkrfqonffqlvf")
    public suspend fun secureInput(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secureInput = mapped
    }

    /**
     * @param value When set to true, Output from activity is considered as secure and will not be logged to monitoring.
     */
    @JvmName("fglflgcrbsbtmuaj")
    public suspend fun secureOutput(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secureOutput = mapped
    }

    internal fun build(): SecureInputOutputPolicyArgs = SecureInputOutputPolicyArgs(
        secureInput = secureInput,
        secureOutput = secureOutput,
    )
}
