@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SecureStringArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure Data Factory secure string definition. The string value will be masked with asterisks '*' during Get or List API calls.
 * @property type Type of the secret.
 * Expected value is 'SecureString'.
 * @property value Value of secure string.
 */
public data class SecureStringArgs(
    public val type: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SecureStringArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SecureStringArgs =
        com.pulumi.azurenative.datafactory.inputs.SecureStringArgs.builder()
            .type(type.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecureStringArgs].
 */
@PulumiTagMarker
public class SecureStringArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Type of the secret.
     * Expected value is 'SecureString'.
     */
    @JvmName("btouajssmudhrvty")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Value of secure string.
     */
    @JvmName("maranpcmrxgtknin")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Type of the secret.
     * Expected value is 'SecureString'.
     */
    @JvmName("ammndfwpvobytqnd")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Value of secure string.
     */
    @JvmName("dhdkcjyumcqwcasb")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): SecureStringArgs = SecureStringArgs(
        type = type ?: throw PulumiNullFieldException("type"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
