@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SftpServerLinkedServiceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.SftpAuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A linked service for an SSH File Transfer Protocol (SFTP) server.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authenticationType The authentication type to be used to connect to the FTP server.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property host The SFTP server host name. Type: string (or Expression with resultType string).
 * @property hostKeyFingerprint The host key finger-print of the SFTP server. When SkipHostKeyValidation is false, HostKeyFingerprint should be specified. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property passPhrase The password to decrypt the SSH private key if the SSH private key is encrypted.
 * @property password Password to logon the SFTP server for Basic authentication.
 * @property port The TCP port number that the SFTP server uses to listen for client connections. Default value is 22. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property privateKeyContent Base64 encoded SSH private key content for SshPublicKey authentication. For on-premises copy with SshPublicKey authentication, either PrivateKeyPath or PrivateKeyContent should be specified. SSH private key should be OpenSSH format.
 * @property privateKeyPath The SSH private key file path for SshPublicKey authentication. Only valid for on-premises copy. For on-premises copy with SshPublicKey authentication, either PrivateKeyPath or PrivateKeyContent should be specified. SSH private key should be OpenSSH format. Type: string (or Expression with resultType string).
 * @property skipHostKeyValidation If true, skip the SSH host key validation. Default value is false. Type: boolean (or Expression with resultType boolean).
 * @property type Type of linked service.
 * Expected value is 'Sftp'.
 * @property userName The username used to log on to the SFTP server. Type: string (or Expression with resultType string).
 */
public data class SftpServerLinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val authenticationType: Output<Either<String, SftpAuthenticationType>>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val host: Output<Any>,
    public val hostKeyFingerprint: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val passPhrase: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val port: Output<Any>? = null,
    public val privateKeyContent: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val privateKeyPath: Output<Any>? = null,
    public val skipHostKeyValidation: Output<Any>? = null,
    public val type: Output<String>,
    public val userName: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SftpServerLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SftpServerLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.SftpServerLinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authenticationType(
                authenticationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .host(host.applyValue({ args0 -> args0 }))
            .hostKeyFingerprint(hostKeyFingerprint?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .passPhrase(
                passPhrase?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .password(
                password?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .port(port?.applyValue({ args0 -> args0 }))
            .privateKeyContent(
                privateKeyContent?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .privateKeyPath(privateKeyPath?.applyValue({ args0 -> args0 }))
            .skipHostKeyValidation(skipHostKeyValidation?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SftpServerLinkedServiceArgs].
 */
@PulumiTagMarker
public class SftpServerLinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var authenticationType: Output<Either<String, SftpAuthenticationType>>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var host: Output<Any>? = null

    private var hostKeyFingerprint: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var passPhrase: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var port: Output<Any>? = null

    private var privateKeyContent: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var privateKeyPath: Output<Any>? = null

    private var skipHostKeyValidation: Output<Any>? = null

    private var type: Output<String>? = null

    private var userName: Output<Any>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("fgocvqqeleuudeha")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("sxcrogamcnseqfgb")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("cesokwqxksbyjexl")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The authentication type to be used to connect to the FTP server.
     */
    @JvmName("tbakxxdqqwtlmquk")
    public suspend fun authenticationType(`value`: Output<Either<String, SftpAuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("irpaiivnhbefokrk")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("rbljnonlylheobgf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("vbhywxjvclmhhetp")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value The SFTP server host name. Type: string (or Expression with resultType string).
     */
    @JvmName("ifronrxrdoikmvcd")
    public suspend fun host(`value`: Output<Any>) {
        this.host = value
    }

    /**
     * @param value The host key finger-print of the SFTP server. When SkipHostKeyValidation is false, HostKeyFingerprint should be specified. Type: string (or Expression with resultType string).
     */
    @JvmName("bmbxhglmlafohlku")
    public suspend fun hostKeyFingerprint(`value`: Output<Any>) {
        this.hostKeyFingerprint = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("iugebfxtwhdjnmjw")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The password to decrypt the SSH private key if the SSH private key is encrypted.
     */
    @JvmName("sdfapedidwjdotws")
    public suspend
    fun passPhrase(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.passPhrase = value
    }

    /**
     * @param value Password to logon the SFTP server for Basic authentication.
     */
    @JvmName("rjqiwloujahcjfkb")
    public suspend
    fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value The TCP port number that the SFTP server uses to listen for client connections. Default value is 22. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("ovwwpdhmmawvvxaj")
    public suspend fun port(`value`: Output<Any>) {
        this.port = value
    }

    /**
     * @param value Base64 encoded SSH private key content for SshPublicKey authentication. For on-premises copy with SshPublicKey authentication, either PrivateKeyPath or PrivateKeyContent should be specified. SSH private key should be OpenSSH format.
     */
    @JvmName("pesghuwfgtuelhsl")
    public suspend
    fun privateKeyContent(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.privateKeyContent = value
    }

    /**
     * @param value The SSH private key file path for SshPublicKey authentication. Only valid for on-premises copy. For on-premises copy with SshPublicKey authentication, either PrivateKeyPath or PrivateKeyContent should be specified. SSH private key should be OpenSSH format. Type: string (or Expression with resultType string).
     */
    @JvmName("eoayeagerfxfubeq")
    public suspend fun privateKeyPath(`value`: Output<Any>) {
        this.privateKeyPath = value
    }

    /**
     * @param value If true, skip the SSH host key validation. Default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("gpwovxsvytjtpkxt")
    public suspend fun skipHostKeyValidation(`value`: Output<Any>) {
        this.skipHostKeyValidation = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Sftp'.
     */
    @JvmName("fyhvjqwobosgowys")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The username used to log on to the SFTP server. Type: string (or Expression with resultType string).
     */
    @JvmName("rfylcsbblfnkgmds")
    public suspend fun userName(`value`: Output<Any>) {
        this.userName = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("hsvdtkeyddsssvqa")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("gwrrukjohqhelbwb")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The authentication type to be used to connect to the FTP server.
     */
    @JvmName("emtsrragdgrbiklx")
    public suspend fun authenticationType(`value`: Either<String, SftpAuthenticationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The authentication type to be used to connect to the FTP server.
     */
    @JvmName("arjixtjpsjhtcvua")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SftpAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The authentication type to be used to connect to the FTP server.
     */
    @JvmName("hxvosdflsjdpdwat")
    public fun authenticationType(`value`: SftpAuthenticationType) {
        val toBeMapped = Either.ofRight<String, SftpAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("xcmflpqkqgjywayt")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("cqwvuusnxwjhnhka")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("ovlxsrqlidngflaw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("lslgdykxxatldana")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value The SFTP server host name. Type: string (or Expression with resultType string).
     */
    @JvmName("vdodqimbfgbexxot")
    public suspend fun host(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value The host key finger-print of the SFTP server. When SkipHostKeyValidation is false, HostKeyFingerprint should be specified. Type: string (or Expression with resultType string).
     */
    @JvmName("rrkbjajxpynmjjhh")
    public suspend fun hostKeyFingerprint(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostKeyFingerprint = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("kjblxvlebltrwdjp")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("agwpoqtisixomihh")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("ypekgjeybtdsyakx")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The password to decrypt the SSH private key if the SSH private key is encrypted.
     */
    @JvmName("hilnsnpouljyhxar")
    public suspend
    fun passPhrase(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passPhrase = mapped
    }

    /**
     * @param value The password to decrypt the SSH private key if the SSH private key is encrypted.
     */
    @JvmName("mnupnnxxwioqhiut")
    public fun passPhrase(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.passPhrase = mapped
    }

    /**
     * @param value The password to decrypt the SSH private key if the SSH private key is encrypted.
     */
    @JvmName("dgbbhyckrydggdlf")
    public fun passPhrase(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.passPhrase = mapped
    }

    /**
     * @param value Password to logon the SFTP server for Basic authentication.
     */
    @JvmName("xwehfjpjtciiarpw")
    public suspend
    fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password to logon the SFTP server for Basic authentication.
     */
    @JvmName("vouagjiidcwxmgeg")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password to logon the SFTP server for Basic authentication.
     */
    @JvmName("jdkqtbwoerisqdkr")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The TCP port number that the SFTP server uses to listen for client connections. Default value is 22. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("yaiksxvmrdekkopb")
    public suspend fun port(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Base64 encoded SSH private key content for SshPublicKey authentication. For on-premises copy with SshPublicKey authentication, either PrivateKeyPath or PrivateKeyContent should be specified. SSH private key should be OpenSSH format.
     */
    @JvmName("rqsredkafdmyovvr")
    public suspend
    fun privateKeyContent(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateKeyContent = mapped
    }

    /**
     * @param value Base64 encoded SSH private key content for SshPublicKey authentication. For on-premises copy with SshPublicKey authentication, either PrivateKeyPath or PrivateKeyContent should be specified. SSH private key should be OpenSSH format.
     */
    @JvmName("kafdbjoiteahrcaj")
    public fun privateKeyContent(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateKeyContent = mapped
    }

    /**
     * @param value Base64 encoded SSH private key content for SshPublicKey authentication. For on-premises copy with SshPublicKey authentication, either PrivateKeyPath or PrivateKeyContent should be specified. SSH private key should be OpenSSH format.
     */
    @JvmName("fvdubprrvcxfvpls")
    public fun privateKeyContent(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateKeyContent = mapped
    }

    /**
     * @param value The SSH private key file path for SshPublicKey authentication. Only valid for on-premises copy. For on-premises copy with SshPublicKey authentication, either PrivateKeyPath or PrivateKeyContent should be specified. SSH private key should be OpenSSH format. Type: string (or Expression with resultType string).
     */
    @JvmName("ywnmhxiklitnuxew")
    public suspend fun privateKeyPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateKeyPath = mapped
    }

    /**
     * @param value If true, skip the SSH host key validation. Default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("oowopythcanrhxqx")
    public suspend fun skipHostKeyValidation(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipHostKeyValidation = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Sftp'.
     */
    @JvmName("tkqwgfcrloxnqoxg")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The username used to log on to the SFTP server. Type: string (or Expression with resultType string).
     */
    @JvmName("nxxlphlueprjpnhk")
    public suspend fun userName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): SftpServerLinkedServiceArgs = SftpServerLinkedServiceArgs(
        annotations = annotations,
        authenticationType = authenticationType,
        connectVia = connectVia,
        description = description,
        encryptedCredential = encryptedCredential,
        host = host ?: throw PulumiNullFieldException("host"),
        hostKeyFingerprint = hostKeyFingerprint,
        parameters = parameters,
        passPhrase = passPhrase,
        password = password,
        port = port,
        privateKeyContent = privateKeyContent,
        privateKeyPath = privateKeyPath,
        skipHostKeyValidation = skipHostKeyValidation,
        type = type ?: throw PulumiNullFieldException("type"),
        userName = userName,
    )
}
