@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SnowflakeV2LinkedServiceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.SnowflakeAuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Snowflake linked service.
 * @property accountIdentifier The account identifier of your Snowflake account, e.g. xy12345.east-us-2.azure
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authenticationType The type used for authentication. Type: string.
 * @property clientId The client ID of the application registered in Azure Active Directory for AADServicePrincipal authentication.
 * @property clientSecret The Azure key vault secret reference of client secret for AADServicePrincipal authentication.
 * @property connectVia The integration runtime reference.
 * @property database The name of the Snowflake database.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property password The Azure key vault secret reference of password in connection string.
 * @property privateKey The Azure key vault secret reference of privateKey for KeyPair auth.
 * @property privateKeyPassphrase The Azure key vault secret reference of private key password for KeyPair auth with encrypted private key.
 * @property scope The scope of the application registered in Azure Active Directory for AADServicePrincipal authentication.
 * @property tenantId The tenant ID of the application registered in Azure Active Directory for AADServicePrincipal authentication.
 * @property type Type of linked service.
 * Expected value is 'SnowflakeV2'.
 * @property user The name of the Snowflake user.
 * @property warehouse The name of the Snowflake warehouse.
 */
public data class SnowflakeV2LinkedServiceArgs(
    public val accountIdentifier: Output<Any>,
    public val annotations: Output<List<Any>>? = null,
    public val authenticationType: Output<Either<String, SnowflakeAuthenticationType>>? = null,
    public val clientId: Output<Any>? = null,
    public val clientSecret: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val database: Output<Any>,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val privateKey: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val privateKeyPassphrase:
    Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val scope: Output<Any>? = null,
    public val tenantId: Output<Any>? = null,
    public val type: Output<String>,
    public val user: Output<Any>? = null,
    public val warehouse: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SnowflakeV2LinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SnowflakeV2LinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.SnowflakeV2LinkedServiceArgs.builder()
            .accountIdentifier(accountIdentifier.applyValue({ args0 -> args0 }))
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authenticationType(
                authenticationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(
                clientSecret?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .database(database.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(
                password?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .privateKey(
                privateKey?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .privateKeyPassphrase(
                privateKeyPassphrase?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .scope(scope?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .user(user?.applyValue({ args0 -> args0 }))
            .warehouse(warehouse.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SnowflakeV2LinkedServiceArgs].
 */
@PulumiTagMarker
public class SnowflakeV2LinkedServiceArgsBuilder internal constructor() {
    private var accountIdentifier: Output<Any>? = null

    private var annotations: Output<List<Any>>? = null

    private var authenticationType: Output<Either<String, SnowflakeAuthenticationType>>? = null

    private var clientId: Output<Any>? = null

    private var clientSecret: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var database: Output<Any>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var privateKey: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var privateKeyPassphrase:
        Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var scope: Output<Any>? = null

    private var tenantId: Output<Any>? = null

    private var type: Output<String>? = null

    private var user: Output<Any>? = null

    private var warehouse: Output<Any>? = null

    /**
     * @param value The account identifier of your Snowflake account, e.g. xy12345.east-us-2.azure
     */
    @JvmName("jxkysaxeqccwuuux")
    public suspend fun accountIdentifier(`value`: Output<Any>) {
        this.accountIdentifier = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("krrefnntisvmnhcr")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("xaxvmpuoetisdgwo")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("fyfcwufpodhedlol")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The type used for authentication. Type: string.
     */
    @JvmName("aetupqqwaodjgaxp")
    public suspend
    fun authenticationType(`value`: Output<Either<String, SnowflakeAuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value The client ID of the application registered in Azure Active Directory for AADServicePrincipal authentication.
     */
    @JvmName("qjelyqsywtwowdhs")
    public suspend fun clientId(`value`: Output<Any>) {
        this.clientId = value
    }

    /**
     * @param value The Azure key vault secret reference of client secret for AADServicePrincipal authentication.
     */
    @JvmName("tshidnlidqiqirqh")
    public suspend
    fun clientSecret(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.clientSecret = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("opyyxkqbjgciuriu")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value The name of the Snowflake database.
     */
    @JvmName("eolcjoopbpyqkrpb")
    public suspend fun database(`value`: Output<Any>) {
        this.database = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("wmhocvwjogttyung")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("otsvasqjxnimsiuy")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("xayseugqmchkyxny")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The Azure key vault secret reference of password in connection string.
     */
    @JvmName("qvkgiorasgumehnw")
    public suspend
    fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value The Azure key vault secret reference of privateKey for KeyPair auth.
     */
    @JvmName("hluycyruvhwinmql")
    public suspend
    fun privateKey(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.privateKey = value
    }

    /**
     * @param value The Azure key vault secret reference of private key password for KeyPair auth with encrypted private key.
     */
    @JvmName("rquacmodeemseosf")
    public suspend
    fun privateKeyPassphrase(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.privateKeyPassphrase = value
    }

    /**
     * @param value The scope of the application registered in Azure Active Directory for AADServicePrincipal authentication.
     */
    @JvmName("rjkbljvbxkapresq")
    public suspend fun scope(`value`: Output<Any>) {
        this.scope = value
    }

    /**
     * @param value The tenant ID of the application registered in Azure Active Directory for AADServicePrincipal authentication.
     */
    @JvmName("larkuokomkihofqg")
    public suspend fun tenantId(`value`: Output<Any>) {
        this.tenantId = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'SnowflakeV2'.
     */
    @JvmName("vpiiwtsodkyiucii")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of the Snowflake user.
     */
    @JvmName("gyadwadvovxgjnfb")
    public suspend fun user(`value`: Output<Any>) {
        this.user = value
    }

    /**
     * @param value The name of the Snowflake warehouse.
     */
    @JvmName("osrhpcjlwunhebua")
    public suspend fun warehouse(`value`: Output<Any>) {
        this.warehouse = value
    }

    /**
     * @param value The account identifier of your Snowflake account, e.g. xy12345.east-us-2.azure
     */
    @JvmName("ksexukqgosmdhwhh")
    public suspend fun accountIdentifier(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountIdentifier = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("gsmsnblcbbtjatah")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("bcadsjmynotmobdt")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The type used for authentication. Type: string.
     */
    @JvmName("kjakjgjsqevvsjtw")
    public suspend fun authenticationType(`value`: Either<String, SnowflakeAuthenticationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The type used for authentication. Type: string.
     */
    @JvmName("qmnlwqodeqwrqbtn")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SnowflakeAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The type used for authentication. Type: string.
     */
    @JvmName("luqlbyplyxbublux")
    public fun authenticationType(`value`: SnowflakeAuthenticationType) {
        val toBeMapped = Either.ofRight<String, SnowflakeAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The client ID of the application registered in Azure Active Directory for AADServicePrincipal authentication.
     */
    @JvmName("tngxxxfojiljbobf")
    public suspend fun clientId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The Azure key vault secret reference of client secret for AADServicePrincipal authentication.
     */
    @JvmName("mjkuohxvcohufaks")
    public suspend
    fun clientSecret(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The Azure key vault secret reference of client secret for AADServicePrincipal authentication.
     */
    @JvmName("abrfgmhesqsxpmgk")
    public fun clientSecret(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The Azure key vault secret reference of client secret for AADServicePrincipal authentication.
     */
    @JvmName("dviocvgqvrxjwyud")
    public fun clientSecret(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("ywmqgarwxujrvrkd")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("gccgqihbupqsqhdy")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value The name of the Snowflake database.
     */
    @JvmName("stxkjshnotlbixbi")
    public suspend fun database(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("sbvcrfvxacfipfat")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("eexmcgurpjvwhbro")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("dwkunokplacmxqqp")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("ogokbwnslgkolemv")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("bbnaigrfpjkvkpkm")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The Azure key vault secret reference of password in connection string.
     */
    @JvmName("bvivjbypkidtgljb")
    public suspend
    fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The Azure key vault secret reference of password in connection string.
     */
    @JvmName("ebjldmttkqiiikue")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The Azure key vault secret reference of password in connection string.
     */
    @JvmName("cwlkefydtjwepovn")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The Azure key vault secret reference of privateKey for KeyPair auth.
     */
    @JvmName("rpyrulfljxuatjeq")
    public suspend
    fun privateKey(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateKey = mapped
    }

    /**
     * @param value The Azure key vault secret reference of privateKey for KeyPair auth.
     */
    @JvmName("gdboiehcsfydbmkw")
    public fun privateKey(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateKey = mapped
    }

    /**
     * @param value The Azure key vault secret reference of privateKey for KeyPair auth.
     */
    @JvmName("liebqixkulmrhiks")
    public fun privateKey(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateKey = mapped
    }

    /**
     * @param value The Azure key vault secret reference of private key password for KeyPair auth with encrypted private key.
     */
    @JvmName("cwvrdwrunicdlnfe")
    public suspend
    fun privateKeyPassphrase(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateKeyPassphrase = mapped
    }

    /**
     * @param value The Azure key vault secret reference of private key password for KeyPair auth with encrypted private key.
     */
    @JvmName("vncinrkytjerngca")
    public fun privateKeyPassphrase(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateKeyPassphrase = mapped
    }

    /**
     * @param value The Azure key vault secret reference of private key password for KeyPair auth with encrypted private key.
     */
    @JvmName("psohauflpgubrhpy")
    public fun privateKeyPassphrase(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateKeyPassphrase = mapped
    }

    /**
     * @param value The scope of the application registered in Azure Active Directory for AADServicePrincipal authentication.
     */
    @JvmName("ywfniecvkeioppef")
    public suspend fun scope(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The tenant ID of the application registered in Azure Active Directory for AADServicePrincipal authentication.
     */
    @JvmName("adorimpicbacbosm")
    public suspend fun tenantId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'SnowflakeV2'.
     */
    @JvmName("mpvekigjeslhpbea")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The name of the Snowflake user.
     */
    @JvmName("kwvtcmcxinlliuxt")
    public suspend fun user(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.user = mapped
    }

    /**
     * @param value The name of the Snowflake warehouse.
     */
    @JvmName("rujomyihkqxxbhme")
    public suspend fun warehouse(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.warehouse = mapped
    }

    internal fun build(): SnowflakeV2LinkedServiceArgs = SnowflakeV2LinkedServiceArgs(
        accountIdentifier = accountIdentifier ?: throw PulumiNullFieldException("accountIdentifier"),
        annotations = annotations,
        authenticationType = authenticationType,
        clientId = clientId,
        clientSecret = clientSecret,
        connectVia = connectVia,
        database = database ?: throw PulumiNullFieldException("database"),
        description = description,
        encryptedCredential = encryptedCredential,
        parameters = parameters,
        password = password,
        privateKey = privateKey,
        privateKeyPassphrase = privateKeyPassphrase,
        scope = scope,
        tenantId = tenantId,
        type = type ?: throw PulumiNullFieldException("type"),
        user = user,
        warehouse = warehouse ?: throw PulumiNullFieldException("warehouse"),
    )
}
