@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SparkConfigurationParametrizationReferenceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.SparkConfigurationReferenceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Spark configuration reference.
 * @property referenceName Reference spark configuration name. Type: string (or Expression with resultType string).
 * @property type Spark configuration reference type.
 */
public data class SparkConfigurationParametrizationReferenceArgs(
    public val referenceName: Output<Any>,
    public val type: Output<Either<String, SparkConfigurationReferenceType>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SparkConfigurationParametrizationReferenceArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.SparkConfigurationParametrizationReferenceArgs =
        com.pulumi.azurenative.datafactory.inputs.SparkConfigurationParametrizationReferenceArgs.builder()
            .referenceName(referenceName.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SparkConfigurationParametrizationReferenceArgs].
 */
@PulumiTagMarker
public class SparkConfigurationParametrizationReferenceArgsBuilder internal constructor() {
    private var referenceName: Output<Any>? = null

    private var type: Output<Either<String, SparkConfigurationReferenceType>>? = null

    /**
     * @param value Reference spark configuration name. Type: string (or Expression with resultType string).
     */
    @JvmName("kalrrhsfbxxqbxui")
    public suspend fun referenceName(`value`: Output<Any>) {
        this.referenceName = value
    }

    /**
     * @param value Spark configuration reference type.
     */
    @JvmName("wnqqbpkbomojedif")
    public suspend fun type(`value`: Output<Either<String, SparkConfigurationReferenceType>>) {
        this.type = value
    }

    /**
     * @param value Reference spark configuration name. Type: string (or Expression with resultType string).
     */
    @JvmName("ogvautdtmiyqtjkc")
    public suspend fun referenceName(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referenceName = mapped
    }

    /**
     * @param value Spark configuration reference type.
     */
    @JvmName("haswipstxxtqjnan")
    public suspend fun type(`value`: Either<String, SparkConfigurationReferenceType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Spark configuration reference type.
     */
    @JvmName("hpjaaseetwrinogl")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SparkConfigurationReferenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Spark configuration reference type.
     */
    @JvmName("aqystooscypeecqt")
    public fun type(`value`: SparkConfigurationReferenceType) {
        val toBeMapped = Either.ofRight<String, SparkConfigurationReferenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SparkConfigurationParametrizationReferenceArgs =
        SparkConfigurationParametrizationReferenceArgs(
            referenceName = referenceName ?: throw PulumiNullFieldException("referenceName"),
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
