@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SynapseSparkJobReferenceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.SparkJobReferenceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Synapse spark job reference type.
 * @property referenceName Reference spark job name. Expression with resultType string.
 * @property type Synapse spark job reference type.
 */
public data class SynapseSparkJobReferenceArgs(
    public val referenceName: Output<Any>,
    public val type: Output<Either<String, SparkJobReferenceType>>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SynapseSparkJobReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SynapseSparkJobReferenceArgs =
        com.pulumi.azurenative.datafactory.inputs.SynapseSparkJobReferenceArgs.builder()
            .referenceName(referenceName.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SynapseSparkJobReferenceArgs].
 */
@PulumiTagMarker
public class SynapseSparkJobReferenceArgsBuilder internal constructor() {
    private var referenceName: Output<Any>? = null

    private var type: Output<Either<String, SparkJobReferenceType>>? = null

    /**
     * @param value Reference spark job name. Expression with resultType string.
     */
    @JvmName("gbxtntdkixalvkcx")
    public suspend fun referenceName(`value`: Output<Any>) {
        this.referenceName = value
    }

    /**
     * @param value Synapse spark job reference type.
     */
    @JvmName("kipaygvdtufiwlrf")
    public suspend fun type(`value`: Output<Either<String, SparkJobReferenceType>>) {
        this.type = value
    }

    /**
     * @param value Reference spark job name. Expression with resultType string.
     */
    @JvmName("oqxkjxhiqsqawvvu")
    public suspend fun referenceName(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referenceName = mapped
    }

    /**
     * @param value Synapse spark job reference type.
     */
    @JvmName("mfjwtknmufbglrrl")
    public suspend fun type(`value`: Either<String, SparkJobReferenceType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Synapse spark job reference type.
     */
    @JvmName("rdavwawkfstqgghx")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SparkJobReferenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Synapse spark job reference type.
     */
    @JvmName("aewxfjllggehnfgm")
    public fun type(`value`: SparkJobReferenceType) {
        val toBeMapped = Either.ofRight<String, SparkJobReferenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SynapseSparkJobReferenceArgs = SynapseSparkJobReferenceArgs(
        referenceName = referenceName ?: throw PulumiNullFieldException("referenceName"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
