@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.TarReadSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Tar compression read settings.
 * @property preserveCompressionFileNameAsFolder Preserve the compression file name as folder path. Type: boolean (or Expression with resultType boolean).
 * @property type The Compression setting type.
 * Expected value is 'TarReadSettings'.
 */
public data class TarReadSettingsArgs(
    public val preserveCompressionFileNameAsFolder: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.TarReadSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.TarReadSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.TarReadSettingsArgs.builder()
            .preserveCompressionFileNameAsFolder(
                preserveCompressionFileNameAsFolder?.applyValue({ args0 ->
                    args0
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TarReadSettingsArgs].
 */
@PulumiTagMarker
public class TarReadSettingsArgsBuilder internal constructor() {
    private var preserveCompressionFileNameAsFolder: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Preserve the compression file name as folder path. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("melmbfelqbmlynme")
    public suspend fun preserveCompressionFileNameAsFolder(`value`: Output<Any>) {
        this.preserveCompressionFileNameAsFolder = value
    }

    /**
     * @param value The Compression setting type.
     * Expected value is 'TarReadSettings'.
     */
    @JvmName("mefijxxudijispeu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Preserve the compression file name as folder path. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("gggkplwblrnbqxhj")
    public suspend fun preserveCompressionFileNameAsFolder(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preserveCompressionFileNameAsFolder = mapped
    }

    /**
     * @param value The Compression setting type.
     * Expected value is 'TarReadSettings'.
     */
    @JvmName("hwbqbcumroeeefid")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TarReadSettingsArgs = TarReadSettingsArgs(
        preserveCompressionFileNameAsFolder = preserveCompressionFileNameAsFolder,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
