@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.TextFormatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The data stored in text format.
 * @property columnDelimiter The column delimiter. Type: string (or Expression with resultType string).
 * @property deserializer Deserializer. Type: string (or Expression with resultType string).
 * @property encodingName The code page name of the preferred encoding. If miss, the default value is ΓÇ£utf-8ΓÇ¥, unless BOM denotes another Unicode encoding. Refer to the ΓÇ£NameΓÇ¥ column of the table in the following link to set supported values: https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with resultType string).
 * @property escapeChar The escape character. Type: string (or Expression with resultType string).
 * @property firstRowAsHeader When used as input, treat the first row of data as headers. When used as output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or Expression with resultType boolean).
 * @property nullValue The null value string. Type: string (or Expression with resultType string).
 * @property quoteChar The quote character. Type: string (or Expression with resultType string).
 * @property rowDelimiter The row delimiter. Type: string (or Expression with resultType string).
 * @property serializer Serializer. Type: string (or Expression with resultType string).
 * @property skipLineCount The number of lines/rows to be skipped when parsing text files. The default value is 0. Type: integer (or Expression with resultType integer).
 * @property treatEmptyAsNull Treat empty column values in the text file as null. The default value is true. Type: boolean (or Expression with resultType boolean).
 * @property type Type of dataset storage format.
 * Expected value is 'TextFormat'.
 */
public data class TextFormatArgs(
    public val columnDelimiter: Output<Any>? = null,
    public val deserializer: Output<Any>? = null,
    public val encodingName: Output<Any>? = null,
    public val escapeChar: Output<Any>? = null,
    public val firstRowAsHeader: Output<Any>? = null,
    public val nullValue: Output<Any>? = null,
    public val quoteChar: Output<Any>? = null,
    public val rowDelimiter: Output<Any>? = null,
    public val serializer: Output<Any>? = null,
    public val skipLineCount: Output<Any>? = null,
    public val treatEmptyAsNull: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.TextFormatArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.TextFormatArgs =
        com.pulumi.azurenative.datafactory.inputs.TextFormatArgs.builder()
            .columnDelimiter(columnDelimiter?.applyValue({ args0 -> args0 }))
            .deserializer(deserializer?.applyValue({ args0 -> args0 }))
            .encodingName(encodingName?.applyValue({ args0 -> args0 }))
            .escapeChar(escapeChar?.applyValue({ args0 -> args0 }))
            .firstRowAsHeader(firstRowAsHeader?.applyValue({ args0 -> args0 }))
            .nullValue(nullValue?.applyValue({ args0 -> args0 }))
            .quoteChar(quoteChar?.applyValue({ args0 -> args0 }))
            .rowDelimiter(rowDelimiter?.applyValue({ args0 -> args0 }))
            .serializer(serializer?.applyValue({ args0 -> args0 }))
            .skipLineCount(skipLineCount?.applyValue({ args0 -> args0 }))
            .treatEmptyAsNull(treatEmptyAsNull?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TextFormatArgs].
 */
@PulumiTagMarker
public class TextFormatArgsBuilder internal constructor() {
    private var columnDelimiter: Output<Any>? = null

    private var deserializer: Output<Any>? = null

    private var encodingName: Output<Any>? = null

    private var escapeChar: Output<Any>? = null

    private var firstRowAsHeader: Output<Any>? = null

    private var nullValue: Output<Any>? = null

    private var quoteChar: Output<Any>? = null

    private var rowDelimiter: Output<Any>? = null

    private var serializer: Output<Any>? = null

    private var skipLineCount: Output<Any>? = null

    private var treatEmptyAsNull: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value The column delimiter. Type: string (or Expression with resultType string).
     */
    @JvmName("dpmcnobcgvcmjoxr")
    public suspend fun columnDelimiter(`value`: Output<Any>) {
        this.columnDelimiter = value
    }

    /**
     * @param value Deserializer. Type: string (or Expression with resultType string).
     */
    @JvmName("uwwunbrtepdjwawa")
    public suspend fun deserializer(`value`: Output<Any>) {
        this.deserializer = value
    }

    /**
     * @param value The code page name of the preferred encoding. If miss, the default value is ΓÇ£utf-8ΓÇ¥, unless BOM denotes another Unicode encoding. Refer to the ΓÇ£NameΓÇ¥ column of the table in the following link to set supported values: https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with resultType string).
     */
    @JvmName("pefvoavpwchxsapr")
    public suspend fun encodingName(`value`: Output<Any>) {
        this.encodingName = value
    }

    /**
     * @param value The escape character. Type: string (or Expression with resultType string).
     */
    @JvmName("tspmdacpmgsujoie")
    public suspend fun escapeChar(`value`: Output<Any>) {
        this.escapeChar = value
    }

    /**
     * @param value When used as input, treat the first row of data as headers. When used as output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("ohwavontdcnvsjqf")
    public suspend fun firstRowAsHeader(`value`: Output<Any>) {
        this.firstRowAsHeader = value
    }

    /**
     * @param value The null value string. Type: string (or Expression with resultType string).
     */
    @JvmName("gnqfqqtncosdeymu")
    public suspend fun nullValue(`value`: Output<Any>) {
        this.nullValue = value
    }

    /**
     * @param value The quote character. Type: string (or Expression with resultType string).
     */
    @JvmName("ngxrjfylkuamevcb")
    public suspend fun quoteChar(`value`: Output<Any>) {
        this.quoteChar = value
    }

    /**
     * @param value The row delimiter. Type: string (or Expression with resultType string).
     */
    @JvmName("yndalkoivcmqbudp")
    public suspend fun rowDelimiter(`value`: Output<Any>) {
        this.rowDelimiter = value
    }

    /**
     * @param value Serializer. Type: string (or Expression with resultType string).
     */
    @JvmName("gaxpunpehxnwlbag")
    public suspend fun serializer(`value`: Output<Any>) {
        this.serializer = value
    }

    /**
     * @param value The number of lines/rows to be skipped when parsing text files. The default value is 0. Type: integer (or Expression with resultType integer).
     */
    @JvmName("mltrxjpvlprdlwhv")
    public suspend fun skipLineCount(`value`: Output<Any>) {
        this.skipLineCount = value
    }

    /**
     * @param value Treat empty column values in the text file as null. The default value is true. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("tfgnlbtxreqfjhee")
    public suspend fun treatEmptyAsNull(`value`: Output<Any>) {
        this.treatEmptyAsNull = value
    }

    /**
     * @param value Type of dataset storage format.
     * Expected value is 'TextFormat'.
     */
    @JvmName("xwoeqgooxpanjunm")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The column delimiter. Type: string (or Expression with resultType string).
     */
    @JvmName("aatchrcpiiskqkae")
    public suspend fun columnDelimiter(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columnDelimiter = mapped
    }

    /**
     * @param value Deserializer. Type: string (or Expression with resultType string).
     */
    @JvmName("kbkidfvfvvyypkve")
    public suspend fun deserializer(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deserializer = mapped
    }

    /**
     * @param value The code page name of the preferred encoding. If miss, the default value is ΓÇ£utf-8ΓÇ¥, unless BOM denotes another Unicode encoding. Refer to the ΓÇ£NameΓÇ¥ column of the table in the following link to set supported values: https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with resultType string).
     */
    @JvmName("bcyirywthqitjnqi")
    public suspend fun encodingName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encodingName = mapped
    }

    /**
     * @param value The escape character. Type: string (or Expression with resultType string).
     */
    @JvmName("qcfiqnyvchxvuttm")
    public suspend fun escapeChar(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.escapeChar = mapped
    }

    /**
     * @param value When used as input, treat the first row of data as headers. When used as output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("hbvfybofuipabils")
    public suspend fun firstRowAsHeader(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstRowAsHeader = mapped
    }

    /**
     * @param value The null value string. Type: string (or Expression with resultType string).
     */
    @JvmName("vvvbqcjantnsrmyo")
    public suspend fun nullValue(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nullValue = mapped
    }

    /**
     * @param value The quote character. Type: string (or Expression with resultType string).
     */
    @JvmName("jgobphrlbvusqtrk")
    public suspend fun quoteChar(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quoteChar = mapped
    }

    /**
     * @param value The row delimiter. Type: string (or Expression with resultType string).
     */
    @JvmName("qhnsxojfiepnpven")
    public suspend fun rowDelimiter(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rowDelimiter = mapped
    }

    /**
     * @param value Serializer. Type: string (or Expression with resultType string).
     */
    @JvmName("bfemjpsgkqhykarj")
    public suspend fun serializer(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serializer = mapped
    }

    /**
     * @param value The number of lines/rows to be skipped when parsing text files. The default value is 0. Type: integer (or Expression with resultType integer).
     */
    @JvmName("sofeowmptndhvigc")
    public suspend fun skipLineCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipLineCount = mapped
    }

    /**
     * @param value Treat empty column values in the text file as null. The default value is true. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("bnkdwaxcbeshsltd")
    public suspend fun treatEmptyAsNull(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.treatEmptyAsNull = mapped
    }

    /**
     * @param value Type of dataset storage format.
     * Expected value is 'TextFormat'.
     */
    @JvmName("ttkcongciljsfxbt")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TextFormatArgs = TextFormatArgs(
        columnDelimiter = columnDelimiter,
        deserializer = deserializer,
        encodingName = encodingName,
        escapeChar = escapeChar,
        firstRowAsHeader = firstRowAsHeader,
        nullValue = nullValue,
        quoteChar = quoteChar,
        rowDelimiter = rowDelimiter,
        serializer = serializer,
        skipLineCount = skipLineCount,
        treatEmptyAsNull = treatEmptyAsNull,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
