@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.TriggerDependencyReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Trigger referenced dependency.
 * @property referenceTrigger Referenced trigger.
 * @property type The type of dependency reference.
 * Expected value is 'TriggerDependencyReference'.
 */
public data class TriggerDependencyReferenceArgs(
    public val referenceTrigger: Output<TriggerReferenceArgs>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.TriggerDependencyReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.TriggerDependencyReferenceArgs =
        com.pulumi.azurenative.datafactory.inputs.TriggerDependencyReferenceArgs.builder()
            .referenceTrigger(referenceTrigger.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TriggerDependencyReferenceArgs].
 */
@PulumiTagMarker
public class TriggerDependencyReferenceArgsBuilder internal constructor() {
    private var referenceTrigger: Output<TriggerReferenceArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value Referenced trigger.
     */
    @JvmName("lvfrvhrtuwstemil")
    public suspend fun referenceTrigger(`value`: Output<TriggerReferenceArgs>) {
        this.referenceTrigger = value
    }

    /**
     * @param value The type of dependency reference.
     * Expected value is 'TriggerDependencyReference'.
     */
    @JvmName("qusuktnwyjobjspo")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Referenced trigger.
     */
    @JvmName("vgpfrifdmppyyjmv")
    public suspend fun referenceTrigger(`value`: TriggerReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referenceTrigger = mapped
    }

    /**
     * @param argument Referenced trigger.
     */
    @JvmName("stbeqnfjxyiulfor")
    public suspend fun referenceTrigger(argument: suspend TriggerReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = TriggerReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.referenceTrigger = mapped
    }

    /**
     * @param value The type of dependency reference.
     * Expected value is 'TriggerDependencyReference'.
     */
    @JvmName("ugdxjgqxnblxpqpw")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TriggerDependencyReferenceArgs = TriggerDependencyReferenceArgs(
        referenceTrigger = referenceTrigger ?: throw PulumiNullFieldException("referenceTrigger"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
