@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.TriggerPipelineReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Pipeline that needs to be triggered with the given parameters.
 * @property parameters Pipeline parameters.
 * @property pipelineReference Pipeline reference.
 */
public data class TriggerPipelineReferenceArgs(
    public val parameters: Output<Map<String, Any>>? = null,
    public val pipelineReference: Output<PipelineReferenceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.TriggerPipelineReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.TriggerPipelineReferenceArgs =
        com.pulumi.azurenative.datafactory.inputs.TriggerPipelineReferenceArgs.builder()
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .pipelineReference(
                pipelineReference?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [TriggerPipelineReferenceArgs].
 */
@PulumiTagMarker
public class TriggerPipelineReferenceArgsBuilder internal constructor() {
    private var parameters: Output<Map<String, Any>>? = null

    private var pipelineReference: Output<PipelineReferenceArgs>? = null

    /**
     * @param value Pipeline parameters.
     */
    @JvmName("rgatyjfauochboae")
    public suspend fun parameters(`value`: Output<Map<String, Any>>) {
        this.parameters = value
    }

    /**
     * @param value Pipeline reference.
     */
    @JvmName("ufuxtnjejbhjwvai")
    public suspend fun pipelineReference(`value`: Output<PipelineReferenceArgs>) {
        this.pipelineReference = value
    }

    /**
     * @param value Pipeline parameters.
     */
    @JvmName("wrrhdkajwkmxcihi")
    public suspend fun parameters(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values Pipeline parameters.
     */
    @JvmName("uftvxnkawaumdxsv")
    public fun parameters(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Pipeline reference.
     */
    @JvmName("aumlltuiqhnklndh")
    public suspend fun pipelineReference(`value`: PipelineReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineReference = mapped
    }

    /**
     * @param argument Pipeline reference.
     */
    @JvmName("csboqqlowdixtpju")
    public suspend fun pipelineReference(argument: suspend PipelineReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.pipelineReference = mapped
    }

    internal fun build(): TriggerPipelineReferenceArgs = TriggerPipelineReferenceArgs(
        parameters = parameters,
        pipelineReference = pipelineReference,
    )
}
