@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.TumblingWindowTriggerDependencyReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Referenced tumbling window trigger dependency.
 * @property offset Timespan applied to the start time of a tumbling window when evaluating dependency.
 * @property referenceTrigger Referenced trigger.
 * @property size The size of the window when evaluating the dependency. If undefined the frequency of the tumbling window will be used.
 * @property type The type of dependency reference.
 * Expected value is 'TumblingWindowTriggerDependencyReference'.
 */
public data class TumblingWindowTriggerDependencyReferenceArgs(
    public val offset: Output<String>? = null,
    public val referenceTrigger: Output<TriggerReferenceArgs>,
    public val size: Output<String>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.TumblingWindowTriggerDependencyReferenceArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.TumblingWindowTriggerDependencyReferenceArgs =
        com.pulumi.azurenative.datafactory.inputs.TumblingWindowTriggerDependencyReferenceArgs.builder()
            .offset(offset?.applyValue({ args0 -> args0 }))
            .referenceTrigger(referenceTrigger.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .size(size?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TumblingWindowTriggerDependencyReferenceArgs].
 */
@PulumiTagMarker
public class TumblingWindowTriggerDependencyReferenceArgsBuilder internal constructor() {
    private var offset: Output<String>? = null

    private var referenceTrigger: Output<TriggerReferenceArgs>? = null

    private var size: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Timespan applied to the start time of a tumbling window when evaluating dependency.
     */
    @JvmName("qddmmgfkscfvckrb")
    public suspend fun offset(`value`: Output<String>) {
        this.offset = value
    }

    /**
     * @param value Referenced trigger.
     */
    @JvmName("dgwgqrfsisgupvfs")
    public suspend fun referenceTrigger(`value`: Output<TriggerReferenceArgs>) {
        this.referenceTrigger = value
    }

    /**
     * @param value The size of the window when evaluating the dependency. If undefined the frequency of the tumbling window will be used.
     */
    @JvmName("umormasvmslrbklm")
    public suspend fun size(`value`: Output<String>) {
        this.size = value
    }

    /**
     * @param value The type of dependency reference.
     * Expected value is 'TumblingWindowTriggerDependencyReference'.
     */
    @JvmName("oumdrhpcbfxqvawl")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Timespan applied to the start time of a tumbling window when evaluating dependency.
     */
    @JvmName("gggkcjkrvhfctuht")
    public suspend fun offset(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offset = mapped
    }

    /**
     * @param value Referenced trigger.
     */
    @JvmName("qqhmtfofmqlemmsl")
    public suspend fun referenceTrigger(`value`: TriggerReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referenceTrigger = mapped
    }

    /**
     * @param argument Referenced trigger.
     */
    @JvmName("wowwkrqfftohcvyb")
    public suspend fun referenceTrigger(argument: suspend TriggerReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = TriggerReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.referenceTrigger = mapped
    }

    /**
     * @param value The size of the window when evaluating the dependency. If undefined the frequency of the tumbling window will be used.
     */
    @JvmName("xeogvhjhsqhyrhdu")
    public suspend fun size(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The type of dependency reference.
     * Expected value is 'TumblingWindowTriggerDependencyReference'.
     */
    @JvmName("ngwcohwvlbrqabur")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TumblingWindowTriggerDependencyReferenceArgs =
        TumblingWindowTriggerDependencyReferenceArgs(
            offset = offset,
            referenceTrigger = referenceTrigger ?: throw PulumiNullFieldException("referenceTrigger"),
            size = size,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
