@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.UserPropertyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * User property.
 * @property name User property name.
 * @property value User property value. Type: string (or Expression with resultType string).
 */
public data class UserPropertyArgs(
    public val name: Output<String>,
    public val `value`: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.UserPropertyArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.UserPropertyArgs =
        com.pulumi.azurenative.datafactory.inputs.UserPropertyArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPropertyArgs].
 */
@PulumiTagMarker
public class UserPropertyArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<Any>? = null

    /**
     * @param value User property name.
     */
    @JvmName("wemvaxreywvuljwt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value User property value. Type: string (or Expression with resultType string).
     */
    @JvmName("dqgeyoggdgvdypxx")
    public suspend fun `value`(`value`: Output<Any>) {
        this.`value` = value
    }

    /**
     * @param value User property name.
     */
    @JvmName("fvbxilciuykhcvuh")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value User property value. Type: string (or Expression with resultType string).
     */
    @JvmName("nadoifkslkecxdbq")
    public suspend fun `value`(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): UserPropertyArgs = UserPropertyArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
