@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.VariableSpecificationArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.VariableType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Definition of a single variable for a Pipeline.
 * @property defaultValue Default value of variable.
 * @property type Variable type.
 */
public data class VariableSpecificationArgs(
    public val defaultValue: Output<Any>? = null,
    public val type: Output<Either<String, VariableType>>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.VariableSpecificationArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.VariableSpecificationArgs =
        com.pulumi.azurenative.datafactory.inputs.VariableSpecificationArgs.builder()
            .defaultValue(defaultValue?.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [VariableSpecificationArgs].
 */
@PulumiTagMarker
public class VariableSpecificationArgsBuilder internal constructor() {
    private var defaultValue: Output<Any>? = null

    private var type: Output<Either<String, VariableType>>? = null

    /**
     * @param value Default value of variable.
     */
    @JvmName("ywajavyplwvuatmj")
    public suspend fun defaultValue(`value`: Output<Any>) {
        this.defaultValue = value
    }

    /**
     * @param value Variable type.
     */
    @JvmName("olfngsamnbftxqma")
    public suspend fun type(`value`: Output<Either<String, VariableType>>) {
        this.type = value
    }

    /**
     * @param value Default value of variable.
     */
    @JvmName("puqkrebtksnadenq")
    public suspend fun defaultValue(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultValue = mapped
    }

    /**
     * @param value Variable type.
     */
    @JvmName("waetbrarqbamtlbt")
    public suspend fun type(`value`: Either<String, VariableType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Variable type.
     */
    @JvmName("nwleiuoreronpmtb")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VariableType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Variable type.
     */
    @JvmName("oiigqrudblxcufxj")
    public fun type(`value`: VariableType) {
        val toBeMapped = Either.ofRight<String, VariableType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): VariableSpecificationArgs = VariableSpecificationArgs(
        defaultValue = defaultValue,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
