@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.WranglingDataFlowArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Power Query data flow.
 * @property annotations List of tags that can be used for describing the data flow.
 * @property description The description of the data flow.
 * @property documentLocale Locale of the Power query mashup document.
 * @property folder The folder that this data flow is in. If not specified, Data flow will appear at the root level.
 * @property script Power query mashup script.
 * @property sources List of sources in Power Query.
 * @property type Type of data flow.
 * Expected value is 'WranglingDataFlow'.
 */
public data class WranglingDataFlowArgs(
    public val annotations: Output<List<Any>>? = null,
    public val description: Output<String>? = null,
    public val documentLocale: Output<String>? = null,
    public val folder: Output<DataFlowFolderArgs>? = null,
    public val script: Output<String>? = null,
    public val sources: Output<List<PowerQuerySourceArgs>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.WranglingDataFlowArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.WranglingDataFlowArgs =
        com.pulumi.azurenative.datafactory.inputs.WranglingDataFlowArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .documentLocale(documentLocale?.applyValue({ args0 -> args0 }))
            .folder(folder?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .script(script?.applyValue({ args0 -> args0 }))
            .sources(
                sources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WranglingDataFlowArgs].
 */
@PulumiTagMarker
public class WranglingDataFlowArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var description: Output<String>? = null

    private var documentLocale: Output<String>? = null

    private var folder: Output<DataFlowFolderArgs>? = null

    private var script: Output<String>? = null

    private var sources: Output<List<PowerQuerySourceArgs>>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the data flow.
     */
    @JvmName("aenmjmldlochowwq")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("cmrtcmwxaqmwrghm")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the data flow.
     */
    @JvmName("jfwyflqtqgwekqbl")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The description of the data flow.
     */
    @JvmName("fpnowqxygbmugusj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Locale of the Power query mashup document.
     */
    @JvmName("fqfikfsxhrljvakp")
    public suspend fun documentLocale(`value`: Output<String>) {
        this.documentLocale = value
    }

    /**
     * @param value The folder that this data flow is in. If not specified, Data flow will appear at the root level.
     */
    @JvmName("hnobuysbrekpitaw")
    public suspend fun folder(`value`: Output<DataFlowFolderArgs>) {
        this.folder = value
    }

    /**
     * @param value Power query mashup script.
     */
    @JvmName("yppgrevxtvqrhyow")
    public suspend fun script(`value`: Output<String>) {
        this.script = value
    }

    /**
     * @param value List of sources in Power Query.
     */
    @JvmName("cahxuagxlecsokes")
    public suspend fun sources(`value`: Output<List<PowerQuerySourceArgs>>) {
        this.sources = value
    }

    @JvmName("nfqqhqwywwxgpfef")
    public suspend fun sources(vararg values: Output<PowerQuerySourceArgs>) {
        this.sources = Output.all(values.asList())
    }

    /**
     * @param values List of sources in Power Query.
     */
    @JvmName("impjramroqujspdj")
    public suspend fun sources(values: List<Output<PowerQuerySourceArgs>>) {
        this.sources = Output.all(values)
    }

    /**
     * @param value Type of data flow.
     * Expected value is 'WranglingDataFlow'.
     */
    @JvmName("yvyqqdqwlnfflqsq")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the data flow.
     */
    @JvmName("xhtupajqqqdalmpk")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the data flow.
     */
    @JvmName("ydhogilpqbgglplp")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The description of the data flow.
     */
    @JvmName("ecjaijqqfcothhts")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Locale of the Power query mashup document.
     */
    @JvmName("kcohihwltfaoircp")
    public suspend fun documentLocale(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentLocale = mapped
    }

    /**
     * @param value The folder that this data flow is in. If not specified, Data flow will appear at the root level.
     */
    @JvmName("exnjnxhqlsqtjlhy")
    public suspend fun folder(`value`: DataFlowFolderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folder = mapped
    }

    /**
     * @param argument The folder that this data flow is in. If not specified, Data flow will appear at the root level.
     */
    @JvmName("wpcebecuodiadmkl")
    public suspend fun folder(argument: suspend DataFlowFolderArgsBuilder.() -> Unit) {
        val toBeMapped = DataFlowFolderArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.folder = mapped
    }

    /**
     * @param value Power query mashup script.
     */
    @JvmName("oningsiljhefrdim")
    public suspend fun script(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.script = mapped
    }

    /**
     * @param value List of sources in Power Query.
     */
    @JvmName("sbasfsgupwpdgdox")
    public suspend fun sources(`value`: List<PowerQuerySourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param argument List of sources in Power Query.
     */
    @JvmName("iowftlcmqhvpqdam")
    public suspend fun sources(argument: List<suspend PowerQuerySourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PowerQuerySourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument List of sources in Power Query.
     */
    @JvmName("wncinrcltmneltlg")
    public suspend fun sources(vararg argument: suspend PowerQuerySourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PowerQuerySourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument List of sources in Power Query.
     */
    @JvmName("vbhlovdbarjnwbxq")
    public suspend fun sources(argument: suspend PowerQuerySourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PowerQuerySourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param values List of sources in Power Query.
     */
    @JvmName("fgnbitvotmqnckxk")
    public suspend fun sources(vararg values: PowerQuerySourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param value Type of data flow.
     * Expected value is 'WranglingDataFlow'.
     */
    @JvmName("npcffswbpltehjlm")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): WranglingDataFlowArgs = WranglingDataFlowArgs(
        annotations = annotations,
        description = description,
        documentLocale = documentLocale,
        folder = folder,
        script = script,
        sources = sources,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
